/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.tokenattributes;

import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.d;

public class PositionLengthAttributeImpl
extends AttributeImpl
implements Cloneable,
PositionLengthAttribute {
    private int positionLength = 1;

    @Override
    public void setPositionLength(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("Position length must be 1 or greater: got " + n2);
        }
        this.positionLength = n2;
    }

    @Override
    public int getPositionLength() {
        return this.positionLength;
    }

    @Override
    public void clear() {
        this.positionLength = 1;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof PositionLengthAttributeImpl) {
            PositionLengthAttributeImpl positionLengthAttributeImpl = (PositionLengthAttributeImpl)object;
            return this.positionLength == positionLengthAttributeImpl.positionLength;
        }
        return false;
    }

    public int hashCode() {
        return this.positionLength;
    }

    @Override
    public void copyTo(AttributeImpl attributeImpl) {
        PositionLengthAttribute positionLengthAttribute = (PositionLengthAttribute)((Object)attributeImpl);
        positionLengthAttribute.setPositionLength(this.positionLength);
    }

    @Override
    public void reflectWith(d d2) {
        d2.reflect(PositionLengthAttribute.class, "positionLength", this.positionLength);
    }
}

