/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.util;

import java.io.IOException;
import java.io.Reader;

public abstract class CharacterUtils {
    private static final Java4CharacterUtils JAVA_4 = new Java4CharacterUtils();
    private static final Java5CharacterUtils JAVA_5 = new Java5CharacterUtils();

    public static CharacterUtils getInstance() {
        return JAVA_5;
    }

    public abstract int codePointAt(char[] var1, int var2, int var3);

    public static CharacterBuffer newCharacterBuffer(int n2) {
        if (n2 < 2) {
            throw new IllegalArgumentException("buffersize must be >= 2");
        }
        return new CharacterBuffer(new char[n2], 0, 0);
    }

    public abstract boolean fill(CharacterBuffer var1, Reader var2, int var3) throws IOException;

    public final boolean fill(CharacterBuffer characterBuffer, Reader reader) throws IOException {
        return this.fill(characterBuffer, reader, characterBuffer.buffer.length);
    }

    static int readFully(Reader reader, char[] cArray, int n2, int n3) throws IOException {
        int n4;
        int n5;
        for (n4 = 0; n4 < n3 && (n5 = reader.read(cArray, n2 + n4, n3 - n4)) != -1; n4 += n5) {
        }
        return n4;
    }

    public static final class CharacterBuffer {
        private final char[] buffer;
        private int offset;
        private int length;
        char lastTrailingHighSurrogate;

        CharacterBuffer(char[] cArray, int n2, int n3) {
            this.buffer = cArray;
            this.offset = n2;
            this.length = n3;
        }

        public char[] getBuffer() {
            return this.buffer;
        }

        public int getLength() {
            return this.length;
        }

        public void reset() {
            this.offset = 0;
            this.length = 0;
            this.lastTrailingHighSurrogate = '\u0000';
        }
    }

    private static final class Java4CharacterUtils
    extends CharacterUtils {
        Java4CharacterUtils() {
        }

        @Override
        public int codePointAt(char[] cArray, int n2, int n3) {
            if (n2 >= n3) {
                throw new IndexOutOfBoundsException("offset must be less than limit");
            }
            return cArray[n2];
        }

        @Override
        public boolean fill(CharacterBuffer characterBuffer, Reader reader, int n2) throws IOException {
            assert (characterBuffer.buffer.length >= 1);
            if (n2 < 1 || n2 > characterBuffer.buffer.length) {
                throw new IllegalArgumentException("numChars must be >= 1 and <= the buffer size");
            }
            characterBuffer.offset = 0;
            int n3 = Java4CharacterUtils.readFully(reader, characterBuffer.buffer, 0, n2);
            characterBuffer.length = n3;
            characterBuffer.lastTrailingHighSurrogate = '\u0000';
            return n3 == n2;
        }
    }

    private static final class Java5CharacterUtils
    extends CharacterUtils {
        Java5CharacterUtils() {
        }

        @Override
        public int codePointAt(char[] cArray, int n2, int n3) {
            return Character.codePointAt(cArray, n2, n3);
        }

        @Override
        public boolean fill(CharacterBuffer characterBuffer, Reader reader, int n2) throws IOException {
            boolean bl;
            int n3;
            assert (characterBuffer.buffer.length >= 2);
            if (n2 < 2 || n2 > characterBuffer.buffer.length) {
                throw new IllegalArgumentException("numChars must be >= 2 and <= the buffer size");
            }
            char[] cArray = characterBuffer.buffer;
            characterBuffer.offset = 0;
            if (characterBuffer.lastTrailingHighSurrogate != '\u0000') {
                cArray[0] = characterBuffer.lastTrailingHighSurrogate;
                characterBuffer.lastTrailingHighSurrogate = '\u0000';
                n3 = 1;
            } else {
                n3 = 0;
            }
            int n4 = Java5CharacterUtils.readFully(reader, cArray, n3, n2 - n3);
            characterBuffer.length = n3 + n4;
            boolean bl2 = bl = characterBuffer.length == n2;
            if (characterBuffer.length < n2) {
                return bl;
            }
            if (Character.isHighSurrogate(cArray[characterBuffer.length - 1])) {
                characterBuffer.lastTrailingHighSurrogate = cArray[--characterBuffer.length];
            }
            return bl;
        }
    }
}

