/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import org.apache.lucene.index.OrdTermState;
import org.apache.lucene.index.q;

public class BlockTermState
extends OrdTermState {
    public int docFreq;
    public long totalTermFreq;
    public int termBlockOrd;
    public long blockFilePointer;
    public boolean isRealTerm = true;

    protected BlockTermState() {
    }

    @Override
    public void copyFrom(q q2) {
        assert (q2 instanceof BlockTermState) : "can not copy from " + q2.getClass().getName();
        BlockTermState blockTermState = (BlockTermState)q2;
        super.copyFrom(q2);
        this.docFreq = blockTermState.docFreq;
        this.totalTermFreq = blockTermState.totalTermFreq;
        this.termBlockOrd = blockTermState.termBlockOrd;
        this.blockFilePointer = blockTermState.blockFilePointer;
        this.isRealTerm = blockTermState.isRealTerm;
    }

    @Override
    public boolean isRealTerm() {
        return this.isRealTerm;
    }

    @Override
    public String toString() {
        return "docFreq=" + this.docFreq + " totalTermFreq=" + this.totalTermFreq + " termBlockOrd=" + this.termBlockOrd + " blockFP=" + this.blockFilePointer + " isRealTerm=" + this.isRealTerm;
    }
}

