/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.codecs.p;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;

public abstract class TermVectorsWriter
implements Closeable {
    protected TermVectorsWriter() {
    }

    public abstract void startDocument(int var1) throws IOException;

    public void finishDocument() throws IOException {
    }

    public abstract void startField(FieldInfo var1, int var2, boolean var3, boolean var4, boolean var5) throws IOException;

    public void finishField() throws IOException {
    }

    public abstract void startTerm(BytesRef var1, int var2) throws IOException;

    public void finishTerm() throws IOException {
    }

    public abstract void addPosition(int var1, int var2, int var3, BytesRef var4) throws IOException;

    public abstract void finish(FieldInfos var1, int var2) throws IOException;

    public void addProx(int n2, DataInput dataInput, DataInput dataInput2) throws IOException {
        int n3 = 0;
        int n4 = 0;
        BytesRefBuilder bytesRefBuilder = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n5;
            int n6;
            BytesRef bytesRef;
            if (dataInput == null) {
                n3 = -1;
                bytesRef = null;
            } else {
                int n7 = dataInput.readVInt();
                n3 += n7 >>> 1;
                if ((n7 & 1) != 0) {
                    int n8 = dataInput.readVInt();
                    if (bytesRefBuilder == null) {
                        bytesRefBuilder = new BytesRefBuilder();
                    }
                    bytesRefBuilder.grow(n8);
                    dataInput.readBytes(bytesRefBuilder.bytes(), 0, n8);
                    bytesRefBuilder.setLength(n8);
                    bytesRef = bytesRefBuilder.get();
                } else {
                    bytesRef = null;
                }
            }
            if (dataInput2 == null) {
                n6 = -1;
                n5 = -1;
            } else {
                n5 = n4 + dataInput2.readVInt();
                n4 = n6 = n5 + dataInput2.readVInt();
            }
            this.addPosition(n3, n5, n6, bytesRef);
        }
    }

    public int merge(MergeState mergeState) throws IOException {
        int n2 = 0;
        int n3 = mergeState.maxDocs.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = mergeState.maxDocs[i2];
            Bits bits = mergeState.liveDocs[i2];
            p p2 = mergeState.termVectorsReaders[i2];
            if (p2 != null) {
                p2.checkIntegrity();
            }
            for (int i3 = 0; i3 < n4; ++i3) {
                if (bits != null && !bits.get(i3)) continue;
                Fields fields = p2 == null ? null : p2.get(i3);
                this.addAllDocVectors(fields, mergeState);
                ++n2;
            }
        }
        this.finish(mergeState.mergeFieldInfos, n2);
        return n2;
    }

    protected final void addAllDocVectors(Fields fields, MergeState mergeState) throws IOException {
        Object object;
        if (fields == null) {
            this.startDocument(0);
            this.finishDocument();
            return;
        }
        int n2 = fields.size();
        if (n2 == -1) {
            n2 = 0;
            object = fields.iterator();
            while (object.hasNext()) {
                object.next();
                ++n2;
            }
        }
        this.startDocument(n2);
        object = null;
        TermsEnum termsEnum = null;
        PostingsEnum postingsEnum = null;
        int n3 = 0;
        for (String string : fields) {
            ++n3;
            FieldInfo fieldInfo = mergeState.mergeFieldInfos.fieldInfo(string);
            assert (object == null || string.compareTo((String)object) > 0) : "lastFieldName=" + (String)object + " fieldName=" + string;
            object = string;
            Terms terms = fields.terms(string);
            if (terms == null) continue;
            boolean bl = terms.hasPositions();
            boolean bl2 = terms.hasOffsets();
            boolean bl3 = terms.hasPayloads();
            assert (!bl3 || bl);
            int n4 = (int)terms.size();
            if (n4 == -1) {
                n4 = 0;
                termsEnum = terms.iterator();
                while (termsEnum.next() != null) {
                    ++n4;
                }
            }
            this.startField(fieldInfo, n4, bl, bl2, bl3);
            termsEnum = terms.iterator();
            int n5 = 0;
            while (termsEnum.next() != null) {
                ++n5;
                int n6 = (int)termsEnum.totalTermFreq();
                this.startTerm(termsEnum.term(), n6);
                if (bl || bl2) {
                    postingsEnum = termsEnum.postings(postingsEnum, 120);
                    assert (postingsEnum != null);
                    int n7 = postingsEnum.nextDoc();
                    assert (n7 != Integer.MAX_VALUE);
                    assert (postingsEnum.freq() == n6);
                    for (int i2 = 0; i2 < n6; ++i2) {
                        int n8 = postingsEnum.nextPosition();
                        int n9 = postingsEnum.startOffset();
                        int n10 = postingsEnum.endOffset();
                        BytesRef bytesRef = postingsEnum.getPayload();
                        assert (!bl || n8 >= 0);
                        this.addPosition(n8, n9, n10, bytesRef);
                    }
                }
                this.finishTerm();
            }
            assert (n5 == n4);
            this.finishField();
        }
        assert (n3 == n2);
        this.finishDocument();
    }

    @Override
    public abstract void close() throws IOException;
}

