/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.compressing;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.codecs.compressing.CompressingStoredFieldsIndexReader;
import org.apache.lucene.codecs.compressing.CompressingStoredFieldsIndexWriter;
import org.apache.lucene.codecs.compressing.CompressingStoredFieldsReader;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.compressing.MatchingReaders;
import org.apache.lucene.codecs.compressing.a;
import org.apache.lucene.codecs.n;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.j;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.c;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.GrowableByteArrayDataOutput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.packed.PackedInts;

public final class CompressingStoredFieldsWriter
extends StoredFieldsWriter {
    static final int TYPE_BITS = PackedInts.bitsRequired(5L);
    static final int TYPE_MASK = (int)PackedInts.maxValue(TYPE_BITS);
    private final String segment;
    private CompressingStoredFieldsIndexWriter indexWriter;
    private IndexOutput fieldsStream;
    private final a compressor;
    private final CompressionMode compressionMode;
    private final int chunkSize;
    private final int maxDocsPerChunk;
    private final GrowableByteArrayDataOutput bufferedDocs;
    private int[] numStoredFields;
    private int[] endOffsets;
    private int docBase;
    private int numBufferedDocs;
    private long numChunks;
    private long numDirtyChunks;
    private int numStoredFieldsInDoc;
    byte[] scratchBytes = new byte[16];
    static final int NEGATIVE_ZERO_FLOAT = Float.floatToIntBits(-0.0f);
    static final long NEGATIVE_ZERO_DOUBLE = Double.doubleToLongBits(-0.0);
    static final String BULK_MERGE_ENABLED_SYSPROP = CompressingStoredFieldsWriter.class.getName() + ".enableBulkMerge";
    static final boolean BULK_MERGE_ENABLED;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CompressingStoredFieldsWriter(c c2, SegmentInfo segmentInfo, String string, IOContext iOContext, String string2, CompressionMode compressionMode, int n2, int n3, int n4) throws IOException {
        assert (c2 != null);
        this.segment = segmentInfo.name;
        this.compressionMode = compressionMode;
        this.compressor = compressionMode.newCompressor();
        this.chunkSize = n2;
        this.maxDocsPerChunk = n3;
        this.docBase = 0;
        this.bufferedDocs = new GrowableByteArrayDataOutput(n2);
        this.numStoredFields = new int[16];
        this.endOffsets = new int[16];
        this.numBufferedDocs = 0;
        boolean bl = false;
        IndexOutput indexOutput = c2.createOutput(IndexFileNames.segmentFileName(this.segment, string, "fdx"), iOContext);
        try {
            this.fieldsStream = c2.createOutput(IndexFileNames.segmentFileName(this.segment, string, "fdt"), iOContext);
            String string3 = string2 + "Index";
            String string4 = string2 + "Data";
            CodecUtil.writeIndexHeader(indexOutput, string3, 1, segmentInfo.getId(), string);
            CodecUtil.writeIndexHeader(this.fieldsStream, string4, 1, segmentInfo.getId(), string);
            assert ((long)CodecUtil.indexHeaderLength(string4, string) == this.fieldsStream.getFilePointer());
            assert ((long)CodecUtil.indexHeaderLength(string3, string) == indexOutput.getFilePointer());
            this.indexWriter = new CompressingStoredFieldsIndexWriter(indexOutput, n4);
            indexOutput = null;
            this.fieldsStream.writeVInt(n2);
            this.fieldsStream.writeVInt(2);
            return;
        }
        catch (Throwable throwable) {
            if (bl) throw throwable;
            IOUtils.closeWhileHandlingException(this.fieldsStream, indexOutput, this.indexWriter);
            throw throwable;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            IOUtils.close(this.fieldsStream, this.indexWriter);
        }
        finally {
            this.fieldsStream = null;
            this.indexWriter = null;
        }
    }

    @Override
    public void startDocument() throws IOException {
    }

    @Override
    public void finishDocument() throws IOException {
        if (this.numBufferedDocs == this.numStoredFields.length) {
            int n2 = ArrayUtil.oversize(this.numBufferedDocs + 1, 4);
            this.numStoredFields = Arrays.copyOf(this.numStoredFields, n2);
            this.endOffsets = Arrays.copyOf(this.endOffsets, n2);
        }
        this.numStoredFields[this.numBufferedDocs] = this.numStoredFieldsInDoc;
        this.numStoredFieldsInDoc = 0;
        this.endOffsets[this.numBufferedDocs] = this.bufferedDocs.length;
        ++this.numBufferedDocs;
        if (this.triggerFlush()) {
            this.flush();
        }
    }

    private static void saveInts(int[] nArray, int n2, DataOutput dataOutput) throws IOException {
        assert (n2 > 0);
        if (n2 == 1) {
            dataOutput.writeVInt(nArray[0]);
        } else {
            boolean bl = true;
            for (int i2 = 1; i2 < n2; ++i2) {
                if (nArray[i2] == nArray[0]) continue;
                bl = false;
                break;
            }
            if (bl) {
                dataOutput.writeVInt(0);
                dataOutput.writeVInt(nArray[0]);
            } else {
                int n3;
                long l2 = 0L;
                for (n3 = 0; n3 < n2; ++n3) {
                    l2 |= (long)nArray[n3];
                }
                n3 = PackedInts.bitsRequired(l2);
                dataOutput.writeVInt(n3);
                PackedInts.Writer writer = PackedInts.getWriterNoHeader(dataOutput, PackedInts.Format.PACKED, n2, n3, 1);
                for (int i3 = 0; i3 < n2; ++i3) {
                    writer.add(nArray[i3]);
                }
                writer.finish();
            }
        }
    }

    private void writeHeader(int n2, int n3, int[] nArray, int[] nArray2, boolean bl) throws IOException {
        int n4 = bl ? 1 : 0;
        this.fieldsStream.writeVInt(n2);
        this.fieldsStream.writeVInt(n3 << 1 | n4);
        CompressingStoredFieldsWriter.saveInts(nArray, n3, this.fieldsStream);
        CompressingStoredFieldsWriter.saveInts(nArray2, n3, this.fieldsStream);
    }

    private boolean triggerFlush() {
        return this.bufferedDocs.length >= this.chunkSize || this.numBufferedDocs >= this.maxDocsPerChunk;
    }

    private void flush() throws IOException {
        int n2;
        this.indexWriter.writeIndex(this.numBufferedDocs, this.fieldsStream.getFilePointer());
        int[] nArray = this.endOffsets;
        for (n2 = this.numBufferedDocs - 1; n2 > 0; --n2) {
            nArray[n2] = this.endOffsets[n2] - this.endOffsets[n2 - 1];
            assert (nArray[n2] >= 0);
        }
        n2 = this.bufferedDocs.length >= 2 * this.chunkSize ? 1 : 0;
        this.writeHeader(this.docBase, this.numBufferedDocs, this.numStoredFields, nArray, n2 != 0);
        if (n2 != 0) {
            for (int i2 = 0; i2 < this.bufferedDocs.length; i2 += this.chunkSize) {
                this.compressor.compress(this.bufferedDocs.bytes, i2, Math.min(this.chunkSize, this.bufferedDocs.length - i2), this.fieldsStream);
            }
        } else {
            this.compressor.compress(this.bufferedDocs.bytes, 0, this.bufferedDocs.length, this.fieldsStream);
        }
        this.docBase += this.numBufferedDocs;
        this.numBufferedDocs = 0;
        this.bufferedDocs.length = 0;
        ++this.numChunks;
    }

    @Override
    public void writeField(FieldInfo fieldInfo, j j2) throws IOException {
        BytesRef bytesRef;
        String string;
        ++this.numStoredFieldsInDoc;
        int n2 = 0;
        Number number = j2.numericValue();
        if (number != null) {
            if (number instanceof Byte || number instanceof Short || number instanceof Integer) {
                n2 = 2;
            } else if (number instanceof Long) {
                n2 = 4;
            } else if (number instanceof Float) {
                n2 = 3;
            } else if (number instanceof Double) {
                n2 = 5;
            } else {
                throw new IllegalArgumentException("cannot store numeric type " + number.getClass());
            }
            string = null;
            bytesRef = null;
        } else {
            bytesRef = j2.binaryValue();
            if (bytesRef != null) {
                n2 = 1;
                string = null;
            } else {
                n2 = 0;
                string = j2.stringValue();
                if (string == null) {
                    throw new IllegalArgumentException("field " + j2.name() + " is stored but does not have binaryValue, stringValue nor numericValue");
                }
            }
        }
        long l2 = (long)fieldInfo.number << TYPE_BITS | (long)n2;
        this.bufferedDocs.writeVLong(l2);
        if (bytesRef != null) {
            this.bufferedDocs.writeVInt(bytesRef.length);
            this.bufferedDocs.writeBytes(bytesRef.bytes, bytesRef.offset, bytesRef.length);
        } else if (string != null) {
            this.scratchBytes = ArrayUtil.grow(this.scratchBytes, string.length() * 3);
            int n3 = UnicodeUtil.UTF16toUTF8(string, 0, string.length(), this.scratchBytes);
            this.bufferedDocs.writeVInt(n3);
            this.bufferedDocs.writeBytes(this.scratchBytes, n3);
        } else if (number instanceof Byte || number instanceof Short || number instanceof Integer) {
            this.bufferedDocs.writeZInt(number.intValue());
        } else if (number instanceof Long) {
            CompressingStoredFieldsWriter.writeTLong(this.bufferedDocs, number.longValue());
        } else if (number instanceof Float) {
            CompressingStoredFieldsWriter.writeZFloat(this.bufferedDocs, number.floatValue());
        } else if (number instanceof Double) {
            CompressingStoredFieldsWriter.writeZDouble(this.bufferedDocs, number.doubleValue());
        } else {
            throw new AssertionError((Object)"Cannot get here");
        }
    }

    static void writeZFloat(DataOutput dataOutput, float f2) throws IOException {
        int n2 = (int)f2;
        int n3 = Float.floatToIntBits(f2);
        if (f2 == (float)n2 && n2 >= -1 && n2 <= 125 && n3 != NEGATIVE_ZERO_FLOAT) {
            dataOutput.writeByte((byte)(0x80 | 1 + n2));
        } else if (n3 >>> 31 == 0) {
            dataOutput.writeInt(n3);
        } else {
            dataOutput.writeByte((byte)-1);
            dataOutput.writeInt(n3);
        }
    }

    static void writeZDouble(DataOutput dataOutput, double d2) throws IOException {
        int n2 = (int)d2;
        long l2 = Double.doubleToLongBits(d2);
        if (d2 == (double)n2 && n2 >= -1 && n2 <= 124 && l2 != NEGATIVE_ZERO_DOUBLE) {
            dataOutput.writeByte((byte)(0x80 | n2 + 1));
            return;
        }
        if (d2 == (double)((float)d2)) {
            dataOutput.writeByte((byte)-2);
            dataOutput.writeInt(Float.floatToIntBits((float)d2));
        } else if (l2 >>> 63 == 0L) {
            dataOutput.writeLong(l2);
        } else {
            dataOutput.writeByte((byte)-1);
            dataOutput.writeLong(l2);
        }
    }

    static void writeTLong(DataOutput dataOutput, long l2) throws IOException {
        int n2;
        if (l2 % 1000L != 0L) {
            n2 = 0;
        } else if (l2 % 86400000L == 0L) {
            n2 = 192;
            l2 /= 86400000L;
        } else if (l2 % 3600000L == 0L) {
            n2 = 128;
            l2 /= 3600000L;
        } else {
            n2 = 64;
            l2 /= 1000L;
        }
        long l3 = BitUtil.zigZagEncode(l2);
        n2 = (int)((long)n2 | l3 & 0x1FL);
        long l4 = l3 >>> 5;
        if (l4 != 0L) {
            n2 |= 0x20;
        }
        dataOutput.writeByte((byte)n2);
        if (l4 != 0L) {
            dataOutput.writeVLong(l4);
        }
    }

    @Override
    public void finish(FieldInfos fieldInfos, int n2) throws IOException {
        if (this.numBufferedDocs > 0) {
            this.flush();
            ++this.numDirtyChunks;
        } else assert (this.bufferedDocs.length == 0);
        if (this.docBase != n2) {
            throw new RuntimeException("Wrote " + this.docBase + " docs, finish called with numDocs=" + n2);
        }
        this.indexWriter.finish(n2, this.fieldsStream.getFilePointer());
        this.fieldsStream.writeVLong(this.numChunks);
        this.fieldsStream.writeVLong(this.numDirtyChunks);
        CodecUtil.writeFooter(this.fieldsStream);
        assert (this.bufferedDocs.length == 0);
    }

    @Override
    public int merge(MergeState mergeState) throws IOException {
        int n2 = 0;
        int n3 = mergeState.maxDocs.length;
        MatchingReaders matchingReaders = new MatchingReaders(mergeState);
        for (int i2 = 0; i2 < n3; ++i2) {
            n n4;
            StoredFieldsWriter.MergeVisitor mergeVisitor = new StoredFieldsWriter.MergeVisitor(mergeState, i2);
            CompressingStoredFieldsReader compressingStoredFieldsReader = null;
            if (matchingReaders.matchingReaders[i2] && (n4 = mergeState.storedFieldsReaders[i2]) != null && n4 instanceof CompressingStoredFieldsReader) {
                compressingStoredFieldsReader = (CompressingStoredFieldsReader)n4;
            }
            int n5 = mergeState.maxDocs[i2];
            Bits bits = mergeState.liveDocs[i2];
            if (compressingStoredFieldsReader == null || compressingStoredFieldsReader.getVersion() != 1 || !BULK_MERGE_ENABLED) {
                n n6 = mergeState.storedFieldsReaders[i2];
                if (n6 != null) {
                    n6.checkIntegrity();
                }
                for (int i3 = 0; i3 < n5; ++i3) {
                    if (bits != null && !bits.get(i3)) continue;
                    this.startDocument();
                    n6.visitDocument(i3, mergeVisitor);
                    this.finishDocument();
                    ++n2;
                }
                continue;
            }
            if (compressingStoredFieldsReader.getCompressionMode() == this.compressionMode && compressingStoredFieldsReader.getChunkSize() == this.chunkSize && compressingStoredFieldsReader.getPackedIntsVersion() == 2 && bits == null && !this.tooDirty(compressingStoredFieldsReader)) {
                assert (compressingStoredFieldsReader.getVersion() == 1);
                compressingStoredFieldsReader.checkIntegrity();
                if (this.numBufferedDocs > 0) {
                    this.flush();
                    ++this.numDirtyChunks;
                }
                IndexInput indexInput = compressingStoredFieldsReader.getFieldsStream();
                CompressingStoredFieldsIndexReader compressingStoredFieldsIndexReader = compressingStoredFieldsReader.getIndexReader();
                indexInput.seek(compressingStoredFieldsIndexReader.getStartPointer(0));
                int n7 = 0;
                while (n7 < n5) {
                    int n8 = indexInput.readVInt();
                    if (n8 != n7) {
                        throw new CorruptIndexException("invalid state: base=" + n8 + ", docID=" + n7, indexInput);
                    }
                    int n9 = indexInput.readVInt();
                    int n10 = n9 >>> 1;
                    this.indexWriter.writeIndex(n10, this.fieldsStream.getFilePointer());
                    this.fieldsStream.writeVInt(this.docBase);
                    this.fieldsStream.writeVInt(n9);
                    this.docBase += n10;
                    n2 += n10;
                    if ((n7 += n10) > n5) {
                        throw new CorruptIndexException("invalid state: base=" + n8 + ", count=" + n10 + ", maxDoc=" + n5, indexInput);
                    }
                    long l2 = n7 == n5 ? compressingStoredFieldsReader.getMaxPointer() : compressingStoredFieldsIndexReader.getStartPointer(n7);
                    this.fieldsStream.copyBytes(indexInput, l2 - indexInput.getFilePointer());
                }
                if (indexInput.getFilePointer() != compressingStoredFieldsReader.getMaxPointer()) {
                    throw new CorruptIndexException("invalid state: pos=" + indexInput.getFilePointer() + ", max=" + compressingStoredFieldsReader.getMaxPointer(), indexInput);
                }
                this.numChunks += compressingStoredFieldsReader.getNumChunks();
                this.numDirtyChunks += compressingStoredFieldsReader.getNumDirtyChunks();
                continue;
            }
            assert (compressingStoredFieldsReader.getVersion() == 1);
            compressingStoredFieldsReader.checkIntegrity();
            for (int i4 = 0; i4 < n5; ++i4) {
                if (bits != null && !bits.get(i4)) continue;
                CompressingStoredFieldsReader.SerializedDocument serializedDocument = compressingStoredFieldsReader.document(i4);
                this.startDocument();
                this.bufferedDocs.copyBytes(serializedDocument.in, serializedDocument.length);
                this.numStoredFieldsInDoc = serializedDocument.numStoredFields;
                this.finishDocument();
                ++n2;
            }
        }
        this.finish(mergeState.mergeFieldInfos, n2);
        return n2;
    }

    boolean tooDirty(CompressingStoredFieldsReader compressingStoredFieldsReader) {
        return compressingStoredFieldsReader.getNumDirtyChunks() > 1024L || compressingStoredFieldsReader.getNumDirtyChunks() * 100L > compressingStoredFieldsReader.getNumChunks();
    }

    static {
        boolean bl = true;
        try {
            bl = Boolean.parseBoolean(System.getProperty(BULK_MERGE_ENABLED_SYSPROP, "true"));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        BULK_MERGE_ENABLED = bl;
    }
}

