/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.b;
import org.apache.lucene.store.c;
import org.apache.lucene.store.e;
import org.apache.lucene.util.IOUtils;

final class Lucene50CompoundReader
extends c {
    private final c directory;
    private final String segmentName;
    private final Map<String, FileEntry> entries;
    private final IndexInput handle;
    private int version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene50CompoundReader(c c2, SegmentInfo segmentInfo, IOContext iOContext) throws IOException {
        this.directory = c2;
        this.segmentName = segmentInfo.name;
        String string = IndexFileNames.segmentFileName(this.segmentName, "", "cfs");
        String string2 = IndexFileNames.segmentFileName(this.segmentName, "", "cfe");
        this.entries = this.readEntries(segmentInfo.getId(), c2, string2);
        boolean bl = false;
        this.handle = c2.openInput(string, iOContext);
        try {
            CodecUtil.checkIndexHeader(this.handle, "Lucene50CompoundData", this.version, this.version, segmentInfo.getId(), "");
            CodecUtil.retrieveChecksum(this.handle);
            return;
        }
        catch (Throwable throwable) {
            if (bl) throw throwable;
            IOUtils.closeWhileHandlingException(this.handle);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, FileEntry> readEntries(byte[] byArray, c c2, String string) throws IOException {
        HashMap<String, FileEntry> hashMap;
        block19: {
            hashMap = null;
            try (b b2 = c2.openChecksumInput(string, IOContext.READONCE);){
                Throwable throwable = null;
                try {
                    this.version = CodecUtil.checkIndexHeader(b2, "Lucene50CompoundEntries", 0, 0, byArray, "");
                    int n2 = b2.readVInt();
                    hashMap = new HashMap<String, FileEntry>(n2);
                    for (int i2 = 0; i2 < n2; ++i2) {
                        FileEntry fileEntry = new FileEntry();
                        String string2 = b2.readString();
                        FileEntry fileEntry2 = hashMap.put(string2, fileEntry);
                        if (fileEntry2 != null) {
                            throw new CorruptIndexException("Duplicate cfs entry id=" + string2 + " in CFS ", b2);
                        }
                        fileEntry.offset = b2.readLong();
                        fileEntry.length = b2.readLong();
                    }
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        break block19;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                    finally {
                        CodecUtil.checkFooter(b2, throwable);
                    }
                }
                CodecUtil.checkFooter(b2, throwable);
            }
        }
        return Collections.unmodifiableMap(hashMap);
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.handle);
    }

    @Override
    public IndexInput openInput(String string, IOContext iOContext) throws IOException {
        this.ensureOpen();
        String string2 = IndexFileNames.stripSegmentName(string);
        FileEntry fileEntry = this.entries.get(string2);
        if (fileEntry == null) {
            throw new FileNotFoundException("No sub-file with id " + string2 + " found (fileName=" + string + " files: " + this.entries.keySet() + ")");
        }
        return this.handle.slice(string, fileEntry.offset, fileEntry.length);
    }

    @Override
    public String[] listAll() {
        this.ensureOpen();
        String[] stringArray = this.entries.keySet().toArray(new String[this.entries.size()]);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = this.segmentName + stringArray[i2];
        }
        return stringArray;
    }

    @Override
    public void deleteFile(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void renameFile(String string, String string2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long fileLength(String string) throws IOException {
        this.ensureOpen();
        FileEntry fileEntry = this.entries.get(IndexFileNames.stripSegmentName(string));
        if (fileEntry == null) {
            throw new FileNotFoundException(string);
        }
        return fileEntry.length;
    }

    @Override
    public IndexOutput createOutput(String string, IOContext iOContext) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sync(Collection<String> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public e obtainLock(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return "CompoundFileDirectory(segment=\"" + this.segmentName + "\" in dir=" + this.directory + ")";
    }

    public static final class FileEntry {
        long offset;
        long length;
    }
}

