/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LongsRef;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.g;
import org.apache.lucene.util.packed.DirectWriter;
import org.apache.lucene.util.packed.MonotonicBlockPackedWriter;

class Lucene50DocValuesConsumer
extends DocValuesConsumer
implements Closeable {
    IndexOutput data;
    IndexOutput meta;
    final int maxDoc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene50DocValuesConsumer(SegmentWriteState segmentWriteState, String string, String string2, String string3, String string4) throws IOException {
        boolean bl = false;
        try {
            String string5 = IndexFileNames.segmentFileName(segmentWriteState.segmentInfo.name, segmentWriteState.segmentSuffix, string2);
            this.data = segmentWriteState.directory.createOutput(string5, segmentWriteState.context);
            CodecUtil.writeIndexHeader(this.data, string, 1, segmentWriteState.segmentInfo.getId(), segmentWriteState.segmentSuffix);
            String string6 = IndexFileNames.segmentFileName(segmentWriteState.segmentInfo.name, segmentWriteState.segmentSuffix, string4);
            this.meta = segmentWriteState.directory.createOutput(string6, segmentWriteState.context);
            CodecUtil.writeIndexHeader(this.meta, string3, 1, segmentWriteState.segmentInfo.getId(), segmentWriteState.segmentSuffix);
            this.maxDoc = segmentWriteState.segmentInfo.maxDoc();
            return;
        }
        catch (Throwable throwable) {
            if (bl) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    @Override
    public void addNumericField(FieldInfo fieldInfo, Iterable<Number> iterable) throws IOException {
        this.addNumericField(fieldInfo, iterable, true);
    }

    void addNumericField(FieldInfo fieldInfo, Iterable<Number> iterable, boolean bl) throws IOException {
        long l2;
        long l3;
        int n2;
        long l4;
        long l5 = 0L;
        long l6 = Long.MAX_VALUE;
        long l7 = Long.MIN_VALUE;
        long l8 = 0L;
        long l9 = 0L;
        long l10 = 0L;
        HashSet<Long> hashSet = null;
        if (bl) {
            hashSet = new HashSet<Long>();
            for (Number number : iterable) {
                if (number == null) {
                    l4 = 0L;
                    ++l9;
                    ++l10;
                } else {
                    l4 = number.longValue();
                    if (l4 == 0L) {
                        ++l10;
                    }
                }
                if (l8 != 1L) {
                    if (l4 < -4611686018427387904L || l4 > 0x3FFFFFFFFFFFFFFFL) {
                        l8 = 1L;
                    } else if (l5 != 0L) {
                        l8 = g.a(l8, l4 - l6);
                    }
                }
                l6 = Math.min(l6, l4);
                l7 = Math.max(l7, l4);
                if (hashSet != null && hashSet.add(l4) && hashSet.size() > 256) {
                    hashSet = null;
                }
                ++l5;
            }
        } else {
            for (Number number : iterable) {
                l4 = number.longValue();
                l6 = Math.min(l6, l4);
                l7 = Math.max(l7, l4);
                ++l5;
            }
        }
        long l11 = l7 - l6;
        int n3 = DirectWriter.unsignedBitsRequired(l11);
        int n4 = n2 = hashSet == null ? Integer.MAX_VALUE : DirectWriter.bitsRequired(hashSet.size() - 1);
        int n5 = hashSet != null && l5 <= Integer.MAX_VALUE && (hashSet.size() == 1 || hashSet.size() == 2 && l9 > 0L && l10 == l9) ? 4 : (hashSet != null && n2 < n3 ? 2 : (l8 != 0L && l8 != 1L ? ((l3 = (long)DirectWriter.unsignedBitsRequired(l2 = (l7 - l6) / l8)) < (long)n3 ? 1 : 0) : 0));
        this.meta.writeVInt(fieldInfo.number);
        this.meta.writeByte((byte)0);
        this.meta.writeVInt(n5);
        if (l9 == 0L) {
            this.meta.writeLong(-1L);
        } else if (l9 == l5) {
            this.meta.writeLong(-2L);
        } else {
            this.meta.writeLong(this.data.getFilePointer());
            this.writeMissingBitset(iterable);
        }
        this.meta.writeLong(this.data.getFilePointer());
        this.meta.writeVLong(l5);
        switch (n5) {
            case 4: {
                this.meta.writeLong(l6 < 0L ? ((Long)Collections.min(hashSet)).longValue() : ((Long)Collections.max(hashSet)).longValue());
                break;
            }
            case 1: {
                this.meta.writeLong(l6);
                this.meta.writeLong(l8);
                l2 = (l7 - l6) / l8;
                int n6 = DirectWriter.unsignedBitsRequired(l2);
                this.meta.writeVInt(n6);
                DirectWriter directWriter = DirectWriter.getInstance(this.data, l5, n6);
                for (Number number : iterable) {
                    long l12 = number == null ? 0L : number.longValue();
                    directWriter.add((l12 - l6) / l8);
                }
                directWriter.finish();
                break;
            }
            case 0: {
                long l13 = l11 < 0L ? 0L : l6;
                this.meta.writeLong(l13);
                this.meta.writeVInt(n3);
                DirectWriter directWriter = DirectWriter.getInstance(this.data, l5, n3);
                for (Number number : iterable) {
                    long l14 = number == null ? 0L : number.longValue();
                    directWriter.add(l14 - l13);
                }
                directWriter.finish();
                break;
            }
            case 2: {
                Object[] objectArray = hashSet.toArray(new Long[hashSet.size()]);
                Arrays.sort(objectArray);
                HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
                this.meta.writeVInt(objectArray.length);
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    this.meta.writeLong((Long)objectArray[i2]);
                    hashMap.put(objectArray[i2], i2);
                }
                this.meta.writeVInt(n2);
                DirectWriter directWriter = DirectWriter.getInstance(this.data, l5, n2);
                for (Number number : iterable) {
                    directWriter.add(((Integer)hashMap.get(number == null ? 0L : number.longValue())).intValue());
                }
                directWriter.finish();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.meta.writeLong(this.data.getFilePointer());
    }

    void writeMissingBitset(Iterable<?> iterable) throws IOException {
        byte by = 0;
        int n2 = 0;
        for (Object obj : iterable) {
            if (n2 == 8) {
                this.data.writeByte(by);
                n2 = 0;
                by = 0;
            }
            if (obj != null) {
                by = (byte)(by | 1 << (n2 & 7));
            }
            ++n2;
        }
        if (n2 > 0) {
            this.data.writeByte(by);
        }
    }

    @Override
    public void addBinaryField(FieldInfo fieldInfo, Iterable<BytesRef> iterable) throws IOException {
        this.meta.writeVInt(fieldInfo.number);
        this.meta.writeByte((byte)1);
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        long l2 = this.data.getFilePointer();
        long l3 = 0L;
        long l4 = 0L;
        for (BytesRef bytesRef : iterable) {
            int n4;
            if (bytesRef == null) {
                n4 = 0;
                ++l4;
            } else {
                n4 = bytesRef.length;
            }
            n2 = Math.min(n2, n4);
            n3 = Math.max(n3, n4);
            if (bytesRef != null) {
                this.data.writeBytes(bytesRef.bytes, bytesRef.offset, bytesRef.length);
            }
            ++l3;
        }
        this.meta.writeVInt(n2 == n3 ? 0 : 1);
        if (l4 == 0L) {
            this.meta.writeLong(-1L);
        } else if (l4 == l3) {
            this.meta.writeLong(-2L);
        } else {
            this.meta.writeLong(this.data.getFilePointer());
            this.writeMissingBitset(iterable);
        }
        this.meta.writeVInt(n2);
        this.meta.writeVInt(n3);
        this.meta.writeVLong(l3);
        this.meta.writeLong(l2);
        if (n2 != n3) {
            this.meta.writeLong(this.data.getFilePointer());
            this.meta.writeVInt(2);
            this.meta.writeVInt(16384);
            MonotonicBlockPackedWriter monotonicBlockPackedWriter = new MonotonicBlockPackedWriter(this.data, 16384);
            long l5 = 0L;
            monotonicBlockPackedWriter.add(l5);
            for (BytesRef bytesRef : iterable) {
                if (bytesRef != null) {
                    l5 += (long)bytesRef.length;
                }
                monotonicBlockPackedWriter.add(l5);
            }
            monotonicBlockPackedWriter.finish();
        }
    }

    private void addTermsDict(FieldInfo fieldInfo, Iterable<BytesRef> iterable) throws IOException {
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        long l2 = 0L;
        for (BytesRef bytesRef : iterable) {
            n2 = Math.min(n2, bytesRef.length);
            n3 = Math.max(n3, bytesRef.length);
            ++l2;
        }
        if (n2 == n3) {
            this.addBinaryField(fieldInfo, iterable);
        } else if (l2 < 1024L) {
            this.addBinaryField(fieldInfo, iterable);
        } else {
            assert (l2 > 0L);
            this.meta.writeVInt(fieldInfo.number);
            this.meta.writeByte((byte)1);
            this.meta.writeVInt(2);
            this.meta.writeLong(-1L);
            long l3 = this.data.getFilePointer();
            RAMOutputStream rAMOutputStream = new RAMOutputStream();
            MonotonicBlockPackedWriter monotonicBlockPackedWriter = new MonotonicBlockPackedWriter(rAMOutputStream, 16384);
            RAMOutputStream rAMOutputStream2 = new RAMOutputStream();
            RAMOutputStream rAMOutputStream3 = new RAMOutputStream();
            BytesRefBuilder bytesRefBuilder = new BytesRefBuilder();
            bytesRefBuilder.grow(n3);
            long l4 = 0L;
            int[] nArray = new int[16];
            for (BytesRef bytesRef : iterable) {
                int n4 = (int)(l4 & 0xFL);
                if (n4 == 0) {
                    monotonicBlockPackedWriter.add(this.data.getFilePointer() - l3);
                    rAMOutputStream3.writeVInt(bytesRef.length);
                    rAMOutputStream3.writeBytes(bytesRef.bytes, bytesRef.offset, bytesRef.length);
                    bytesRefBuilder.copyBytes(bytesRef);
                } else {
                    int n5 = Math.min(255, StringHelper.bytesDifference(bytesRefBuilder.get(), bytesRef));
                    rAMOutputStream2.writeByte((byte)n5);
                    rAMOutputStream2.writeBytes(bytesRef.bytes, bytesRef.offset + n5, bytesRef.length - n5);
                    nArray[n4] = bytesRef.length - n5 - 1;
                }
                if ((++l4 & 0xFL) != 0L) continue;
                this.flushTermsDictBlock(rAMOutputStream3, rAMOutputStream2, nArray);
            }
            int n6 = (int)(l4 & 0xFL);
            if (n6 > 0) {
                Arrays.fill(nArray, n6, nArray.length, 0);
                this.flushTermsDictBlock(rAMOutputStream3, rAMOutputStream2, nArray);
            }
            long l5 = this.data.getFilePointer();
            monotonicBlockPackedWriter.finish();
            rAMOutputStream.writeTo(this.data);
            rAMOutputStream = null;
            monotonicBlockPackedWriter = null;
            this.meta.writeVInt(n2);
            this.meta.writeVInt(n3);
            this.meta.writeVLong(l4);
            this.meta.writeLong(l3);
            this.meta.writeLong(l5);
            this.meta.writeVInt(2);
            this.meta.writeVInt(16384);
            this.addReverseTermIndex(fieldInfo, iterable, n3);
        }
    }

    private void flushTermsDictBlock(RAMOutputStream rAMOutputStream, RAMOutputStream rAMOutputStream2, int[] nArray) throws IOException {
        int n2;
        boolean bl = false;
        for (n2 = 1; n2 < nArray.length; ++n2) {
            if (nArray[n2] <= 254) continue;
            bl = true;
        }
        if (bl) {
            rAMOutputStream.writeByte((byte)-1);
            for (n2 = 1; n2 < nArray.length; ++n2) {
                rAMOutputStream.writeShort((short)nArray[n2]);
            }
        } else {
            for (n2 = 1; n2 < nArray.length; ++n2) {
                rAMOutputStream.writeByte((byte)nArray[n2]);
            }
        }
        rAMOutputStream.writeTo(this.data);
        rAMOutputStream.reset();
        rAMOutputStream2.writeTo(this.data);
        rAMOutputStream2.reset();
    }

    private void addReverseTermIndex(FieldInfo fieldInfo, Iterable<BytesRef> iterable, int n2) throws IOException {
        long l2 = 0L;
        BytesRefBuilder bytesRefBuilder = new BytesRefBuilder();
        bytesRefBuilder.grow(n2);
        BytesRef bytesRef = new BytesRef();
        long l3 = this.data.getFilePointer();
        PagedBytes pagedBytes = new PagedBytes(15);
        MonotonicBlockPackedWriter monotonicBlockPackedWriter = new MonotonicBlockPackedWriter(this.data, 16384);
        for (BytesRef bytesRef2 : iterable) {
            int n3 = (int)(l2 & 0x3FFL);
            if (n3 == 0) {
                int n4 = StringHelper.sortKeyLength(bytesRefBuilder.get(), bytesRef2);
                bytesRef.bytes = bytesRef2.bytes;
                bytesRef.offset = bytesRef2.offset;
                bytesRef.length = n4;
                monotonicBlockPackedWriter.add(pagedBytes.copyUsingLengthPrefix(bytesRef));
            } else if (n3 == 1023) {
                bytesRefBuilder.copyBytes(bytesRef2);
            }
            ++l2;
        }
        monotonicBlockPackedWriter.finish();
        long l4 = pagedBytes.getPointer();
        pagedBytes.freeze(true);
        PagedBytes.PagedBytesDataInput pagedBytesDataInput = pagedBytes.getDataInput();
        this.meta.writeLong(l3);
        this.data.writeVLong(l4);
        this.data.copyBytes(pagedBytesDataInput, l4);
    }

    @Override
    public void addSortedField(FieldInfo fieldInfo, Iterable<BytesRef> iterable, Iterable<Number> iterable2) throws IOException {
        this.meta.writeVInt(fieldInfo.number);
        this.meta.writeByte((byte)2);
        this.addTermsDict(fieldInfo, iterable);
        this.addNumericField(fieldInfo, iterable2, false);
    }

    @Override
    public void addSortedNumericField(FieldInfo fieldInfo, Iterable<Number> iterable, Iterable<Number> iterable2) throws IOException {
        this.meta.writeVInt(fieldInfo.number);
        this.meta.writeByte((byte)4);
        if (Lucene50DocValuesConsumer.isSingleValued(iterable)) {
            this.meta.writeVInt(1);
            this.addNumericField(fieldInfo, Lucene50DocValuesConsumer.singletonView(iterable, iterable2, null));
        } else {
            SortedSet<LongsRef> sortedSet = this.uniqueValueSets(iterable, iterable2);
            if (sortedSet != null) {
                this.meta.writeVInt(2);
                this.writeDictionary(sortedSet);
                this.addNumericField(fieldInfo, this.docToSetId(sortedSet, iterable, iterable2), false);
            } else {
                this.meta.writeVInt(0);
                this.addNumericField(fieldInfo, iterable2, true);
                this.addAddresses(fieldInfo, iterable);
            }
        }
    }

    @Override
    public void addSortedSetField(FieldInfo fieldInfo, Iterable<BytesRef> iterable, Iterable<Number> iterable2, Iterable<Number> iterable3) throws IOException {
        this.meta.writeVInt(fieldInfo.number);
        this.meta.writeByte((byte)3);
        if (Lucene50DocValuesConsumer.isSingleValued(iterable2)) {
            this.meta.writeVInt(1);
            this.addSortedField(fieldInfo, iterable, Lucene50DocValuesConsumer.singletonView(iterable2, iterable3, -1L));
        } else {
            SortedSet<LongsRef> sortedSet = this.uniqueValueSets(iterable2, iterable3);
            if (sortedSet != null) {
                this.meta.writeVInt(2);
                this.writeDictionary(sortedSet);
                this.addTermsDict(fieldInfo, iterable);
                this.addNumericField(fieldInfo, this.docToSetId(sortedSet, iterable2, iterable3), false);
            } else {
                this.meta.writeVInt(0);
                this.addTermsDict(fieldInfo, iterable);
                this.addNumericField(fieldInfo, iterable3, false);
                this.addAddresses(fieldInfo, iterable2);
            }
        }
    }

    private SortedSet<LongsRef> uniqueValueSets(Iterable<Number> iterable, Iterable<Number> iterable2) {
        HashSet<LongsRef> hashSet = new HashSet<LongsRef>();
        LongsRef longsRef = new LongsRef(256);
        Iterator<Number> iterator = iterable.iterator();
        Iterator<Number> iterator2 = iterable2.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            longsRef.length = iterator.next().intValue();
            if (longsRef.length > 256) {
                return null;
            }
            for (int i2 = 0; i2 < longsRef.length; ++i2) {
                longsRef.longs[i2] = iterator2.next().longValue();
            }
            if (hashSet.contains(longsRef)) continue;
            if ((n2 += longsRef.length) > 256) {
                return null;
            }
            hashSet.add(new LongsRef(Arrays.copyOf(longsRef.longs, longsRef.length), 0, longsRef.length));
        }
        assert (!iterator2.hasNext());
        return new TreeSet<LongsRef>(hashSet);
    }

    private void writeDictionary(SortedSet<LongsRef> sortedSet) throws IOException {
        int n2 = 0;
        for (LongsRef longsRef : sortedSet) {
            n2 += longsRef.length;
        }
        this.meta.writeInt(n2);
        for (LongsRef longsRef : sortedSet) {
            for (int i2 = 0; i2 < longsRef.length; ++i2) {
                this.meta.writeLong(longsRef.longs[longsRef.offset + i2]);
            }
        }
        this.meta.writeInt(sortedSet.size());
        for (LongsRef longsRef : sortedSet) {
            this.meta.writeInt(longsRef.length);
        }
    }

    private Iterable<Number> docToSetId(SortedSet<LongsRef> sortedSet, final Iterable<Number> iterable, final Iterable<Number> iterable2) {
        final HashMap<LongsRef, Integer> hashMap = new HashMap<LongsRef, Integer>();
        int n2 = 0;
        for (LongsRef longsRef : sortedSet) {
            hashMap.put(longsRef, n2++);
        }
        assert (n2 == sortedSet.size());
        return new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                final Iterator iterator = iterable.iterator();
                final Iterator iterator2 = iterable2.iterator();
                final LongsRef longsRef = new LongsRef(256);
                return new Iterator<Number>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Number next() {
                        longsRef.length = ((Number)iterator.next()).intValue();
                        for (int i2 = 0; i2 < longsRef.length; ++i2) {
                            longsRef.longs[i2] = ((Number)iterator2.next()).longValue();
                        }
                        Integer n2 = (Integer)hashMap.get(longsRef);
                        assert (n2 != null);
                        return n2;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private void addAddresses(FieldInfo fieldInfo, Iterable<Number> iterable) throws IOException {
        this.meta.writeVInt(fieldInfo.number);
        this.meta.writeByte((byte)0);
        this.meta.writeVInt(3);
        this.meta.writeLong(-1L);
        this.meta.writeLong(this.data.getFilePointer());
        this.meta.writeVLong(this.maxDoc);
        this.meta.writeVInt(2);
        this.meta.writeVInt(16384);
        MonotonicBlockPackedWriter monotonicBlockPackedWriter = new MonotonicBlockPackedWriter(this.data, 16384);
        long l2 = 0L;
        monotonicBlockPackedWriter.add(l2);
        for (Number number : iterable) {
            monotonicBlockPackedWriter.add(l2 += number.longValue());
        }
        monotonicBlockPackedWriter.finish();
        this.meta.writeLong(this.data.getFilePointer());
    }

    @Override
    public void close() throws IOException {
        block7: {
            block6: {
                boolean bl = false;
                try {
                    if (this.meta != null) {
                        this.meta.writeVInt(-1);
                        CodecUtil.writeFooter(this.meta);
                    }
                    if (this.data != null) {
                        CodecUtil.writeFooter(this.data);
                    }
                    if (!(bl = true)) break block6;
                }
                catch (Throwable throwable) {
                    if (bl) {
                        IOUtils.close(this.data, this.meta);
                    } else {
                        IOUtils.closeWhileHandlingException(this.data, this.meta);
                    }
                    this.data = null;
                    this.meta = null;
                    throw throwable;
                }
                IOUtils.close(this.data, this.meta);
                break block7;
            }
            IOUtils.closeWhileHandlingException(this.data, this.meta);
        }
        this.data = null;
        this.meta = null;
    }
}

