/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.b;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.a;
import org.apache.lucene.index.m;
import org.apache.lucene.index.n;
import org.apache.lucene.index.p;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.h;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.DirectReader;
import org.apache.lucene.util.packed.MonotonicBlockPackedReader;

class Lucene50DocValuesProducer
extends b
implements Closeable {
    private final Map<String, NumericEntry> numerics;
    private final Map<String, BinaryEntry> binaries;
    private final Map<String, SortedSetEntry> sortedSets;
    private final Map<String, SortedSetEntry> sortedNumerics;
    private final Map<String, NumericEntry> ords;
    private final Map<String, NumericEntry> ordIndexes;
    private final int numFields;
    private final AtomicLong ramBytesUsed;
    private final IndexInput data;
    private final int maxDoc;
    private final Map<String, MonotonicBlockPackedReader> addressInstances;
    private final Map<String, MonotonicBlockPackedReader> ordIndexInstances;
    private final Map<String, ReverseTermsIndex> reverseIndexInstances;
    private final boolean merging;

    Lucene50DocValuesProducer(Lucene50DocValuesProducer lucene50DocValuesProducer) throws IOException {
        this.numerics = new HashMap<String, NumericEntry>();
        this.binaries = new HashMap<String, BinaryEntry>();
        this.sortedSets = new HashMap<String, SortedSetEntry>();
        this.sortedNumerics = new HashMap<String, SortedSetEntry>();
        this.ords = new HashMap<String, NumericEntry>();
        this.ordIndexes = new HashMap<String, NumericEntry>();
        this.addressInstances = new HashMap<String, MonotonicBlockPackedReader>();
        this.ordIndexInstances = new HashMap<String, MonotonicBlockPackedReader>();
        this.reverseIndexInstances = new HashMap<String, ReverseTermsIndex>();
        assert (Thread.holdsLock(lucene50DocValuesProducer));
        this.numerics.putAll(lucene50DocValuesProducer.numerics);
        this.binaries.putAll(lucene50DocValuesProducer.binaries);
        this.sortedSets.putAll(lucene50DocValuesProducer.sortedSets);
        this.sortedNumerics.putAll(lucene50DocValuesProducer.sortedNumerics);
        this.ords.putAll(lucene50DocValuesProducer.ords);
        this.ordIndexes.putAll(lucene50DocValuesProducer.ordIndexes);
        this.numFields = lucene50DocValuesProducer.numFields;
        this.ramBytesUsed = new AtomicLong(lucene50DocValuesProducer.ramBytesUsed.get());
        this.data = lucene50DocValuesProducer.data.clone();
        this.maxDoc = lucene50DocValuesProducer.maxDoc;
        this.addressInstances.putAll(lucene50DocValuesProducer.addressInstances);
        this.ordIndexInstances.putAll(lucene50DocValuesProducer.ordIndexInstances);
        this.reverseIndexInstances.putAll(lucene50DocValuesProducer.reverseIndexInstances);
        this.merging = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene50DocValuesProducer(SegmentReadState segmentReadState, String string, String string2, String string3, String string4) throws IOException {
        Object object;
        int n2;
        int n3;
        block20: {
            this.numerics = new HashMap<String, NumericEntry>();
            this.binaries = new HashMap<String, BinaryEntry>();
            this.sortedSets = new HashMap<String, SortedSetEntry>();
            this.sortedNumerics = new HashMap<String, SortedSetEntry>();
            this.ords = new HashMap<String, NumericEntry>();
            this.ordIndexes = new HashMap<String, NumericEntry>();
            this.addressInstances = new HashMap<String, MonotonicBlockPackedReader>();
            this.ordIndexInstances = new HashMap<String, MonotonicBlockPackedReader>();
            this.reverseIndexInstances = new HashMap<String, ReverseTermsIndex>();
            String string5 = IndexFileNames.segmentFileName(segmentReadState.segmentInfo.name, segmentReadState.segmentSuffix, string4);
            this.maxDoc = segmentReadState.segmentInfo.maxDoc();
            this.merging = false;
            this.ramBytesUsed = new AtomicLong(RamUsageEstimator.shallowSizeOfInstance(this.getClass()));
            n3 = -1;
            n2 = -1;
            object = segmentReadState.directory.openChecksumInput(string5, segmentReadState.context);
            Throwable throwable = null;
            try {
                Throwable throwable2 = null;
                try {
                    n3 = CodecUtil.checkIndexHeader((DataInput)object, string3, 0, 1, segmentReadState.segmentInfo.getId(), segmentReadState.segmentSuffix);
                    n2 = this.readFields((IndexInput)object, segmentReadState.fieldInfos);
                }
                catch (Throwable throwable3) {
                    try {
                        throwable2 = throwable3;
                        break block20;
                    }
                    catch (Throwable throwable4) {
                        throw throwable4;
                    }
                    finally {
                        CodecUtil.checkFooter((org.apache.lucene.store.b)object, throwable2);
                    }
                }
                CodecUtil.checkFooter((org.apache.lucene.store.b)object, throwable2);
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((IndexInput)object).close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                    } else {
                        ((IndexInput)object).close();
                    }
                }
            }
        }
        this.numFields = n2;
        object = IndexFileNames.segmentFileName(segmentReadState.segmentInfo.name, segmentReadState.segmentSuffix, string2);
        this.data = segmentReadState.directory.openInput((String)object, segmentReadState.context);
        boolean bl = false;
        try {
            int n4 = CodecUtil.checkIndexHeader(this.data, string, 0, 1, segmentReadState.segmentInfo.getId(), segmentReadState.segmentSuffix);
            if (n3 != n4) {
                throw new CorruptIndexException("Format versions mismatch: meta=" + n3 + ", data=" + n4, this.data);
            }
            CodecUtil.retrieveChecksum(this.data);
            return;
        }
        catch (Throwable throwable) {
            if (bl) throw throwable;
            IOUtils.closeWhileHandlingException(this.data);
            throw throwable;
        }
    }

    private void readSortedField(FieldInfo fieldInfo, IndexInput indexInput) throws IOException {
        if (indexInput.readVInt() != fieldInfo.number) {
            throw new CorruptIndexException("sorted entry for field: " + fieldInfo.name + " is corrupt", indexInput);
        }
        if (indexInput.readByte() != 1) {
            throw new CorruptIndexException("sorted entry for field: " + fieldInfo.name + " is corrupt", indexInput);
        }
        BinaryEntry binaryEntry = Lucene50DocValuesProducer.readBinaryEntry(indexInput);
        this.binaries.put(fieldInfo.name, binaryEntry);
        if (indexInput.readVInt() != fieldInfo.number) {
            throw new CorruptIndexException("sorted entry for field: " + fieldInfo.name + " is corrupt", indexInput);
        }
        if (indexInput.readByte() != 0) {
            throw new CorruptIndexException("sorted entry for field: " + fieldInfo.name + " is corrupt", indexInput);
        }
        NumericEntry numericEntry = this.readNumericEntry(indexInput);
        this.ords.put(fieldInfo.name, numericEntry);
    }

    private void readSortedSetFieldWithAddresses(FieldInfo fieldInfo, IndexInput indexInput) throws IOException {
        if (indexInput.readVInt() != fieldInfo.number) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldInfo.name + " is corrupt", indexInput);
        }
        if (indexInput.readByte() != 1) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldInfo.name + " is corrupt", indexInput);
        }
        BinaryEntry binaryEntry = Lucene50DocValuesProducer.readBinaryEntry(indexInput);
        this.binaries.put(fieldInfo.name, binaryEntry);
        if (indexInput.readVInt() != fieldInfo.number) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldInfo.name + " is corrupt", indexInput);
        }
        if (indexInput.readByte() != 0) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldInfo.name + " is corrupt", indexInput);
        }
        NumericEntry numericEntry = this.readNumericEntry(indexInput);
        this.ords.put(fieldInfo.name, numericEntry);
        if (indexInput.readVInt() != fieldInfo.number) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldInfo.name + " is corrupt", indexInput);
        }
        if (indexInput.readByte() != 0) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldInfo.name + " is corrupt", indexInput);
        }
        NumericEntry numericEntry2 = this.readNumericEntry(indexInput);
        this.ordIndexes.put(fieldInfo.name, numericEntry2);
    }

    private void readSortedSetFieldWithTable(FieldInfo fieldInfo, IndexInput indexInput) throws IOException {
        if (indexInput.readVInt() != fieldInfo.number) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldInfo.name + " is corrupt", indexInput);
        }
        if (indexInput.readByte() != 1) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldInfo.name + " is corrupt", indexInput);
        }
        BinaryEntry binaryEntry = Lucene50DocValuesProducer.readBinaryEntry(indexInput);
        this.binaries.put(fieldInfo.name, binaryEntry);
        if (indexInput.readVInt() != fieldInfo.number) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldInfo.name + " is corrupt", indexInput);
        }
        if (indexInput.readByte() != 0) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldInfo.name + " is corrupt", indexInput);
        }
        NumericEntry numericEntry = this.readNumericEntry(indexInput);
        this.ords.put(fieldInfo.name, numericEntry);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int readFields(IndexInput indexInput, FieldInfos fieldInfos) throws IOException {
        int n2 = 0;
        int n3 = indexInput.readVInt();
        while (n3 != -1) {
            Object object;
            ++n2;
            FieldInfo fieldInfo = fieldInfos.fieldInfo(n3);
            if (fieldInfo == null) {
                throw new CorruptIndexException("Invalid field number: " + n3, indexInput);
            }
            byte by = indexInput.readByte();
            if (by == 0) {
                this.numerics.put(fieldInfo.name, this.readNumericEntry(indexInput));
            } else if (by == 1) {
                object = Lucene50DocValuesProducer.readBinaryEntry(indexInput);
                this.binaries.put(fieldInfo.name, (BinaryEntry)object);
            } else if (by == 2) {
                this.readSortedField(fieldInfo, indexInput);
            } else if (by == 3) {
                object = this.readSortedSetEntry(indexInput);
                this.sortedSets.put(fieldInfo.name, (SortedSetEntry)object);
                if (((SortedSetEntry)object).format == 0) {
                    this.readSortedSetFieldWithAddresses(fieldInfo, indexInput);
                } else if (((SortedSetEntry)object).format == 2) {
                    this.readSortedSetFieldWithTable(fieldInfo, indexInput);
                } else {
                    if (((SortedSetEntry)object).format != 1) throw new AssertionError();
                    if (indexInput.readVInt() != n3) {
                        throw new CorruptIndexException("sortedset entry for field: " + fieldInfo.name + " is corrupt", indexInput);
                    }
                    if (indexInput.readByte() != 2) {
                        throw new CorruptIndexException("sortedset entry for field: " + fieldInfo.name + " is corrupt", indexInput);
                    }
                    this.readSortedField(fieldInfo, indexInput);
                }
            } else {
                NumericEntry numericEntry;
                if (by != 4) throw new CorruptIndexException("invalid type: " + by, indexInput);
                object = this.readSortedSetEntry(indexInput);
                this.sortedNumerics.put(fieldInfo.name, (SortedSetEntry)object);
                if (((SortedSetEntry)object).format == 0) {
                    if (indexInput.readVInt() != n3) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + fieldInfo.name + " is corrupt", indexInput);
                    }
                    if (indexInput.readByte() != 0) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + fieldInfo.name + " is corrupt", indexInput);
                    }
                    this.numerics.put(fieldInfo.name, this.readNumericEntry(indexInput));
                    if (indexInput.readVInt() != n3) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + fieldInfo.name + " is corrupt", indexInput);
                    }
                    if (indexInput.readByte() != 0) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + fieldInfo.name + " is corrupt", indexInput);
                    }
                    numericEntry = this.readNumericEntry(indexInput);
                    this.ordIndexes.put(fieldInfo.name, numericEntry);
                } else if (((SortedSetEntry)object).format == 2) {
                    if (indexInput.readVInt() != fieldInfo.number) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + fieldInfo.name + " is corrupt", indexInput);
                    }
                    if (indexInput.readByte() != 0) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + fieldInfo.name + " is corrupt", indexInput);
                    }
                    numericEntry = this.readNumericEntry(indexInput);
                    this.ords.put(fieldInfo.name, numericEntry);
                } else {
                    if (((SortedSetEntry)object).format != 1) throw new AssertionError();
                    if (indexInput.readVInt() != n3) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + fieldInfo.name + " is corrupt", indexInput);
                    }
                    if (indexInput.readByte() != 0) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + fieldInfo.name + " is corrupt", indexInput);
                    }
                    this.numerics.put(fieldInfo.name, this.readNumericEntry(indexInput));
                }
            }
            n3 = indexInput.readVInt();
        }
        return n2;
    }

    private NumericEntry readNumericEntry(IndexInput indexInput) throws IOException {
        NumericEntry numericEntry = new NumericEntry();
        numericEntry.format = indexInput.readVInt();
        numericEntry.missingOffset = indexInput.readLong();
        numericEntry.offset = indexInput.readLong();
        numericEntry.count = indexInput.readVLong();
        switch (numericEntry.format) {
            case 4: {
                numericEntry.minValue = indexInput.readLong();
                if (numericEntry.count <= Integer.MAX_VALUE) break;
                throw new CorruptIndexException("illegal CONST_COMPRESSED count: " + numericEntry.count, indexInput);
            }
            case 1: {
                numericEntry.minValue = indexInput.readLong();
                numericEntry.gcd = indexInput.readLong();
                numericEntry.bitsPerValue = indexInput.readVInt();
                break;
            }
            case 2: {
                int n2 = indexInput.readVInt();
                if (n2 > 256) {
                    throw new CorruptIndexException("TABLE_COMPRESSED cannot have more than 256 distinct values, got=" + n2, indexInput);
                }
                numericEntry.table = new long[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    numericEntry.table[i2] = indexInput.readLong();
                }
                this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf(numericEntry.table));
                numericEntry.bitsPerValue = indexInput.readVInt();
                break;
            }
            case 0: {
                numericEntry.minValue = indexInput.readLong();
                numericEntry.bitsPerValue = indexInput.readVInt();
                break;
            }
            case 3: {
                numericEntry.packedIntsVersion = indexInput.readVInt();
                numericEntry.blockSize = indexInput.readVInt();
                break;
            }
            default: {
                throw new CorruptIndexException("Unknown format: " + numericEntry.format + ", input=", indexInput);
            }
        }
        numericEntry.endOffset = indexInput.readLong();
        return numericEntry;
    }

    static BinaryEntry readBinaryEntry(IndexInput indexInput) throws IOException {
        BinaryEntry binaryEntry = new BinaryEntry();
        binaryEntry.format = indexInput.readVInt();
        binaryEntry.missingOffset = indexInput.readLong();
        binaryEntry.minLength = indexInput.readVInt();
        binaryEntry.maxLength = indexInput.readVInt();
        binaryEntry.count = indexInput.readVLong();
        binaryEntry.offset = indexInput.readLong();
        switch (binaryEntry.format) {
            case 0: {
                break;
            }
            case 2: {
                binaryEntry.addressesOffset = indexInput.readLong();
                binaryEntry.packedIntsVersion = indexInput.readVInt();
                binaryEntry.blockSize = indexInput.readVInt();
                binaryEntry.reverseIndexOffset = indexInput.readLong();
                break;
            }
            case 1: {
                binaryEntry.addressesOffset = indexInput.readLong();
                binaryEntry.packedIntsVersion = indexInput.readVInt();
                binaryEntry.blockSize = indexInput.readVInt();
                break;
            }
            default: {
                throw new CorruptIndexException("Unknown format: " + binaryEntry.format, indexInput);
            }
        }
        return binaryEntry;
    }

    SortedSetEntry readSortedSetEntry(IndexInput indexInput) throws IOException {
        SortedSetEntry sortedSetEntry = new SortedSetEntry();
        sortedSetEntry.format = indexInput.readVInt();
        if (sortedSetEntry.format == 2) {
            int n2;
            int n3 = indexInput.readInt();
            if (n3 > 256) {
                throw new CorruptIndexException("SORTED_SET_TABLE cannot have more than 256 values in its dictionary, got=" + n3, indexInput);
            }
            sortedSetEntry.table = new long[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                sortedSetEntry.table[n2] = indexInput.readLong();
            }
            this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf(sortedSetEntry.table));
            n2 = indexInput.readInt();
            if (n2 > n3 + 1) {
                throw new CorruptIndexException("SORTED_SET_TABLE cannot have more set ids than ords in its dictionary, got " + n3 + " ords and " + n2 + " sets", indexInput);
            }
            sortedSetEntry.tableOffsets = new int[n2 + 1];
            for (int i2 = 1; i2 < sortedSetEntry.tableOffsets.length; ++i2) {
                sortedSetEntry.tableOffsets[i2] = sortedSetEntry.tableOffsets[i2 - 1] + indexInput.readInt();
            }
            this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf(sortedSetEntry.tableOffsets));
        } else if (sortedSetEntry.format != 1 && sortedSetEntry.format != 0) {
            throw new CorruptIndexException("Unknown format: " + sortedSetEntry.format, indexInput);
        }
        return sortedSetEntry;
    }

    @Override
    public m getNumeric(FieldInfo fieldInfo) throws IOException {
        NumericEntry numericEntry = this.numerics.get(fieldInfo.name);
        return this.getNumeric(numericEntry);
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed.get();
    }

    @Override
    public synchronized Collection<org.apache.lucene.util.a> getChildResources() {
        ArrayList<org.apache.lucene.util.a> arrayList = new ArrayList<org.apache.lucene.util.a>();
        arrayList.addAll(org.apache.lucene.util.b.a("addresses field", this.addressInstances));
        arrayList.addAll(org.apache.lucene.util.b.a("ord index field", this.ordIndexInstances));
        arrayList.addAll(org.apache.lucene.util.b.a("reverse index field", this.reverseIndexInstances));
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.data);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(fields=" + this.numFields + ")";
    }

    LongValues getNumeric(NumericEntry numericEntry) throws IOException {
        switch (numericEntry.format) {
            case 4: {
                final long l2 = numericEntry.minValue;
                final Bits bits = this.getLiveBits(numericEntry.missingOffset, (int)numericEntry.count);
                return new LongValues(){

                    @Override
                    public long get(long l22) {
                        return bits.get((int)l22) ? l2 : 0L;
                    }
                };
            }
            case 0: {
                h h2 = this.data.randomAccessSlice(numericEntry.offset, numericEntry.endOffset - numericEntry.offset);
                final long l3 = numericEntry.minValue;
                final LongValues longValues = DirectReader.a(h2, numericEntry.bitsPerValue);
                return new LongValues(){

                    @Override
                    public long get(long l2) {
                        return l3 + longValues.get(l2);
                    }
                };
            }
            case 1: {
                h h3 = this.data.randomAccessSlice(numericEntry.offset, numericEntry.endOffset - numericEntry.offset);
                final long l4 = numericEntry.minValue;
                final long l5 = numericEntry.gcd;
                final LongValues longValues = DirectReader.a(h3, numericEntry.bitsPerValue);
                return new LongValues(){

                    @Override
                    public long get(long l2) {
                        return l4 + l5 * longValues.get(l2);
                    }
                };
            }
            case 2: {
                h h4 = this.data.randomAccessSlice(numericEntry.offset, numericEntry.endOffset - numericEntry.offset);
                final long[] lArray = numericEntry.table;
                final LongValues longValues = DirectReader.a(h4, numericEntry.bitsPerValue);
                return new LongValues(){

                    @Override
                    public long get(long l2) {
                        return lArray[(int)longValues.get(l2)];
                    }
                };
            }
        }
        throw new AssertionError();
    }

    @Override
    public a getBinary(FieldInfo fieldInfo) throws IOException {
        BinaryEntry binaryEntry = this.binaries.get(fieldInfo.name);
        switch (binaryEntry.format) {
            case 0: {
                return this.getFixedBinary(fieldInfo, binaryEntry);
            }
            case 1: {
                return this.getVariableBinary(fieldInfo, binaryEntry);
            }
            case 2: {
                return this.getCompressedBinary(fieldInfo, binaryEntry);
            }
        }
        throw new AssertionError();
    }

    private a getFixedBinary(FieldInfo fieldInfo, BinaryEntry binaryEntry) throws IOException {
        final IndexInput indexInput = this.data.slice("fixed-binary", binaryEntry.offset, binaryEntry.count * (long)binaryEntry.maxLength);
        final BytesRef bytesRef = new BytesRef(binaryEntry.maxLength);
        final byte[] byArray = bytesRef.bytes;
        final int n2 = bytesRef.length = binaryEntry.maxLength;
        return new LongBinaryDocValues(){

            @Override
            public BytesRef get(long l2) {
                try {
                    indexInput.seek(l2 * (long)n2);
                    indexInput.readBytes(byArray, 0, byArray.length);
                    return bytesRef;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        };
    }

    private synchronized MonotonicBlockPackedReader getAddressInstance(FieldInfo fieldInfo, BinaryEntry binaryEntry) throws IOException {
        MonotonicBlockPackedReader monotonicBlockPackedReader = this.addressInstances.get(fieldInfo.name);
        if (monotonicBlockPackedReader == null) {
            this.data.seek(binaryEntry.addressesOffset);
            monotonicBlockPackedReader = MonotonicBlockPackedReader.of(this.data, binaryEntry.packedIntsVersion, binaryEntry.blockSize, binaryEntry.count + 1L, false);
            if (!this.merging) {
                this.addressInstances.put(fieldInfo.name, monotonicBlockPackedReader);
                this.ramBytesUsed.addAndGet(monotonicBlockPackedReader.ramBytesUsed() + 4L);
            }
        }
        return monotonicBlockPackedReader;
    }

    private a getVariableBinary(FieldInfo fieldInfo, BinaryEntry binaryEntry) throws IOException {
        final MonotonicBlockPackedReader monotonicBlockPackedReader = this.getAddressInstance(fieldInfo, binaryEntry);
        final IndexInput indexInput = this.data.slice("var-binary", binaryEntry.offset, binaryEntry.addressesOffset - binaryEntry.offset);
        final BytesRef bytesRef = new BytesRef(Math.max(0, binaryEntry.maxLength));
        final byte[] byArray = bytesRef.bytes;
        return new LongBinaryDocValues(){

            @Override
            public BytesRef get(long l2) {
                long l3 = monotonicBlockPackedReader.get(l2);
                long l4 = monotonicBlockPackedReader.get(l2 + 1L);
                int n2 = (int)(l4 - l3);
                try {
                    indexInput.seek(l3);
                    indexInput.readBytes(byArray, 0, n2);
                    bytesRef.length = n2;
                    return bytesRef;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        };
    }

    private synchronized MonotonicBlockPackedReader getIntervalInstance(FieldInfo fieldInfo, BinaryEntry binaryEntry) throws IOException {
        MonotonicBlockPackedReader monotonicBlockPackedReader = this.addressInstances.get(fieldInfo.name);
        if (monotonicBlockPackedReader == null) {
            this.data.seek(binaryEntry.addressesOffset);
            long l2 = binaryEntry.count + 15L >>> 4;
            monotonicBlockPackedReader = MonotonicBlockPackedReader.of(this.data, binaryEntry.packedIntsVersion, binaryEntry.blockSize, l2, false);
            if (!this.merging) {
                this.addressInstances.put(fieldInfo.name, monotonicBlockPackedReader);
                this.ramBytesUsed.addAndGet(monotonicBlockPackedReader.ramBytesUsed() + 4L);
            }
        }
        return monotonicBlockPackedReader;
    }

    private synchronized ReverseTermsIndex getReverseIndexInstance(FieldInfo fieldInfo, BinaryEntry binaryEntry) throws IOException {
        ReverseTermsIndex reverseTermsIndex = this.reverseIndexInstances.get(fieldInfo.name);
        if (reverseTermsIndex == null) {
            reverseTermsIndex = new ReverseTermsIndex();
            this.data.seek(binaryEntry.reverseIndexOffset);
            long l2 = binaryEntry.count + 1023L >>> 10;
            reverseTermsIndex.termAddresses = MonotonicBlockPackedReader.of(this.data, binaryEntry.packedIntsVersion, binaryEntry.blockSize, l2, false);
            long l3 = this.data.readVLong();
            PagedBytes pagedBytes = new PagedBytes(15);
            pagedBytes.copy(this.data, l3);
            reverseTermsIndex.terms = pagedBytes.freeze(true);
            if (!this.merging) {
                this.reverseIndexInstances.put(fieldInfo.name, reverseTermsIndex);
                this.ramBytesUsed.addAndGet(reverseTermsIndex.ramBytesUsed());
            }
        }
        return reverseTermsIndex;
    }

    private a getCompressedBinary(FieldInfo fieldInfo, BinaryEntry binaryEntry) throws IOException {
        MonotonicBlockPackedReader monotonicBlockPackedReader = this.getIntervalInstance(fieldInfo, binaryEntry);
        ReverseTermsIndex reverseTermsIndex = this.getReverseIndexInstance(fieldInfo, binaryEntry);
        assert (monotonicBlockPackedReader.size() > 0L);
        IndexInput indexInput = this.data.slice("terms", binaryEntry.offset, binaryEntry.addressesOffset - binaryEntry.offset);
        return new CompressedBinaryDocValues(binaryEntry, monotonicBlockPackedReader, reverseTermsIndex, indexInput);
    }

    @Override
    public SortedDocValues getSorted(FieldInfo fieldInfo) throws IOException {
        final int n2 = (int)this.binaries.get((Object)fieldInfo.name).count;
        final a a2 = this.getBinary(fieldInfo);
        NumericEntry numericEntry = this.ords.get(fieldInfo.name);
        final LongValues longValues = this.getNumeric(numericEntry);
        return new SortedDocValues(){

            @Override
            public int getOrd(int n22) {
                return (int)longValues.get(n22);
            }

            @Override
            public BytesRef lookupOrd(int n22) {
                return a2.get(n22);
            }

            @Override
            public int getValueCount() {
                return n2;
            }

            @Override
            public int lookupTerm(BytesRef bytesRef) {
                if (a2 instanceof CompressedBinaryDocValues) {
                    return (int)((CompressedBinaryDocValues)a2).lookupTerm(bytesRef);
                }
                return super.lookupTerm(bytesRef);
            }

            @Override
            public TermsEnum termsEnum() {
                if (a2 instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)a2).getTermsEnum();
                }
                return super.termsEnum();
            }
        };
    }

    private synchronized MonotonicBlockPackedReader getOrdIndexInstance(FieldInfo fieldInfo, NumericEntry numericEntry) throws IOException {
        MonotonicBlockPackedReader monotonicBlockPackedReader = this.ordIndexInstances.get(fieldInfo.name);
        if (monotonicBlockPackedReader == null) {
            this.data.seek(numericEntry.offset);
            monotonicBlockPackedReader = MonotonicBlockPackedReader.of(this.data, numericEntry.packedIntsVersion, numericEntry.blockSize, numericEntry.count + 1L, false);
            if (!this.merging) {
                this.ordIndexInstances.put(fieldInfo.name, monotonicBlockPackedReader);
                this.ramBytesUsed.addAndGet(monotonicBlockPackedReader.ramBytesUsed() + 4L);
            }
        }
        return monotonicBlockPackedReader;
    }

    @Override
    public p getSortedNumeric(FieldInfo fieldInfo) throws IOException {
        SortedSetEntry sortedSetEntry = this.sortedNumerics.get(fieldInfo.name);
        if (sortedSetEntry.format == 1) {
            NumericEntry numericEntry = this.numerics.get(fieldInfo.name);
            LongValues longValues = this.getNumeric(numericEntry);
            Bits bits = this.getLiveBits(numericEntry.missingOffset, this.maxDoc);
            return DocValues.singleton(longValues, bits);
        }
        if (sortedSetEntry.format == 0) {
            NumericEntry numericEntry = this.numerics.get(fieldInfo.name);
            final LongValues longValues = this.getNumeric(numericEntry);
            final MonotonicBlockPackedReader monotonicBlockPackedReader = this.getOrdIndexInstance(fieldInfo, this.ordIndexes.get(fieldInfo.name));
            return new p(){
                long startOffset;
                long endOffset;

                @Override
                public void setDocument(int n2) {
                    this.startOffset = monotonicBlockPackedReader.get(n2);
                    this.endOffset = monotonicBlockPackedReader.get((long)n2 + 1L);
                }

                @Override
                public long valueAt(int n2) {
                    return longValues.get(this.startOffset + (long)n2);
                }

                @Override
                public int count() {
                    return (int)(this.endOffset - this.startOffset);
                }
            };
        }
        if (sortedSetEntry.format == 2) {
            NumericEntry numericEntry = this.ords.get(fieldInfo.name);
            final LongValues longValues = this.getNumeric(numericEntry);
            final long[] lArray = sortedSetEntry.table;
            final int[] nArray = sortedSetEntry.tableOffsets;
            return new p(){
                int startOffset;
                int endOffset;

                @Override
                public void setDocument(int n2) {
                    int n3 = (int)longValues.get(n2);
                    this.startOffset = nArray[n3];
                    this.endOffset = nArray[n3 + 1];
                }

                @Override
                public long valueAt(int n2) {
                    return lArray[this.startOffset + n2];
                }

                @Override
                public int count() {
                    return this.endOffset - this.startOffset;
                }
            };
        }
        throw new AssertionError();
    }

    @Override
    public SortedSetDocValues getSortedSet(FieldInfo fieldInfo) throws IOException {
        SortedSetEntry sortedSetEntry = this.sortedSets.get(fieldInfo.name);
        switch (sortedSetEntry.format) {
            case 1: {
                SortedDocValues sortedDocValues = this.getSorted(fieldInfo);
                return DocValues.singleton(sortedDocValues);
            }
            case 0: {
                return this.getSortedSetWithAddresses(fieldInfo);
            }
            case 2: {
                return this.getSortedSetTable(fieldInfo, sortedSetEntry);
            }
        }
        throw new AssertionError();
    }

    private SortedSetDocValues getSortedSetWithAddresses(FieldInfo fieldInfo) throws IOException {
        final long l2 = this.binaries.get((Object)fieldInfo.name).count;
        final LongBinaryDocValues longBinaryDocValues = (LongBinaryDocValues)this.getBinary(fieldInfo);
        final LongValues longValues = this.getNumeric(this.ords.get(fieldInfo.name));
        final MonotonicBlockPackedReader monotonicBlockPackedReader = this.getOrdIndexInstance(fieldInfo, this.ordIndexes.get(fieldInfo.name));
        return new n(){
            long startOffset;
            long offset;
            long endOffset;

            @Override
            public long nextOrd() {
                if (this.offset == this.endOffset) {
                    return -1L;
                }
                long l22 = longValues.get(this.offset);
                ++this.offset;
                return l22;
            }

            @Override
            public void setDocument(int n2) {
                this.startOffset = this.offset = monotonicBlockPackedReader.get(n2);
                this.endOffset = monotonicBlockPackedReader.get((long)n2 + 1L);
            }

            @Override
            public BytesRef lookupOrd(long l22) {
                return longBinaryDocValues.get(l22);
            }

            @Override
            public long getValueCount() {
                return l2;
            }

            @Override
            public long lookupTerm(BytesRef bytesRef) {
                if (longBinaryDocValues instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)longBinaryDocValues).lookupTerm(bytesRef);
                }
                return super.lookupTerm(bytesRef);
            }

            @Override
            public TermsEnum termsEnum() {
                if (longBinaryDocValues instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)longBinaryDocValues).getTermsEnum();
                }
                return super.termsEnum();
            }

            @Override
            public long ordAt(int n2) {
                return longValues.get(this.startOffset + (long)n2);
            }

            @Override
            public int cardinality() {
                return (int)(this.endOffset - this.startOffset);
            }
        };
    }

    private SortedSetDocValues getSortedSetTable(FieldInfo fieldInfo, SortedSetEntry sortedSetEntry) throws IOException {
        final long l2 = this.binaries.get((Object)fieldInfo.name).count;
        final LongBinaryDocValues longBinaryDocValues = (LongBinaryDocValues)this.getBinary(fieldInfo);
        final LongValues longValues = this.getNumeric(this.ords.get(fieldInfo.name));
        final long[] lArray = sortedSetEntry.table;
        final int[] nArray = sortedSetEntry.tableOffsets;
        return new n(){
            int offset;
            int startOffset;
            int endOffset;

            @Override
            public void setDocument(int n2) {
                int n3 = (int)longValues.get(n2);
                this.offset = this.startOffset = nArray[n3];
                this.endOffset = nArray[n3 + 1];
            }

            @Override
            public long ordAt(int n2) {
                return lArray[this.startOffset + n2];
            }

            @Override
            public long nextOrd() {
                if (this.offset == this.endOffset) {
                    return -1L;
                }
                return lArray[this.offset++];
            }

            @Override
            public int cardinality() {
                return this.endOffset - this.startOffset;
            }

            @Override
            public BytesRef lookupOrd(long l22) {
                return longBinaryDocValues.get(l22);
            }

            @Override
            public long getValueCount() {
                return l2;
            }

            @Override
            public long lookupTerm(BytesRef bytesRef) {
                if (longBinaryDocValues instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)longBinaryDocValues).lookupTerm(bytesRef);
                }
                return super.lookupTerm(bytesRef);
            }

            @Override
            public TermsEnum termsEnum() {
                if (longBinaryDocValues instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)longBinaryDocValues).getTermsEnum();
                }
                return super.termsEnum();
            }
        };
    }

    private Bits getLiveBits(long l2, final int n2) throws IOException {
        if (l2 == -2L) {
            return new Bits.MatchNoBits(n2);
        }
        if (l2 == -1L) {
            return new Bits.MatchAllBits(n2);
        }
        int n3 = (int)((long)n2 + 7L >>> 3);
        final h h2 = this.data.randomAccessSlice(l2, n3);
        return new Bits(){

            @Override
            public boolean get(int n22) {
                try {
                    return (h2.readByte(n22 >> 3) & 1 << (n22 & 7)) != 0;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }

            @Override
            public int length() {
                return n2;
            }
        };
    }

    @Override
    public Bits getDocsWithField(FieldInfo fieldInfo) throws IOException {
        switch (fieldInfo.getDocValuesType()) {
            case SORTED_SET: {
                return DocValues.docsWithValue(this.getSortedSet(fieldInfo), this.maxDoc);
            }
            case SORTED_NUMERIC: {
                return DocValues.docsWithValue(this.getSortedNumeric(fieldInfo), this.maxDoc);
            }
            case SORTED: {
                return DocValues.docsWithValue(this.getSorted(fieldInfo), this.maxDoc);
            }
            case BINARY: {
                BinaryEntry binaryEntry = this.binaries.get(fieldInfo.name);
                return this.getLiveBits(binaryEntry.missingOffset, this.maxDoc);
            }
            case NUMERIC: {
                NumericEntry numericEntry = this.numerics.get(fieldInfo.name);
                return this.getLiveBits(numericEntry.missingOffset, this.maxDoc);
            }
        }
        throw new AssertionError();
    }

    @Override
    public synchronized b getMergeInstance() throws IOException {
        return new Lucene50DocValuesProducer(this);
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    static final class CompressedBinaryDocValues
    extends LongBinaryDocValues {
        final long numValues;
        final long numIndexValues;
        final int maxTermLength;
        final MonotonicBlockPackedReader addresses;
        final IndexInput data;
        final CompressedBinaryTermsEnum termsEnum;
        final PagedBytes.Reader reverseTerms;
        final MonotonicBlockPackedReader reverseAddresses;
        final long numReverseIndexValues;

        public CompressedBinaryDocValues(BinaryEntry binaryEntry, MonotonicBlockPackedReader monotonicBlockPackedReader, ReverseTermsIndex reverseTermsIndex, IndexInput indexInput) throws IOException {
            this.maxTermLength = binaryEntry.maxLength;
            this.numValues = binaryEntry.count;
            this.addresses = monotonicBlockPackedReader;
            this.numIndexValues = monotonicBlockPackedReader.size();
            this.data = indexInput;
            this.reverseTerms = reverseTermsIndex.terms;
            this.reverseAddresses = reverseTermsIndex.termAddresses;
            this.numReverseIndexValues = this.reverseAddresses.size();
            this.termsEnum = this.getTermsEnum(indexInput);
        }

        @Override
        public BytesRef get(long l2) {
            try {
                this.termsEnum.seekExact(l2);
                return this.termsEnum.term();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        long lookupTerm(BytesRef bytesRef) {
            try {
                switch (this.termsEnum.seekCeil(bytesRef)) {
                    case FOUND: {
                        return this.termsEnum.ord();
                    }
                    case NOT_FOUND: {
                        return -this.termsEnum.ord() - 1L;
                    }
                }
                return -this.numValues - 1L;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        TermsEnum getTermsEnum() {
            try {
                return this.getTermsEnum(this.data.clone());
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        private CompressedBinaryTermsEnum getTermsEnum(IndexInput indexInput) throws IOException {
            return new CompressedBinaryTermsEnum(indexInput);
        }

        class CompressedBinaryTermsEnum
        extends TermsEnum {
            private long currentOrd = -1L;
            private long currentBlockStart;
            private final IndexInput input;
            private final int[] offsets = new int[16];
            private final byte[] buffer = new byte[31];
            private final BytesRef term;
            private final BytesRef firstTerm;
            private final BytesRef scratch;

            CompressedBinaryTermsEnum(IndexInput indexInput) throws IOException {
                this.term = new BytesRef(CompressedBinaryDocValues.this.maxTermLength);
                this.firstTerm = new BytesRef(CompressedBinaryDocValues.this.maxTermLength);
                this.scratch = new BytesRef();
                this.input = indexInput;
                indexInput.seek(0L);
            }

            private void readHeader() throws IOException {
                this.firstTerm.length = this.input.readVInt();
                this.input.readBytes(this.firstTerm.bytes, 0, this.firstTerm.length);
                this.input.readBytes(this.buffer, 0, 15);
                if (this.buffer[0] == -1) {
                    this.readShortAddresses();
                } else {
                    this.readByteAddresses();
                }
                this.currentBlockStart = this.input.getFilePointer();
            }

            private void readByteAddresses() throws IOException {
                int n2 = 0;
                for (int i2 = 1; i2 < this.offsets.length; ++i2) {
                    this.offsets[i2] = n2 += 2 + (this.buffer[i2 - 1] & 0xFF);
                }
            }

            private void readShortAddresses() throws IOException {
                this.input.readBytes(this.buffer, 15, 16);
                int n2 = 0;
                for (int i2 = 1; i2 < this.offsets.length; ++i2) {
                    int n3 = i2 << 1;
                    this.offsets[i2] = n2 += 2 + (this.buffer[n3 - 1] << 8 | this.buffer[n3] & 0xFF);
                }
            }

            private void readFirstTerm() throws IOException {
                this.term.length = this.firstTerm.length;
                System.arraycopy(this.firstTerm.bytes, this.firstTerm.offset, this.term.bytes, 0, this.term.length);
            }

            private void readTerm(int n2) throws IOException {
                int n3 = this.input.readByte() & 0xFF;
                System.arraycopy(this.firstTerm.bytes, this.firstTerm.offset, this.term.bytes, 0, n3);
                int n4 = this.offsets[n2] - this.offsets[n2 - 1] - 1;
                this.input.readBytes(this.term.bytes, n3, n4);
                this.term.length = n3 + n4;
            }

            @Override
            public BytesRef next() throws IOException {
                ++this.currentOrd;
                if (this.currentOrd >= CompressedBinaryDocValues.this.numValues) {
                    return null;
                }
                int n2 = (int)(this.currentOrd & 0xFL);
                if (n2 == 0) {
                    this.readHeader();
                    this.readFirstTerm();
                } else {
                    this.readTerm(n2);
                }
                return this.term;
            }

            long binarySearchIndex(BytesRef bytesRef) throws IOException {
                long l2 = 0L;
                long l3 = CompressedBinaryDocValues.this.numReverseIndexValues - 1L;
                while (l2 <= l3) {
                    long l4 = l2 + l3 >>> 1;
                    CompressedBinaryDocValues.this.reverseTerms.fill(this.scratch, CompressedBinaryDocValues.this.reverseAddresses.get(l4));
                    int n2 = this.scratch.compareTo(bytesRef);
                    if (n2 < 0) {
                        l2 = l4 + 1L;
                        continue;
                    }
                    if (n2 > 0) {
                        l3 = l4 - 1L;
                        continue;
                    }
                    return l4;
                }
                return l3;
            }

            long binarySearchBlock(BytesRef bytesRef, long l2, long l3) throws IOException {
                while (l2 <= l3) {
                    long l4 = l2 + l3 >>> 1;
                    this.input.seek(CompressedBinaryDocValues.this.addresses.get(l4));
                    this.term.length = this.input.readVInt();
                    this.input.readBytes(this.term.bytes, 0, this.term.length);
                    int n2 = this.term.compareTo(bytesRef);
                    if (n2 < 0) {
                        l2 = l4 + 1L;
                        continue;
                    }
                    if (n2 > 0) {
                        l3 = l4 - 1L;
                        continue;
                    }
                    return l4;
                }
                return l3;
            }

            @Override
            public TermsEnum.SeekStatus seekCeil(BytesRef bytesRef) throws IOException {
                long l2;
                long l3 = this.binarySearchIndex(bytesRef);
                if (l3 < 0L) {
                    l2 = 0L;
                } else {
                    long l4 = l3 << 6;
                    long l5 = Math.min(CompressedBinaryDocValues.this.numIndexValues - 1L, l4 + 63L);
                    l2 = Math.max(l4, this.binarySearchBlock(bytesRef, l4, l5));
                }
                this.input.seek(CompressedBinaryDocValues.this.addresses.get(l2));
                this.currentOrd = (l2 << 4) - 1L;
                while (this.next() != null) {
                    int n2 = this.term.compareTo(bytesRef);
                    if (n2 == 0) {
                        return TermsEnum.SeekStatus.FOUND;
                    }
                    if (n2 <= 0) continue;
                    return TermsEnum.SeekStatus.NOT_FOUND;
                }
                return TermsEnum.SeekStatus.END;
            }

            @Override
            public void seekExact(long l2) throws IOException {
                long l3 = l2 >>> 4;
                if (l3 != this.currentOrd >>> 4) {
                    this.input.seek(CompressedBinaryDocValues.this.addresses.get(l3));
                    this.readHeader();
                }
                this.currentOrd = l2;
                int n2 = (int)(l2 & 0xFL);
                if (n2 == 0) {
                    this.readFirstTerm();
                } else {
                    this.input.seek(this.currentBlockStart + (long)this.offsets[n2 - 1]);
                    this.readTerm(n2);
                }
            }

            @Override
            public BytesRef term() throws IOException {
                return this.term;
            }

            @Override
            public long ord() throws IOException {
                return this.currentOrd;
            }

            @Override
            public int docFreq() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public long totalTermFreq() throws IOException {
                return -1L;
            }

            @Override
            public PostingsEnum postings(PostingsEnum postingsEnum, int n2) throws IOException {
                throw new UnsupportedOperationException();
            }
        }
    }

    static class ReverseTermsIndex
    implements org.apache.lucene.util.a {
        public MonotonicBlockPackedReader termAddresses;
        public PagedBytes.Reader terms;

        ReverseTermsIndex() {
        }

        @Override
        public long ramBytesUsed() {
            return this.termAddresses.ramBytesUsed() + this.terms.ramBytesUsed();
        }

        @Override
        public Collection<org.apache.lucene.util.a> getChildResources() {
            ArrayList<org.apache.lucene.util.a> arrayList = new ArrayList<org.apache.lucene.util.a>();
            arrayList.add(org.apache.lucene.util.b.a("term bytes", this.terms));
            arrayList.add(org.apache.lucene.util.b.a("term addresses", this.termAddresses));
            return Collections.unmodifiableList(arrayList);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(size=" + this.termAddresses.size() + ")";
        }
    }

    static abstract class LongBinaryDocValues
    extends a {
        LongBinaryDocValues() {
        }

        @Override
        public final BytesRef get(int n2) {
            return this.get((long)n2);
        }

        abstract BytesRef get(long var1);
    }

    static class SortedSetEntry {
        int format;
        long[] table;
        int[] tableOffsets;

        private SortedSetEntry() {
        }
    }

    static class BinaryEntry {
        long missingOffset;
        long offset;
        int format;
        public long count;
        int minLength;
        int maxLength;
        public long addressesOffset;
        public long reverseIndexOffset;
        public int packedIntsVersion;
        public int blockSize;

        private BinaryEntry() {
        }
    }

    static class NumericEntry {
        long missingOffset;
        public long offset;
        public long endOffset;
        public int bitsPerValue;
        int format;
        public int packedIntsVersion;
        public long count;
        public int blockSize;
        long minValue;
        long gcd;
        long[] table;

        private NumericEntry() {
        }
    }
}

