/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.c;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.b;

public final class Lucene50FieldInfosFormat
extends c {
    static final String EXTENSION = "fnm";
    static final String CODEC_NAME = "Lucene50FieldInfos";
    static final int FORMAT_START = 0;
    static final int FORMAT_SAFE_MAPS = 1;
    static final int FORMAT_CURRENT = 1;
    static final byte STORE_TERMVECTOR = 1;
    static final byte OMIT_NORMS = 2;
    static final byte STORE_PAYLOADS = 4;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldInfos read(org.apache.lucene.store.c c2, SegmentInfo segmentInfo, String string, IOContext iOContext) throws IOException {
        String string2 = IndexFileNames.segmentFileName(segmentInfo.name, string, EXTENSION);
        try (b b2 = c2.openChecksumInput(string2, iOContext);){
            Throwable throwable = null;
            FieldInfo[] fieldInfoArray = null;
            try {
                int n2 = CodecUtil.checkIndexHeader(b2, CODEC_NAME, 0, 1, segmentInfo.getId(), string);
                int n3 = b2.readVInt();
                fieldInfoArray = new FieldInfo[n3];
                Map<Object, Object> map = Collections.emptyMap();
                for (int i2 = 0; i2 < n3; ++i2) {
                    String string3 = b2.readString();
                    int n4 = b2.readVInt();
                    if (n4 < 0) {
                        throw new CorruptIndexException("invalid field number for field: " + string3 + ", fieldNumber=" + n4, b2);
                    }
                    byte by = b2.readByte();
                    boolean bl = (by & 1) != 0;
                    boolean bl2 = (by & 2) != 0;
                    boolean bl3 = (by & 4) != 0;
                    IndexOptions indexOptions = Lucene50FieldInfosFormat.getIndexOptions(b2, b2.readByte());
                    DocValuesType docValuesType = Lucene50FieldInfosFormat.getDocValuesType(b2, b2.readByte());
                    long l2 = b2.readLong();
                    Map<String, String> map2 = n2 >= 1 ? b2.readMapOfStrings() : Collections.unmodifiableMap(b2.readStringStringMap());
                    if (map2.equals(map)) {
                        map2 = map;
                    }
                    map = map2;
                    try {
                        fieldInfoArray[i2] = new FieldInfo(string3, n4, bl, bl2, bl3, indexOptions, docValuesType, l2, map2);
                        fieldInfoArray[i2].checkConsistency();
                        continue;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw new CorruptIndexException("invalid fieldinfo for field: " + string3 + ", fieldNumber=" + n4, b2, (Throwable)illegalStateException);
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
            finally {
                CodecUtil.checkFooter(b2, throwable);
            }
            FieldInfos fieldInfos = new FieldInfos(fieldInfoArray);
            return fieldInfos;
        }
    }

    private static byte docValuesByte(DocValuesType docValuesType) {
        switch (docValuesType) {
            case NONE: {
                return 0;
            }
            case NUMERIC: {
                return 1;
            }
            case BINARY: {
                return 2;
            }
            case SORTED: {
                return 3;
            }
            case SORTED_SET: {
                return 4;
            }
            case SORTED_NUMERIC: {
                return 5;
            }
        }
        throw new AssertionError((Object)("unhandled DocValuesType: " + (Object)((Object)docValuesType)));
    }

    private static DocValuesType getDocValuesType(IndexInput indexInput, byte by) throws IOException {
        switch (by) {
            case 0: {
                return DocValuesType.NONE;
            }
            case 1: {
                return DocValuesType.NUMERIC;
            }
            case 2: {
                return DocValuesType.BINARY;
            }
            case 3: {
                return DocValuesType.SORTED;
            }
            case 4: {
                return DocValuesType.SORTED_SET;
            }
            case 5: {
                return DocValuesType.SORTED_NUMERIC;
            }
        }
        throw new CorruptIndexException("invalid docvalues byte: " + by, indexInput);
    }

    private static byte indexOptionsByte(IndexOptions indexOptions) {
        switch (indexOptions) {
            case NONE: {
                return 0;
            }
            case DOCS: {
                return 1;
            }
            case DOCS_AND_FREQS: {
                return 2;
            }
            case DOCS_AND_FREQS_AND_POSITIONS: {
                return 3;
            }
            case DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS: {
                return 4;
            }
        }
        throw new AssertionError((Object)("unhandled IndexOptions: " + (Object)((Object)indexOptions)));
    }

    private static IndexOptions getIndexOptions(IndexInput indexInput, byte by) throws IOException {
        switch (by) {
            case 0: {
                return IndexOptions.NONE;
            }
            case 1: {
                return IndexOptions.DOCS;
            }
            case 2: {
                return IndexOptions.DOCS_AND_FREQS;
            }
            case 3: {
                return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
            }
            case 4: {
                return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;
            }
        }
        throw new CorruptIndexException("invalid IndexOptions byte: " + by, indexInput);
    }

    @Override
    public void write(org.apache.lucene.store.c c2, SegmentInfo segmentInfo, String string, FieldInfos fieldInfos, IOContext iOContext) throws IOException {
        String string2 = IndexFileNames.segmentFileName(segmentInfo.name, string, EXTENSION);
        try (IndexOutput indexOutput = c2.createOutput(string2, iOContext);){
            CodecUtil.writeIndexHeader(indexOutput, CODEC_NAME, 1, segmentInfo.getId(), string);
            indexOutput.writeVInt(fieldInfos.size());
            for (FieldInfo fieldInfo : fieldInfos) {
                fieldInfo.checkConsistency();
                indexOutput.writeString(fieldInfo.name);
                indexOutput.writeVInt(fieldInfo.number);
                byte by = 0;
                if (fieldInfo.hasVectors()) {
                    by = (byte)(by | 1);
                }
                if (fieldInfo.omitsNorms()) {
                    by = (byte)(by | 2);
                }
                if (fieldInfo.hasPayloads()) {
                    by = (byte)(by | 4);
                }
                indexOutput.writeByte(by);
                indexOutput.writeByte(Lucene50FieldInfosFormat.indexOptionsByte(fieldInfo.getIndexOptions()));
                indexOutput.writeByte(Lucene50FieldInfosFormat.docValuesByte(fieldInfo.getDocValuesType()));
                indexOutput.writeLong(fieldInfo.getDocValuesGen());
                indexOutput.writeMapOfStrings(fieldInfo.attributes());
            }
            CodecUtil.writeFooter(indexOutput);
        }
    }

    static {
        boolean bl = $assertionsDisabled = !Lucene50FieldInfosFormat.class.desiredAssertionStatus();
        if (!$assertionsDisabled && DocValuesType.values().length != 6) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && IndexOptions.values().length != 5) {
            throw new AssertionError();
        }
    }
}

