/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.IOException;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.blocktree.BlockTreeTermsReader;
import org.apache.lucene.codecs.blocktree.BlockTreeTermsWriter;
import org.apache.lucene.codecs.d;
import org.apache.lucene.codecs.e;
import org.apache.lucene.codecs.lucene50.Lucene50PostingsReader;
import org.apache.lucene.codecs.lucene50.Lucene50PostingsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.q;
import org.apache.lucene.util.IOUtils;

public final class Lucene50PostingsFormat
extends PostingsFormat {
    public static final String DOC_EXTENSION = "doc";
    public static final String POS_EXTENSION = "pos";
    public static final String PAY_EXTENSION = "pay";
    static final int MAX_SKIP_LEVELS = 10;
    static final String TERMS_CODEC = "Lucene50PostingsWriterTerms";
    static final String DOC_CODEC = "Lucene50PostingsWriterDoc";
    static final String POS_CODEC = "Lucene50PostingsWriterPos";
    static final String PAY_CODEC = "Lucene50PostingsWriterPay";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;
    private final int minTermBlockSize;
    private final int maxTermBlockSize;
    public static final int BLOCK_SIZE = 128;

    public Lucene50PostingsFormat() {
        this(25, 48);
    }

    public Lucene50PostingsFormat(int n2, int n3) {
        super("Lucene50");
        BlockTreeTermsWriter.validateSettings(n2, n3);
        this.minTermBlockSize = n2;
        this.maxTermBlockSize = n3;
    }

    @Override
    public String toString() {
        return this.getName() + "(blocksize=" + 128 + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public d fieldsConsumer(SegmentWriteState segmentWriteState) throws IOException {
        BlockTreeTermsWriter blockTreeTermsWriter;
        block3: {
            Lucene50PostingsWriter lucene50PostingsWriter = new Lucene50PostingsWriter(segmentWriteState);
            boolean bl = false;
            try {
                BlockTreeTermsWriter blockTreeTermsWriter2 = new BlockTreeTermsWriter(segmentWriteState, lucene50PostingsWriter, this.minTermBlockSize, this.maxTermBlockSize);
                bl = true;
                blockTreeTermsWriter = blockTreeTermsWriter2;
                if (bl) break block3;
            }
            catch (Throwable throwable) {
                if (!bl) {
                    IOUtils.closeWhileHandlingException(lucene50PostingsWriter);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(lucene50PostingsWriter);
        }
        return blockTreeTermsWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public e fieldsProducer(SegmentReadState segmentReadState) throws IOException {
        BlockTreeTermsReader blockTreeTermsReader;
        block3: {
            Lucene50PostingsReader lucene50PostingsReader = new Lucene50PostingsReader(segmentReadState);
            boolean bl = false;
            try {
                BlockTreeTermsReader blockTreeTermsReader2 = new BlockTreeTermsReader(lucene50PostingsReader, segmentReadState);
                bl = true;
                blockTreeTermsReader = blockTreeTermsReader2;
                if (bl) break block3;
            }
            catch (Throwable throwable) {
                if (!bl) {
                    IOUtils.closeWhileHandlingException(lucene50PostingsReader);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(lucene50PostingsReader);
        }
        return blockTreeTermsReader;
    }

    static final class IntBlockTermState
    extends BlockTermState {
        long docStartFP = 0L;
        long posStartFP = 0L;
        long payStartFP = 0L;
        long skipOffset = -1L;
        long lastPosBlockOffset = -1L;
        int singletonDocID = -1;

        IntBlockTermState() {
        }

        @Override
        public IntBlockTermState clone() {
            IntBlockTermState intBlockTermState = new IntBlockTermState();
            intBlockTermState.copyFrom(this);
            return intBlockTermState;
        }

        @Override
        public void copyFrom(q q2) {
            super.copyFrom(q2);
            IntBlockTermState intBlockTermState = (IntBlockTermState)q2;
            this.docStartFP = intBlockTermState.docStartFP;
            this.posStartFP = intBlockTermState.posStartFP;
            this.payStartFP = intBlockTermState.payStartFP;
            this.lastPosBlockOffset = intBlockTermState.lastPosBlockOffset;
            this.skipOffset = intBlockTermState.skipOffset;
            this.singletonDocID = intBlockTermState.singletonDocID;
        }

        @Override
        public String toString() {
            return super.toString() + " docStartFP=" + this.docStartFP + " posStartFP=" + this.posStartFP + " payStartFP=" + this.payStartFP + " lastPosBlockOffset=" + this.lastPosBlockOffset + " singletonDocID=" + this.singletonDocID;
        }
    }
}

