/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.j;
import org.apache.lucene.codecs.lucene50.ForUtil;
import org.apache.lucene.codecs.lucene50.Lucene50PostingsFormat;
import org.apache.lucene.codecs.lucene50.Lucene50SkipReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.a;

public final class Lucene50PostingsReader
extends j {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Lucene50PostingsReader.class);
    private final IndexInput docIn;
    private final IndexInput posIn;
    private final IndexInput payIn;
    final ForUtil forUtil;
    private int version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene50PostingsReader(SegmentReadState segmentReadState) throws IOException {
        boolean bl = false;
        IndexInput indexInput = null;
        IndexInput indexInput2 = null;
        IndexInput indexInput3 = null;
        String string = IndexFileNames.segmentFileName(segmentReadState.segmentInfo.name, segmentReadState.segmentSuffix, "doc");
        try {
            indexInput = segmentReadState.directory.openInput(string, segmentReadState.context);
            this.version = CodecUtil.checkIndexHeader(indexInput, "Lucene50PostingsWriterDoc", 0, 0, segmentReadState.segmentInfo.getId(), segmentReadState.segmentSuffix);
            this.forUtil = new ForUtil(indexInput);
            CodecUtil.retrieveChecksum(indexInput);
            if (segmentReadState.fieldInfos.hasProx()) {
                String string2 = IndexFileNames.segmentFileName(segmentReadState.segmentInfo.name, segmentReadState.segmentSuffix, "pos");
                indexInput2 = segmentReadState.directory.openInput(string2, segmentReadState.context);
                CodecUtil.checkIndexHeader(indexInput2, "Lucene50PostingsWriterPos", this.version, this.version, segmentReadState.segmentInfo.getId(), segmentReadState.segmentSuffix);
                CodecUtil.retrieveChecksum(indexInput2);
                if (segmentReadState.fieldInfos.hasPayloads() || segmentReadState.fieldInfos.hasOffsets()) {
                    String string3 = IndexFileNames.segmentFileName(segmentReadState.segmentInfo.name, segmentReadState.segmentSuffix, "pay");
                    indexInput3 = segmentReadState.directory.openInput(string3, segmentReadState.context);
                    CodecUtil.checkIndexHeader(indexInput3, "Lucene50PostingsWriterPay", this.version, this.version, segmentReadState.segmentInfo.getId(), segmentReadState.segmentSuffix);
                    CodecUtil.retrieveChecksum(indexInput3);
                }
            }
            this.docIn = indexInput;
            this.posIn = indexInput2;
            this.payIn = indexInput3;
            bl = true;
            if (bl) return;
        }
        catch (Throwable throwable) {
            if (bl) throw throwable;
            IOUtils.closeWhileHandlingException(indexInput, indexInput2, indexInput3);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(indexInput, indexInput2, indexInput3);
    }

    @Override
    public void init(IndexInput indexInput, SegmentReadState segmentReadState) throws IOException {
        CodecUtil.checkIndexHeader(indexInput, "Lucene50PostingsWriterTerms", 0, 0, segmentReadState.segmentInfo.getId(), segmentReadState.segmentSuffix);
        int n2 = indexInput.readVInt();
        if (n2 != 128) {
            throw new IllegalStateException("index-time BLOCK_SIZE (" + n2 + ") != read-time BLOCK_SIZE (" + 128 + ")");
        }
    }

    static void readVIntBlock(IndexInput indexInput, int[] nArray, int[] nArray2, int n2, boolean bl) throws IOException {
        if (bl) {
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = indexInput.readVInt();
                nArray[i2] = n3 >>> 1;
                nArray2[i2] = (n3 & 1) != 0 ? 1 : indexInput.readVInt();
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                nArray[i3] = indexInput.readVInt();
            }
        }
    }

    @Override
    public BlockTermState newTermState() {
        return new Lucene50PostingsFormat.IntBlockTermState();
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.docIn, this.posIn, this.payIn);
    }

    @Override
    public void decodeTerm(long[] lArray, DataInput dataInput, FieldInfo fieldInfo, BlockTermState blockTermState, boolean bl) throws IOException {
        Lucene50PostingsFormat.IntBlockTermState intBlockTermState = (Lucene50PostingsFormat.IntBlockTermState)blockTermState;
        boolean bl2 = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        boolean bl3 = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        boolean bl4 = fieldInfo.hasPayloads();
        if (bl) {
            intBlockTermState.docStartFP = 0L;
            intBlockTermState.posStartFP = 0L;
            intBlockTermState.payStartFP = 0L;
        }
        intBlockTermState.docStartFP += lArray[0];
        if (bl2) {
            intBlockTermState.posStartFP += lArray[1];
            if (bl3 || bl4) {
                intBlockTermState.payStartFP += lArray[2];
            }
        }
        intBlockTermState.singletonDocID = intBlockTermState.docFreq == 1 ? dataInput.readVInt() : -1;
        if (bl2) {
            intBlockTermState.lastPosBlockOffset = intBlockTermState.totalTermFreq > 128L ? dataInput.readVLong() : -1L;
        }
        intBlockTermState.skipOffset = intBlockTermState.docFreq > 128 ? dataInput.readVLong() : -1L;
    }

    @Override
    public PostingsEnum postings(FieldInfo fieldInfo, BlockTermState blockTermState, PostingsEnum postingsEnum, int n2) throws IOException {
        EverythingEnum everythingEnum;
        boolean bl = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        boolean bl2 = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        boolean bl3 = fieldInfo.hasPayloads();
        if (PostingsEnum.featureRequested(n2, (short)16384) && !bl) {
            return null;
        }
        if (!bl || !PostingsEnum.featureRequested(n2, (short)24)) {
            BlockDocsEnum blockDocsEnum;
            if (postingsEnum instanceof BlockDocsEnum) {
                blockDocsEnum = (BlockDocsEnum)postingsEnum;
                if (!blockDocsEnum.canReuse(this.docIn, fieldInfo)) {
                    blockDocsEnum = new BlockDocsEnum(fieldInfo);
                }
            } else {
                blockDocsEnum = new BlockDocsEnum(fieldInfo);
            }
            return blockDocsEnum.reset((Lucene50PostingsFormat.IntBlockTermState)blockTermState, n2);
        }
        if (!(bl2 && PostingsEnum.featureRequested(n2, (short)56) || bl3 && PostingsEnum.featureRequested(n2, (short)88))) {
            BlockPostingsEnum blockPostingsEnum;
            if (postingsEnum instanceof BlockPostingsEnum) {
                blockPostingsEnum = (BlockPostingsEnum)postingsEnum;
                if (!blockPostingsEnum.canReuse(this.docIn, fieldInfo)) {
                    blockPostingsEnum = new BlockPostingsEnum(fieldInfo);
                }
            } else {
                blockPostingsEnum = new BlockPostingsEnum(fieldInfo);
            }
            return blockPostingsEnum.reset((Lucene50PostingsFormat.IntBlockTermState)blockTermState);
        }
        if (postingsEnum instanceof EverythingEnum) {
            everythingEnum = (EverythingEnum)postingsEnum;
            if (!everythingEnum.canReuse(this.docIn, fieldInfo)) {
                everythingEnum = new EverythingEnum(fieldInfo);
            }
        } else {
            everythingEnum = new EverythingEnum(fieldInfo);
        }
        return everythingEnum.reset((Lucene50PostingsFormat.IntBlockTermState)blockTermState, n2);
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED;
    }

    @Override
    public Collection<a> getChildResources() {
        return Collections.emptyList();
    }

    @Override
    public void checkIntegrity() throws IOException {
        if (this.docIn != null) {
            CodecUtil.checksumEntireFile(this.docIn);
        }
        if (this.posIn != null) {
            CodecUtil.checksumEntireFile(this.posIn);
        }
        if (this.payIn != null) {
            CodecUtil.checksumEntireFile(this.payIn);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(positions=" + (this.posIn != null) + ",payloads=" + (this.payIn != null) + ")";
    }

    final class EverythingEnum
    extends PostingsEnum {
        private final byte[] encoded;
        private final int[] docDeltaBuffer = new int[ForUtil.MAX_DATA_SIZE];
        private final int[] freqBuffer = new int[ForUtil.MAX_DATA_SIZE];
        private final int[] posDeltaBuffer = new int[ForUtil.MAX_DATA_SIZE];
        private final int[] payloadLengthBuffer;
        private final int[] offsetStartDeltaBuffer;
        private final int[] offsetLengthBuffer;
        private byte[] payloadBytes;
        private int payloadByteUpto;
        private int payloadLength;
        private int lastStartOffset;
        private int startOffset;
        private int endOffset;
        private int docBufferUpto;
        private int posBufferUpto;
        private Lucene50SkipReader skipper;
        private boolean skipped;
        final IndexInput startDocIn;
        IndexInput docIn;
        final IndexInput posIn;
        final IndexInput payIn;
        final BytesRef payload;
        final boolean indexHasOffsets;
        final boolean indexHasPayloads;
        private int docFreq;
        private long totalTermFreq;
        private int docUpto;
        private int doc;
        private int accum;
        private int freq;
        private int position;
        private int posPendingCount;
        private long posPendingFP;
        private long payPendingFP;
        private long docTermStartFP;
        private long posTermStartFP;
        private long payTermStartFP;
        private long lastPosBlockFP;
        private long skipOffset;
        private int nextSkipDoc;
        private boolean needsOffsets;
        private boolean needsPayloads;
        private int singletonDocID;

        public EverythingEnum(FieldInfo fieldInfo) throws IOException {
            this.startDocIn = Lucene50PostingsReader.this.docIn;
            this.docIn = null;
            this.posIn = Lucene50PostingsReader.this.posIn.clone();
            this.payIn = Lucene50PostingsReader.this.payIn.clone();
            this.encoded = new byte[512];
            boolean bl = this.indexHasOffsets = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
            if (this.indexHasOffsets) {
                this.offsetStartDeltaBuffer = new int[ForUtil.MAX_DATA_SIZE];
                this.offsetLengthBuffer = new int[ForUtil.MAX_DATA_SIZE];
            } else {
                this.offsetStartDeltaBuffer = null;
                this.offsetLengthBuffer = null;
                this.startOffset = -1;
                this.endOffset = -1;
            }
            this.indexHasPayloads = fieldInfo.hasPayloads();
            if (this.indexHasPayloads) {
                this.payloadLengthBuffer = new int[ForUtil.MAX_DATA_SIZE];
                this.payloadBytes = new byte[128];
                this.payload = new BytesRef();
            } else {
                this.payloadLengthBuffer = null;
                this.payloadBytes = null;
                this.payload = null;
            }
        }

        public boolean canReuse(IndexInput indexInput, FieldInfo fieldInfo) {
            return indexInput == this.startDocIn && this.indexHasOffsets == fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0 && this.indexHasPayloads == fieldInfo.hasPayloads();
        }

        public EverythingEnum reset(Lucene50PostingsFormat.IntBlockTermState intBlockTermState, int n2) throws IOException {
            this.docFreq = intBlockTermState.docFreq;
            this.docTermStartFP = intBlockTermState.docStartFP;
            this.posTermStartFP = intBlockTermState.posStartFP;
            this.payTermStartFP = intBlockTermState.payStartFP;
            this.skipOffset = intBlockTermState.skipOffset;
            this.totalTermFreq = intBlockTermState.totalTermFreq;
            this.singletonDocID = intBlockTermState.singletonDocID;
            if (this.docFreq > 1) {
                if (this.docIn == null) {
                    this.docIn = this.startDocIn.clone();
                }
                this.docIn.seek(this.docTermStartFP);
            }
            this.posPendingFP = this.posTermStartFP;
            this.payPendingFP = this.payTermStartFP;
            this.posPendingCount = 0;
            this.lastPosBlockFP = intBlockTermState.totalTermFreq < 128L ? this.posTermStartFP : (intBlockTermState.totalTermFreq == 128L ? -1L : this.posTermStartFP + intBlockTermState.lastPosBlockOffset);
            this.needsOffsets = PostingsEnum.featureRequested(n2, (short)56);
            this.needsPayloads = PostingsEnum.featureRequested(n2, (short)88);
            this.doc = -1;
            this.accum = 0;
            this.docUpto = 0;
            this.nextSkipDoc = this.docFreq > 128 ? 127 : Integer.MAX_VALUE;
            this.docBufferUpto = 128;
            this.skipped = false;
            return this;
        }

        @Override
        public int freq() throws IOException {
            return this.freq;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        private void refillDocs() throws IOException {
            int n2 = this.docFreq - this.docUpto;
            assert (n2 > 0);
            if (n2 >= 128) {
                Lucene50PostingsReader.this.forUtil.readBlock(this.docIn, this.encoded, this.docDeltaBuffer);
                Lucene50PostingsReader.this.forUtil.readBlock(this.docIn, this.encoded, this.freqBuffer);
            } else if (this.docFreq == 1) {
                this.docDeltaBuffer[0] = this.singletonDocID;
                this.freqBuffer[0] = (int)this.totalTermFreq;
            } else {
                Lucene50PostingsReader.readVIntBlock(this.docIn, this.docDeltaBuffer, this.freqBuffer, n2, true);
            }
            this.docBufferUpto = 0;
        }

        private void refillPositions() throws IOException {
            if (this.posIn.getFilePointer() == this.lastPosBlockFP) {
                int n2 = (int)(this.totalTermFreq % 128L);
                int n3 = 0;
                int n4 = 0;
                this.payloadByteUpto = 0;
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n5 = this.posIn.readVInt();
                    if (this.indexHasPayloads) {
                        if ((n5 & 1) != 0) {
                            n3 = this.posIn.readVInt();
                        }
                        this.payloadLengthBuffer[i2] = n3;
                        this.posDeltaBuffer[i2] = n5 >>> 1;
                        if (n3 != 0) {
                            if (this.payloadByteUpto + n3 > this.payloadBytes.length) {
                                this.payloadBytes = ArrayUtil.grow(this.payloadBytes, this.payloadByteUpto + n3);
                            }
                            this.posIn.readBytes(this.payloadBytes, this.payloadByteUpto, n3);
                            this.payloadByteUpto += n3;
                        }
                    } else {
                        this.posDeltaBuffer[i2] = n5;
                    }
                    if (!this.indexHasOffsets) continue;
                    int n6 = this.posIn.readVInt();
                    if ((n6 & 1) != 0) {
                        n4 = this.posIn.readVInt();
                    }
                    this.offsetStartDeltaBuffer[i2] = n6 >>> 1;
                    this.offsetLengthBuffer[i2] = n4;
                }
                this.payloadByteUpto = 0;
            } else {
                Lucene50PostingsReader.this.forUtil.readBlock(this.posIn, this.encoded, this.posDeltaBuffer);
                if (this.indexHasPayloads) {
                    if (this.needsPayloads) {
                        Lucene50PostingsReader.this.forUtil.readBlock(this.payIn, this.encoded, this.payloadLengthBuffer);
                        int n7 = this.payIn.readVInt();
                        if (n7 > this.payloadBytes.length) {
                            this.payloadBytes = ArrayUtil.grow(this.payloadBytes, n7);
                        }
                        this.payIn.readBytes(this.payloadBytes, 0, n7);
                    } else {
                        Lucene50PostingsReader.this.forUtil.skipBlock(this.payIn);
                        int n8 = this.payIn.readVInt();
                        this.payIn.seek(this.payIn.getFilePointer() + (long)n8);
                    }
                    this.payloadByteUpto = 0;
                }
                if (this.indexHasOffsets) {
                    if (this.needsOffsets) {
                        Lucene50PostingsReader.this.forUtil.readBlock(this.payIn, this.encoded, this.offsetStartDeltaBuffer);
                        Lucene50PostingsReader.this.forUtil.readBlock(this.payIn, this.encoded, this.offsetLengthBuffer);
                    } else {
                        Lucene50PostingsReader.this.forUtil.skipBlock(this.payIn);
                        Lucene50PostingsReader.this.forUtil.skipBlock(this.payIn);
                    }
                }
            }
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.docUpto == this.docFreq) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            if (this.docBufferUpto == 128) {
                this.refillDocs();
            }
            this.accum += this.docDeltaBuffer[this.docBufferUpto];
            this.freq = this.freqBuffer[this.docBufferUpto];
            this.posPendingCount += this.freq;
            ++this.docBufferUpto;
            ++this.docUpto;
            this.doc = this.accum;
            this.position = 0;
            this.lastStartOffset = 0;
            return this.doc;
        }

        @Override
        public int advance(int n2) throws IOException {
            block9: {
                if (n2 > this.nextSkipDoc) {
                    int n3;
                    if (this.skipper == null) {
                        this.skipper = new Lucene50SkipReader(this.docIn.clone(), 10, true, this.indexHasOffsets, this.indexHasPayloads);
                    }
                    if (!this.skipped) {
                        assert (this.skipOffset != -1L);
                        this.skipper.init(this.docTermStartFP + this.skipOffset, this.docTermStartFP, this.posTermStartFP, this.payTermStartFP, this.docFreq);
                        this.skipped = true;
                    }
                    if ((n3 = this.skipper.skipTo(n2) + 1) > this.docUpto) {
                        assert (n3 % 128 == 0) : "got " + n3;
                        this.docUpto = n3;
                        this.docBufferUpto = 128;
                        this.accum = this.skipper.getDoc();
                        this.docIn.seek(this.skipper.getDocPointer());
                        this.posPendingFP = this.skipper.getPosPointer();
                        this.payPendingFP = this.skipper.getPayPointer();
                        this.posPendingCount = this.skipper.getPosBufferUpto();
                        this.lastStartOffset = 0;
                        this.payloadByteUpto = this.skipper.getPayloadByteUpto();
                    }
                    this.nextSkipDoc = this.skipper.getNextSkipDoc();
                }
                if (this.docUpto == this.docFreq) {
                    this.doc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                if (this.docBufferUpto == 128) {
                    this.refillDocs();
                }
                do {
                    this.accum += this.docDeltaBuffer[this.docBufferUpto];
                    this.freq = this.freqBuffer[this.docBufferUpto];
                    this.posPendingCount += this.freq;
                    ++this.docBufferUpto;
                    ++this.docUpto;
                    if (this.accum >= n2) break block9;
                } while (this.docUpto != this.docFreq);
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.position = 0;
            this.lastStartOffset = 0;
            this.doc = this.accum;
            return this.doc;
        }

        private void skipPositions() throws IOException {
            int n2 = this.posPendingCount - this.freq;
            int n3 = 128 - this.posBufferUpto;
            if (n2 < n3) {
                int n4 = this.posBufferUpto + n2;
                while (this.posBufferUpto < n4) {
                    if (this.indexHasPayloads) {
                        this.payloadByteUpto += this.payloadLengthBuffer[this.posBufferUpto];
                    }
                    ++this.posBufferUpto;
                }
            } else {
                n2 -= n3;
                while (n2 >= 128) {
                    assert (this.posIn.getFilePointer() != this.lastPosBlockFP);
                    Lucene50PostingsReader.this.forUtil.skipBlock(this.posIn);
                    if (this.indexHasPayloads) {
                        Lucene50PostingsReader.this.forUtil.skipBlock(this.payIn);
                        int n5 = this.payIn.readVInt();
                        this.payIn.seek(this.payIn.getFilePointer() + (long)n5);
                    }
                    if (this.indexHasOffsets) {
                        Lucene50PostingsReader.this.forUtil.skipBlock(this.payIn);
                        Lucene50PostingsReader.this.forUtil.skipBlock(this.payIn);
                    }
                    n2 -= 128;
                }
                this.refillPositions();
                this.payloadByteUpto = 0;
                this.posBufferUpto = 0;
                while (this.posBufferUpto < n2) {
                    if (this.indexHasPayloads) {
                        this.payloadByteUpto += this.payloadLengthBuffer[this.posBufferUpto];
                    }
                    ++this.posBufferUpto;
                }
            }
            this.position = 0;
            this.lastStartOffset = 0;
        }

        @Override
        public int nextPosition() throws IOException {
            assert (this.posPendingCount > 0);
            if (this.posPendingFP != -1L) {
                this.posIn.seek(this.posPendingFP);
                this.posPendingFP = -1L;
                if (this.payPendingFP != -1L) {
                    this.payIn.seek(this.payPendingFP);
                    this.payPendingFP = -1L;
                }
                this.posBufferUpto = 128;
            }
            if (this.posPendingCount > this.freq) {
                this.skipPositions();
                this.posPendingCount = this.freq;
            }
            if (this.posBufferUpto == 128) {
                this.refillPositions();
                this.posBufferUpto = 0;
            }
            this.position += this.posDeltaBuffer[this.posBufferUpto];
            if (this.indexHasPayloads) {
                this.payloadLength = this.payloadLengthBuffer[this.posBufferUpto];
                this.payload.bytes = this.payloadBytes;
                this.payload.offset = this.payloadByteUpto;
                this.payload.length = this.payloadLength;
                this.payloadByteUpto += this.payloadLength;
            }
            if (this.indexHasOffsets) {
                this.startOffset = this.lastStartOffset + this.offsetStartDeltaBuffer[this.posBufferUpto];
                this.endOffset = this.startOffset + this.offsetLengthBuffer[this.posBufferUpto];
                this.lastStartOffset = this.startOffset;
            }
            ++this.posBufferUpto;
            --this.posPendingCount;
            return this.position;
        }

        @Override
        public int startOffset() {
            return this.startOffset;
        }

        @Override
        public int endOffset() {
            return this.endOffset;
        }

        @Override
        public BytesRef getPayload() {
            if (this.payloadLength == 0) {
                return null;
            }
            return this.payload;
        }

        @Override
        public long cost() {
            return this.docFreq;
        }
    }

    final class BlockPostingsEnum
    extends PostingsEnum {
        private final byte[] encoded;
        private final int[] docDeltaBuffer = new int[ForUtil.MAX_DATA_SIZE];
        private final int[] freqBuffer = new int[ForUtil.MAX_DATA_SIZE];
        private final int[] posDeltaBuffer = new int[ForUtil.MAX_DATA_SIZE];
        private int docBufferUpto;
        private int posBufferUpto;
        private Lucene50SkipReader skipper;
        private boolean skipped;
        final IndexInput startDocIn;
        IndexInput docIn;
        final IndexInput posIn;
        final boolean indexHasOffsets;
        final boolean indexHasPayloads;
        private int docFreq;
        private long totalTermFreq;
        private int docUpto;
        private int doc;
        private int accum;
        private int freq;
        private int position;
        private int posPendingCount;
        private long posPendingFP;
        private long docTermStartFP;
        private long posTermStartFP;
        private long payTermStartFP;
        private long lastPosBlockFP;
        private long skipOffset;
        private int nextSkipDoc;
        private int singletonDocID;

        public BlockPostingsEnum(FieldInfo fieldInfo) throws IOException {
            this.startDocIn = Lucene50PostingsReader.this.docIn;
            this.docIn = null;
            this.posIn = Lucene50PostingsReader.this.posIn.clone();
            this.encoded = new byte[512];
            this.indexHasOffsets = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
            this.indexHasPayloads = fieldInfo.hasPayloads();
        }

        public boolean canReuse(IndexInput indexInput, FieldInfo fieldInfo) {
            return indexInput == this.startDocIn && this.indexHasOffsets == fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0 && this.indexHasPayloads == fieldInfo.hasPayloads();
        }

        public PostingsEnum reset(Lucene50PostingsFormat.IntBlockTermState intBlockTermState) throws IOException {
            this.docFreq = intBlockTermState.docFreq;
            this.docTermStartFP = intBlockTermState.docStartFP;
            this.posTermStartFP = intBlockTermState.posStartFP;
            this.payTermStartFP = intBlockTermState.payStartFP;
            this.skipOffset = intBlockTermState.skipOffset;
            this.totalTermFreq = intBlockTermState.totalTermFreq;
            this.singletonDocID = intBlockTermState.singletonDocID;
            if (this.docFreq > 1) {
                if (this.docIn == null) {
                    this.docIn = this.startDocIn.clone();
                }
                this.docIn.seek(this.docTermStartFP);
            }
            this.posPendingFP = this.posTermStartFP;
            this.posPendingCount = 0;
            this.lastPosBlockFP = intBlockTermState.totalTermFreq < 128L ? this.posTermStartFP : (intBlockTermState.totalTermFreq == 128L ? -1L : this.posTermStartFP + intBlockTermState.lastPosBlockOffset);
            this.doc = -1;
            this.accum = 0;
            this.docUpto = 0;
            this.nextSkipDoc = this.docFreq > 128 ? 127 : Integer.MAX_VALUE;
            this.docBufferUpto = 128;
            this.skipped = false;
            return this;
        }

        @Override
        public int freq() throws IOException {
            return this.freq;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        private void refillDocs() throws IOException {
            int n2 = this.docFreq - this.docUpto;
            assert (n2 > 0);
            if (n2 >= 128) {
                Lucene50PostingsReader.this.forUtil.readBlock(this.docIn, this.encoded, this.docDeltaBuffer);
                Lucene50PostingsReader.this.forUtil.readBlock(this.docIn, this.encoded, this.freqBuffer);
            } else if (this.docFreq == 1) {
                this.docDeltaBuffer[0] = this.singletonDocID;
                this.freqBuffer[0] = (int)this.totalTermFreq;
            } else {
                Lucene50PostingsReader.readVIntBlock(this.docIn, this.docDeltaBuffer, this.freqBuffer, n2, true);
            }
            this.docBufferUpto = 0;
        }

        private void refillPositions() throws IOException {
            if (this.posIn.getFilePointer() == this.lastPosBlockFP) {
                int n2 = (int)(this.totalTermFreq % 128L);
                int n3 = 0;
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n4 = this.posIn.readVInt();
                    if (this.indexHasPayloads) {
                        if ((n4 & 1) != 0) {
                            n3 = this.posIn.readVInt();
                        }
                        this.posDeltaBuffer[i2] = n4 >>> 1;
                        if (n3 != 0) {
                            this.posIn.seek(this.posIn.getFilePointer() + (long)n3);
                        }
                    } else {
                        this.posDeltaBuffer[i2] = n4;
                    }
                    if (!this.indexHasOffsets || (this.posIn.readVInt() & 1) == 0) continue;
                    this.posIn.readVInt();
                }
            } else {
                Lucene50PostingsReader.this.forUtil.readBlock(this.posIn, this.encoded, this.posDeltaBuffer);
            }
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.docUpto == this.docFreq) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            if (this.docBufferUpto == 128) {
                this.refillDocs();
            }
            this.accum += this.docDeltaBuffer[this.docBufferUpto];
            this.freq = this.freqBuffer[this.docBufferUpto];
            this.posPendingCount += this.freq;
            ++this.docBufferUpto;
            ++this.docUpto;
            this.doc = this.accum;
            this.position = 0;
            return this.doc;
        }

        @Override
        public int advance(int n2) throws IOException {
            block9: {
                if (n2 > this.nextSkipDoc) {
                    int n3;
                    if (this.skipper == null) {
                        this.skipper = new Lucene50SkipReader(this.docIn.clone(), 10, true, this.indexHasOffsets, this.indexHasPayloads);
                    }
                    if (!this.skipped) {
                        assert (this.skipOffset != -1L);
                        this.skipper.init(this.docTermStartFP + this.skipOffset, this.docTermStartFP, this.posTermStartFP, this.payTermStartFP, this.docFreq);
                        this.skipped = true;
                    }
                    if ((n3 = this.skipper.skipTo(n2) + 1) > this.docUpto) {
                        assert (n3 % 128 == 0) : "got " + n3;
                        this.docUpto = n3;
                        this.docBufferUpto = 128;
                        this.accum = this.skipper.getDoc();
                        this.docIn.seek(this.skipper.getDocPointer());
                        this.posPendingFP = this.skipper.getPosPointer();
                        this.posPendingCount = this.skipper.getPosBufferUpto();
                    }
                    this.nextSkipDoc = this.skipper.getNextSkipDoc();
                }
                if (this.docUpto == this.docFreq) {
                    this.doc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                if (this.docBufferUpto == 128) {
                    this.refillDocs();
                }
                do {
                    this.accum += this.docDeltaBuffer[this.docBufferUpto];
                    this.freq = this.freqBuffer[this.docBufferUpto];
                    this.posPendingCount += this.freq;
                    ++this.docBufferUpto;
                    ++this.docUpto;
                    if (this.accum >= n2) break block9;
                } while (this.docUpto != this.docFreq);
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.position = 0;
            this.doc = this.accum;
            return this.doc;
        }

        private void skipPositions() throws IOException {
            int n2 = this.posPendingCount - this.freq;
            int n3 = 128 - this.posBufferUpto;
            if (n2 < n3) {
                this.posBufferUpto += n2;
            } else {
                n2 -= n3;
                while (n2 >= 128) {
                    assert (this.posIn.getFilePointer() != this.lastPosBlockFP);
                    Lucene50PostingsReader.this.forUtil.skipBlock(this.posIn);
                    n2 -= 128;
                }
                this.refillPositions();
                this.posBufferUpto = n2;
            }
            this.position = 0;
        }

        @Override
        public int nextPosition() throws IOException {
            assert (this.posPendingCount > 0);
            if (this.posPendingFP != -1L) {
                this.posIn.seek(this.posPendingFP);
                this.posPendingFP = -1L;
                this.posBufferUpto = 128;
            }
            if (this.posPendingCount > this.freq) {
                this.skipPositions();
                this.posPendingCount = this.freq;
            }
            if (this.posBufferUpto == 128) {
                this.refillPositions();
                this.posBufferUpto = 0;
            }
            this.position += this.posDeltaBuffer[this.posBufferUpto++];
            --this.posPendingCount;
            return this.position;
        }

        @Override
        public int startOffset() {
            return -1;
        }

        @Override
        public int endOffset() {
            return -1;
        }

        @Override
        public BytesRef getPayload() {
            return null;
        }

        @Override
        public long cost() {
            return this.docFreq;
        }
    }

    final class BlockDocsEnum
    extends PostingsEnum {
        private final byte[] encoded;
        private final int[] docDeltaBuffer = new int[ForUtil.MAX_DATA_SIZE];
        private final int[] freqBuffer = new int[ForUtil.MAX_DATA_SIZE];
        private int docBufferUpto;
        private Lucene50SkipReader skipper;
        private boolean skipped;
        final IndexInput startDocIn;
        IndexInput docIn;
        final boolean indexHasFreq;
        final boolean indexHasPos;
        final boolean indexHasOffsets;
        final boolean indexHasPayloads;
        private int docFreq;
        private long totalTermFreq;
        private int docUpto;
        private int doc;
        private int accum;
        private int freq;
        private long docTermStartFP;
        private long skipOffset;
        private int nextSkipDoc;
        private boolean needsFreq;
        private int singletonDocID;

        public BlockDocsEnum(FieldInfo fieldInfo) throws IOException {
            this.startDocIn = Lucene50PostingsReader.this.docIn;
            this.docIn = null;
            this.indexHasFreq = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
            this.indexHasPos = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
            this.indexHasOffsets = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
            this.indexHasPayloads = fieldInfo.hasPayloads();
            this.encoded = new byte[512];
        }

        public boolean canReuse(IndexInput indexInput, FieldInfo fieldInfo) {
            return indexInput == this.startDocIn && this.indexHasFreq == fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) >= 0 && this.indexHasPos == fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0 && this.indexHasPayloads == fieldInfo.hasPayloads();
        }

        public PostingsEnum reset(Lucene50PostingsFormat.IntBlockTermState intBlockTermState, int n2) throws IOException {
            this.docFreq = intBlockTermState.docFreq;
            this.totalTermFreq = this.indexHasFreq ? intBlockTermState.totalTermFreq : (long)this.docFreq;
            this.docTermStartFP = intBlockTermState.docStartFP;
            this.skipOffset = intBlockTermState.skipOffset;
            this.singletonDocID = intBlockTermState.singletonDocID;
            if (this.docFreq > 1) {
                if (this.docIn == null) {
                    this.docIn = this.startDocIn.clone();
                }
                this.docIn.seek(this.docTermStartFP);
            }
            this.doc = -1;
            this.needsFreq = PostingsEnum.featureRequested(n2, (short)8);
            if (!this.indexHasFreq || !this.needsFreq) {
                Arrays.fill(this.freqBuffer, 1);
            }
            this.accum = 0;
            this.docUpto = 0;
            this.nextSkipDoc = 127;
            this.docBufferUpto = 128;
            this.skipped = false;
            return this;
        }

        @Override
        public int freq() throws IOException {
            return this.freq;
        }

        @Override
        public int nextPosition() throws IOException {
            return -1;
        }

        @Override
        public int startOffset() throws IOException {
            return -1;
        }

        @Override
        public int endOffset() throws IOException {
            return -1;
        }

        @Override
        public BytesRef getPayload() throws IOException {
            return null;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        private void refillDocs() throws IOException {
            int n2 = this.docFreq - this.docUpto;
            assert (n2 > 0);
            if (n2 >= 128) {
                Lucene50PostingsReader.this.forUtil.readBlock(this.docIn, this.encoded, this.docDeltaBuffer);
                if (this.indexHasFreq) {
                    if (this.needsFreq) {
                        Lucene50PostingsReader.this.forUtil.readBlock(this.docIn, this.encoded, this.freqBuffer);
                    } else {
                        Lucene50PostingsReader.this.forUtil.skipBlock(this.docIn);
                    }
                }
            } else if (this.docFreq == 1) {
                this.docDeltaBuffer[0] = this.singletonDocID;
                this.freqBuffer[0] = (int)this.totalTermFreq;
            } else {
                Lucene50PostingsReader.readVIntBlock(this.docIn, this.docDeltaBuffer, this.freqBuffer, n2, this.indexHasFreq);
            }
            this.docBufferUpto = 0;
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.docUpto == this.docFreq) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            if (this.docBufferUpto == 128) {
                this.refillDocs();
            }
            this.accum += this.docDeltaBuffer[this.docBufferUpto];
            ++this.docUpto;
            this.doc = this.accum;
            this.freq = this.freqBuffer[this.docBufferUpto];
            ++this.docBufferUpto;
            return this.doc;
        }

        @Override
        public int advance(int n2) throws IOException {
            block9: {
                if (this.docFreq > 128 && n2 > this.nextSkipDoc) {
                    int n3;
                    if (this.skipper == null) {
                        this.skipper = new Lucene50SkipReader(this.docIn.clone(), 10, this.indexHasPos, this.indexHasOffsets, this.indexHasPayloads);
                    }
                    if (!this.skipped) {
                        assert (this.skipOffset != -1L);
                        this.skipper.init(this.docTermStartFP + this.skipOffset, this.docTermStartFP, 0L, 0L, this.docFreq);
                        this.skipped = true;
                    }
                    if ((n3 = this.skipper.skipTo(n2) + 1) > this.docUpto) {
                        assert (n3 % 128 == 0) : "got " + n3;
                        this.docUpto = n3;
                        this.docBufferUpto = 128;
                        this.accum = this.skipper.getDoc();
                        this.docIn.seek(this.skipper.getDocPointer());
                    }
                    this.nextSkipDoc = this.skipper.getNextSkipDoc();
                }
                if (this.docUpto == this.docFreq) {
                    this.doc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                if (this.docBufferUpto == 128) {
                    this.refillDocs();
                }
                do {
                    this.accum += this.docDeltaBuffer[this.docBufferUpto];
                    ++this.docUpto;
                    if (this.accum >= n2) break block9;
                    ++this.docBufferUpto;
                } while (this.docUpto != this.docFreq);
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.freq = this.freqBuffer[this.docBufferUpto];
            ++this.docBufferUpto;
            this.doc = this.accum;
            return this.doc;
        }

        @Override
        public long cost() {
            return this.docFreq;
        }
    }
}

