/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.codecs.MultiLevelSkipListReader;
import org.apache.lucene.store.IndexInput;

final class Lucene50SkipReader
extends MultiLevelSkipListReader {
    private long[] docPointer;
    private long[] posPointer;
    private long[] payPointer;
    private int[] posBufferUpto;
    private int[] payloadByteUpto;
    private long lastPosPointer;
    private long lastPayPointer;
    private int lastPayloadByteUpto;
    private long lastDocPointer;
    private int lastPosBufferUpto;

    public Lucene50SkipReader(IndexInput indexInput, int n2, boolean bl, boolean bl2, boolean bl3) {
        super(indexInput, n2, 128, 8);
        this.docPointer = new long[n2];
        if (bl) {
            this.posPointer = new long[n2];
            this.posBufferUpto = new int[n2];
            this.payloadByteUpto = (int[])(bl3 ? new int[n2] : null);
            this.payPointer = (long[])(bl2 || bl3 ? new long[n2] : null);
        } else {
            this.posPointer = null;
        }
    }

    protected int trim(int n2) {
        return n2 % 128 == 0 ? n2 - 1 : n2;
    }

    public void init(long l2, long l3, long l4, long l5, int n2) throws IOException {
        super.init(l2, this.trim(n2));
        this.lastDocPointer = l3;
        this.lastPosPointer = l4;
        this.lastPayPointer = l5;
        Arrays.fill(this.docPointer, l3);
        if (this.posPointer != null) {
            Arrays.fill(this.posPointer, l4);
            if (this.payPointer != null) {
                Arrays.fill(this.payPointer, l5);
            }
        } else assert (l4 == 0L);
    }

    public long getDocPointer() {
        return this.lastDocPointer;
    }

    public long getPosPointer() {
        return this.lastPosPointer;
    }

    public int getPosBufferUpto() {
        return this.lastPosBufferUpto;
    }

    public long getPayPointer() {
        return this.lastPayPointer;
    }

    public int getPayloadByteUpto() {
        return this.lastPayloadByteUpto;
    }

    public int getNextSkipDoc() {
        return this.skipDoc[0];
    }

    @Override
    protected void seekChild(int n2) throws IOException {
        super.seekChild(n2);
        this.docPointer[n2] = this.lastDocPointer;
        if (this.posPointer != null) {
            this.posPointer[n2] = this.lastPosPointer;
            this.posBufferUpto[n2] = this.lastPosBufferUpto;
            if (this.payloadByteUpto != null) {
                this.payloadByteUpto[n2] = this.lastPayloadByteUpto;
            }
            if (this.payPointer != null) {
                this.payPointer[n2] = this.lastPayPointer;
            }
        }
    }

    @Override
    protected void setLastSkipData(int n2) {
        super.setLastSkipData(n2);
        this.lastDocPointer = this.docPointer[n2];
        if (this.posPointer != null) {
            this.lastPosPointer = this.posPointer[n2];
            this.lastPosBufferUpto = this.posBufferUpto[n2];
            if (this.payPointer != null) {
                this.lastPayPointer = this.payPointer[n2];
            }
            if (this.payloadByteUpto != null) {
                this.lastPayloadByteUpto = this.payloadByteUpto[n2];
            }
        }
    }

    @Override
    protected int readSkipData(int n2, IndexInput indexInput) throws IOException {
        int n3 = indexInput.readVInt();
        int n4 = n2;
        this.docPointer[n4] = this.docPointer[n4] + indexInput.readVLong();
        if (this.posPointer != null) {
            int n5 = n2;
            this.posPointer[n5] = this.posPointer[n5] + indexInput.readVLong();
            this.posBufferUpto[n2] = indexInput.readVInt();
            if (this.payloadByteUpto != null) {
                this.payloadByteUpto[n2] = indexInput.readVInt();
            }
            if (this.payPointer != null) {
                int n6 = n2;
                this.payPointer[n6] = this.payPointer[n6] + indexInput.readVLong();
            }
        }
        return n3;
    }
}

