/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.codecs.MultiLevelSkipListWriter;
import org.apache.lucene.store.IndexOutput;

final class Lucene50SkipWriter
extends MultiLevelSkipListWriter {
    private int[] lastSkipDoc;
    private long[] lastSkipDocPointer;
    private long[] lastSkipPosPointer;
    private long[] lastSkipPayPointer;
    private int[] lastPayloadByteUpto;
    private final IndexOutput docOut;
    private final IndexOutput posOut;
    private final IndexOutput payOut;
    private int curDoc;
    private long curDocPointer;
    private long curPosPointer;
    private long curPayPointer;
    private int curPosBufferUpto;
    private int curPayloadByteUpto;
    private boolean fieldHasPositions;
    private boolean fieldHasOffsets;
    private boolean fieldHasPayloads;
    private boolean initialized;
    long lastDocFP;
    long lastPosFP;
    long lastPayFP;

    public Lucene50SkipWriter(int n2, int n3, int n4, IndexOutput indexOutput, IndexOutput indexOutput2, IndexOutput indexOutput3) {
        super(n3, 8, n2, n4);
        this.docOut = indexOutput;
        this.posOut = indexOutput2;
        this.payOut = indexOutput3;
        this.lastSkipDoc = new int[n2];
        this.lastSkipDocPointer = new long[n2];
        if (indexOutput2 != null) {
            this.lastSkipPosPointer = new long[n2];
            if (indexOutput3 != null) {
                this.lastSkipPayPointer = new long[n2];
            }
            this.lastPayloadByteUpto = new int[n2];
        }
    }

    public void setField(boolean bl, boolean bl2, boolean bl3) {
        this.fieldHasPositions = bl;
        this.fieldHasOffsets = bl2;
        this.fieldHasPayloads = bl3;
    }

    @Override
    public void resetSkip() {
        this.lastDocFP = this.docOut.getFilePointer();
        if (this.fieldHasPositions) {
            this.lastPosFP = this.posOut.getFilePointer();
            if (this.fieldHasOffsets || this.fieldHasPayloads) {
                this.lastPayFP = this.payOut.getFilePointer();
            }
        }
        this.initialized = false;
    }

    public void initSkip() {
        if (!this.initialized) {
            super.resetSkip();
            Arrays.fill(this.lastSkipDoc, 0);
            Arrays.fill(this.lastSkipDocPointer, this.lastDocFP);
            if (this.fieldHasPositions) {
                Arrays.fill(this.lastSkipPosPointer, this.lastPosFP);
                if (this.fieldHasPayloads) {
                    Arrays.fill(this.lastPayloadByteUpto, 0);
                }
                if (this.fieldHasOffsets || this.fieldHasPayloads) {
                    Arrays.fill(this.lastSkipPayPointer, this.lastPayFP);
                }
            }
            this.initialized = true;
        }
    }

    public void bufferSkip(int n2, int n3, long l2, long l3, int n4, int n5) throws IOException {
        this.initSkip();
        this.curDoc = n2;
        this.curDocPointer = this.docOut.getFilePointer();
        this.curPosPointer = l2;
        this.curPayPointer = l3;
        this.curPosBufferUpto = n4;
        this.curPayloadByteUpto = n5;
        this.bufferSkip(n3);
    }

    @Override
    protected void writeSkipData(int n2, IndexOutput indexOutput) throws IOException {
        int n3 = this.curDoc - this.lastSkipDoc[n2];
        indexOutput.writeVInt(n3);
        this.lastSkipDoc[n2] = this.curDoc;
        indexOutput.writeVLong(this.curDocPointer - this.lastSkipDocPointer[n2]);
        this.lastSkipDocPointer[n2] = this.curDocPointer;
        if (this.fieldHasPositions) {
            indexOutput.writeVLong(this.curPosPointer - this.lastSkipPosPointer[n2]);
            this.lastSkipPosPointer[n2] = this.curPosPointer;
            indexOutput.writeVInt(this.curPosBufferUpto);
            if (this.fieldHasPayloads) {
                indexOutput.writeVInt(this.curPayloadByteUpto);
            }
            if (this.fieldHasOffsets || this.fieldHasPayloads) {
                indexOutput.writeVLong(this.curPayPointer - this.lastSkipPayPointer[n2]);
                this.lastSkipPayPointer[n2] = this.curPayPointer;
            }
        }
    }
}

