/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.portmobile.charset.StandardCharsets;

public class DocumentStoredFieldVisitor
extends StoredFieldVisitor {
    private final Document doc = new Document();
    private final Set<String> fieldsToAdd = null;

    @Override
    public void binaryField(FieldInfo fieldInfo, byte[] byArray) throws IOException {
        this.doc.add(new StoredField(fieldInfo.name, byArray));
    }

    @Override
    public void stringField(FieldInfo fieldInfo, byte[] byArray) throws IOException {
        FieldType fieldType = new FieldType(TextField.TYPE_STORED);
        fieldType.setStoreTermVectors(fieldInfo.hasVectors());
        fieldType.setOmitNorms(fieldInfo.omitsNorms());
        fieldType.setIndexOptions(fieldInfo.getIndexOptions());
        this.doc.add(new Field(fieldInfo.name, new String(byArray, StandardCharsets.UTF_8), fieldType));
    }

    @Override
    public void intField(FieldInfo fieldInfo, int n2) {
        this.doc.add(new StoredField(fieldInfo.name, n2));
    }

    @Override
    public void longField(FieldInfo fieldInfo, long l2) {
        this.doc.add(new StoredField(fieldInfo.name, l2));
    }

    @Override
    public void floatField(FieldInfo fieldInfo, float f2) {
        this.doc.add(new StoredField(fieldInfo.name, f2));
    }

    @Override
    public void doubleField(FieldInfo fieldInfo, double d2) {
        this.doc.add(new StoredField(fieldInfo.name, d2));
    }

    @Override
    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
        return this.fieldsToAdd == null || this.fieldsToAdd.contains(fieldInfo.name) ? StoredFieldVisitor.Status.YES : StoredFieldVisitor.Status.NO;
    }

    public Document getDocument() {
        return this.doc;
    }
}

