/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.k;

public class FieldType
implements k {
    private boolean stored;
    private boolean tokenized = true;
    private boolean storeTermVectors;
    private boolean storeTermVectorOffsets;
    private boolean storeTermVectorPositions;
    private boolean storeTermVectorPayloads;
    private boolean omitNorms;
    private IndexOptions indexOptions = IndexOptions.NONE;
    private NumericType numericType;
    private boolean frozen;
    private int numericPrecisionStep = 16;
    private DocValuesType docValuesType = DocValuesType.NONE;

    public FieldType(FieldType fieldType) {
        this.stored = fieldType.stored();
        this.tokenized = fieldType.tokenized();
        this.storeTermVectors = fieldType.storeTermVectors();
        this.storeTermVectorOffsets = fieldType.storeTermVectorOffsets();
        this.storeTermVectorPositions = fieldType.storeTermVectorPositions();
        this.storeTermVectorPayloads = fieldType.storeTermVectorPayloads();
        this.omitNorms = fieldType.omitNorms();
        this.indexOptions = fieldType.indexOptions();
        this.numericType = fieldType.numericType();
        this.numericPrecisionStep = fieldType.numericPrecisionStep();
        this.docValuesType = fieldType.docValuesType();
    }

    public FieldType() {
    }

    protected void checkIfFrozen() {
        if (this.frozen) {
            throw new IllegalStateException("this FieldType is already frozen and cannot be changed");
        }
    }

    public void freeze() {
        this.frozen = true;
    }

    @Override
    public boolean stored() {
        return this.stored;
    }

    public void setStored(boolean bl) {
        this.checkIfFrozen();
        this.stored = bl;
    }

    @Override
    public boolean tokenized() {
        return this.tokenized;
    }

    public void setTokenized(boolean bl) {
        this.checkIfFrozen();
        this.tokenized = bl;
    }

    @Override
    public boolean storeTermVectors() {
        return this.storeTermVectors;
    }

    public void setStoreTermVectors(boolean bl) {
        this.checkIfFrozen();
        this.storeTermVectors = bl;
    }

    @Override
    public boolean storeTermVectorOffsets() {
        return this.storeTermVectorOffsets;
    }

    @Override
    public boolean storeTermVectorPositions() {
        return this.storeTermVectorPositions;
    }

    @Override
    public boolean storeTermVectorPayloads() {
        return this.storeTermVectorPayloads;
    }

    @Override
    public boolean omitNorms() {
        return this.omitNorms;
    }

    public void setOmitNorms(boolean bl) {
        this.checkIfFrozen();
        this.omitNorms = bl;
    }

    @Override
    public IndexOptions indexOptions() {
        return this.indexOptions;
    }

    public void setIndexOptions(IndexOptions indexOptions) {
        this.checkIfFrozen();
        if (indexOptions == null) {
            throw new NullPointerException("IndexOptions cannot be null");
        }
        this.indexOptions = indexOptions;
    }

    public void setNumericType(NumericType numericType) {
        this.checkIfFrozen();
        this.numericType = numericType;
    }

    public NumericType numericType() {
        return this.numericType;
    }

    public int numericPrecisionStep() {
        return this.numericPrecisionStep;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.stored()) {
            stringBuilder.append("stored");
        }
        if (this.indexOptions != IndexOptions.NONE) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("indexed");
            if (this.tokenized()) {
                stringBuilder.append(",tokenized");
            }
            if (this.storeTermVectors()) {
                stringBuilder.append(",termVector");
            }
            if (this.storeTermVectorOffsets()) {
                stringBuilder.append(",termVectorOffsets");
            }
            if (this.storeTermVectorPositions()) {
                stringBuilder.append(",termVectorPosition");
            }
            if (this.storeTermVectorPayloads()) {
                stringBuilder.append(",termVectorPayloads");
            }
            if (this.omitNorms()) {
                stringBuilder.append(",omitNorms");
            }
            if (this.indexOptions != IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
                stringBuilder.append(",indexOptions=");
                stringBuilder.append((Object)this.indexOptions);
            }
            if (this.numericType != null) {
                stringBuilder.append(",numericType=");
                stringBuilder.append((Object)this.numericType);
                stringBuilder.append(",numericPrecisionStep=");
                stringBuilder.append(this.numericPrecisionStep);
            }
        }
        if (this.docValuesType != DocValuesType.NONE) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("docValuesType=");
            stringBuilder.append((Object)this.docValuesType);
        }
        return stringBuilder.toString();
    }

    @Override
    public DocValuesType docValuesType() {
        return this.docValuesType;
    }

    public void setDocValuesType(DocValuesType docValuesType) {
        this.checkIfFrozen();
        if (docValuesType == null) {
            throw new NullPointerException("DocValuesType cannot be null");
        }
        this.docValuesType = docValuesType;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.docValuesType == null ? 0 : this.docValuesType.hashCode());
        n3 = 31 * n3 + this.indexOptions.hashCode();
        n3 = 31 * n3 + this.numericPrecisionStep;
        n3 = 31 * n3 + (this.numericType == null ? 0 : this.numericType.hashCode());
        n3 = 31 * n3 + (this.omitNorms ? 1231 : 1237);
        n3 = 31 * n3 + (this.storeTermVectorOffsets ? 1231 : 1237);
        n3 = 31 * n3 + (this.storeTermVectorPayloads ? 1231 : 1237);
        n3 = 31 * n3 + (this.storeTermVectorPositions ? 1231 : 1237);
        n3 = 31 * n3 + (this.storeTermVectors ? 1231 : 1237);
        n3 = 31 * n3 + (this.stored ? 1231 : 1237);
        n3 = 31 * n3 + (this.tokenized ? 1231 : 1237);
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FieldType fieldType = (FieldType)object;
        if (this.docValuesType != fieldType.docValuesType) {
            return false;
        }
        if (this.indexOptions != fieldType.indexOptions) {
            return false;
        }
        if (this.numericPrecisionStep != fieldType.numericPrecisionStep) {
            return false;
        }
        if (this.numericType != fieldType.numericType) {
            return false;
        }
        if (this.omitNorms != fieldType.omitNorms) {
            return false;
        }
        if (this.storeTermVectorOffsets != fieldType.storeTermVectorOffsets) {
            return false;
        }
        if (this.storeTermVectorPayloads != fieldType.storeTermVectorPayloads) {
            return false;
        }
        if (this.storeTermVectorPositions != fieldType.storeTermVectorPositions) {
            return false;
        }
        if (this.storeTermVectors != fieldType.storeTermVectors) {
            return false;
        }
        if (this.stored != fieldType.stored) {
            return false;
        }
        return this.tokenized == fieldType.tokenized;
    }

    public static enum NumericType {
        INT,
        LONG,
        FLOAT,
        DOUBLE;

    }
}

