/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.o;

public abstract class BaseCompositeReader<R extends IndexReader>
extends CompositeReader {
    private final R[] subReaders;
    private final int[] starts;
    private final int maxDoc;
    private final int numDocs;
    private final List<R> subReadersList;

    protected BaseCompositeReader(R[] RArray) throws IOException {
        this.subReaders = RArray;
        this.subReadersList = Collections.unmodifiableList(Arrays.asList(RArray));
        this.starts = new int[RArray.length + 1];
        long l2 = 0L;
        long l3 = 0L;
        for (int i2 = 0; i2 < RArray.length; ++i2) {
            this.starts[i2] = (int)l2;
            R r2 = RArray[i2];
            l2 += (long)((IndexReader)r2).maxDoc();
            l3 += (long)((IndexReader)r2).numDocs();
            ((IndexReader)r2).registerParentReader(this);
        }
        if (l2 > (long)IndexWriter.getActualMaxDocs()) {
            if (this instanceof DirectoryReader) {
                throw new CorruptIndexException("Too many documents: an index cannot exceed " + IndexWriter.getActualMaxDocs() + " but readers have total maxDoc=" + l2, Arrays.toString(RArray));
            }
            throw new IllegalArgumentException("Too many documents: composite IndexReaders cannot exceed " + IndexWriter.getActualMaxDocs() + " but readers have total maxDoc=" + l2);
        }
        this.starts[RArray.length] = this.maxDoc = (int)l2;
        this.numDocs = (int)l3;
    }

    @Override
    public final int numDocs() {
        return this.numDocs;
    }

    @Override
    public final int maxDoc() {
        return this.maxDoc;
    }

    @Override
    public final void document(int n2, StoredFieldVisitor storedFieldVisitor) throws IOException {
        this.ensureOpen();
        int n3 = this.readerIndex(n2);
        ((IndexReader)this.subReaders[n3]).document(n2 - this.starts[n3], storedFieldVisitor);
    }

    @Override
    public final int docFreq(Term term) throws IOException {
        this.ensureOpen();
        int n2 = 0;
        for (int i2 = 0; i2 < this.subReaders.length; ++i2) {
            n2 += ((IndexReader)this.subReaders[i2]).docFreq(term);
        }
        return n2;
    }

    protected final int readerIndex(int n2) {
        if (n2 < 0 || n2 >= this.maxDoc) {
            throw new IllegalArgumentException("docID must be >= 0 and < maxDoc=" + this.maxDoc + " (got docID=" + n2 + ")");
        }
        return o.a(n2, this.starts);
    }

    protected final List<? extends R> getSequentialSubReaders() {
        return this.subReadersList;
    }
}

