/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.CoalescedUpdates;
import org.apache.lucene.index.DocValuesFieldUpdates;
import org.apache.lucene.index.DocValuesUpdate;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FrozenBufferedUpdates;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.ReadersAndUpdates;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.e;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.PriorityQueue;

class BufferedUpdatesStream
implements org.apache.lucene.util.a {
    private final List<FrozenBufferedUpdates> updates = new ArrayList<FrozenBufferedUpdates>();
    private long nextGen = 1L;
    private BytesRef lastDeleteTerm;
    private final InfoStream infoStream;
    private final AtomicLong bytesUsed = new AtomicLong();
    private final AtomicInteger numTerms = new AtomicInteger();
    private static final Comparator<SegmentCommitInfo> sortSegInfoByDelGen = new Comparator<SegmentCommitInfo>(){

        public int a(SegmentCommitInfo segmentCommitInfo, SegmentCommitInfo segmentCommitInfo2) {
            return Long.compare(segmentCommitInfo.getBufferedDeletesGen(), segmentCommitInfo2.getBufferedDeletesGen());
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((SegmentCommitInfo)object, (SegmentCommitInfo)object2);
        }
    };

    public BufferedUpdatesStream(InfoStream infoStream) {
        this.infoStream = infoStream;
    }

    public synchronized long push(FrozenBufferedUpdates frozenBufferedUpdates) {
        frozenBufferedUpdates.setDelGen(this.nextGen++);
        assert (frozenBufferedUpdates.any());
        assert (this.checkDeleteStats());
        assert (frozenBufferedUpdates.delGen() < this.nextGen);
        assert (this.updates.isEmpty() || this.updates.get(this.updates.size() - 1).delGen() < frozenBufferedUpdates.delGen()) : "Delete packets must be in order";
        this.updates.add(frozenBufferedUpdates);
        this.numTerms.addAndGet(frozenBufferedUpdates.numTermDeletes);
        this.bytesUsed.addAndGet(frozenBufferedUpdates.bytesUsed);
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", "push deletes " + frozenBufferedUpdates + " segmentPrivate?=" + frozenBufferedUpdates.isSegmentPrivate + " delGen=" + frozenBufferedUpdates.delGen() + " packetCount=" + this.updates.size() + " totBytesUsed=" + this.bytesUsed.get());
        }
        assert (this.checkDeleteStats());
        return frozenBufferedUpdates.delGen();
    }

    public synchronized void clear() {
        this.updates.clear();
        this.nextGen = 1L;
        this.numTerms.set(0);
        this.bytesUsed.set(0L);
    }

    public boolean any() {
        return this.bytesUsed.get() != 0L;
    }

    public int numTerms() {
        return this.numTerms.get();
    }

    @Override
    public long ramBytesUsed() {
        return this.bytesUsed.get();
    }

    @Override
    public Collection<org.apache.lucene.util.a> getChildResources() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public synchronized ApplyDeletesResult applyDeletesAndUpdates(IndexWriter.ReaderPool var1_1, List<SegmentCommitInfo> var2_2) throws IOException {
        block29: {
            block30: {
                var3_3 = System.currentTimeMillis();
                var5_4 = this.nextGen++;
                if (var2_2.size() == 0) {
                    return new ApplyDeletesResult(false, var5_4, null);
                }
                var7_5 = null;
                var8_6 = 0L;
                var10_7 = 0L;
                var12_8 = false;
                var13_9 = null;
                if (this.infoStream.isEnabled("BD")) {
                    this.infoStream.message("BD", String.format(Locale.ROOT, "applyDeletes: open segment readers took %d msec", new Object[]{System.currentTimeMillis() - var3_3}));
                }
                if (!BufferedUpdatesStream.$assertionsDisabled && !this.checkDeleteStats()) {
                    throw new AssertionError();
                }
                if (this.any()) break block29;
                if (this.infoStream.isEnabled("BD")) {
                    this.infoStream.message("BD", "applyDeletes: no segments; skipping");
                }
                var14_10 = new ApplyDeletesResult(false, var5_4, null);
                if (var7_5 == null) break block30;
                var13_9 = this.closeSegmentStates(var1_1, var7_5, var12_8, var5_4);
            }
            return var14_10;
        }
        try {
            if (this.infoStream.isEnabled("BD")) {
                this.infoStream.message("BD", "applyDeletes: infos=" + var2_2 + " packetCount=" + this.updates.size());
            }
            var2_2 = this.sortByDelGen(var2_2);
            var14_11 = null;
            var15_12 = var2_2.size() - 1;
            var16_13 = this.updates.size() - 1;
            while (var15_12 >= 0) {
                var17_14 = var16_13 >= 0 ? this.updates.get(var16_13) : null;
                var18_15 = var2_2.get(var15_12);
                var19_16 = var18_15.getBufferedDeletesGen();
                if (var17_14 != null && var19_16 < var17_14.delGen()) {
                    if (!var17_14.isSegmentPrivate && var17_14.any()) {
                        if (var14_11 == null) {
                            var14_11 = new CoalescedUpdates();
                        }
                        var14_11.update(var17_14);
                    }
                    --var16_13;
                    continue;
                }
                if (var17_14 != null && var19_16 == var17_14.delGen()) {
                    if (!BufferedUpdatesStream.$assertionsDisabled && !var17_14.isSegmentPrivate) {
                        throw new AssertionError((Object)("Packet and Segments deletegen can only match on a segment private del packet gen=" + var19_16));
                    }
                    if (var7_5 == null) {
                        var7_5 = this.openSegmentStates(var1_1, var2_2);
                    }
                    var21_17 = var7_5[var15_12];
                    if (!BufferedUpdatesStream.$assertionsDisabled && !var1_1.infoIsLive(var18_15)) {
                        throw new AssertionError();
                    }
                    var22_18 = 0;
                    var23_19 = new DocValuesFieldUpdates.Container();
                    if (var14_11 != null) {
                        var22_18 = (int)((long)var22_18 + BufferedUpdatesStream.applyQueryDeletes(var14_11.queriesIterable(), var21_17));
                        this.applyDocValuesUpdates(var14_11.numericDVUpdates, var21_17, var23_19);
                        this.applyDocValuesUpdates(var14_11.binaryDVUpdates, var21_17, var23_19);
                    }
                    var22_18 = (int)((long)var22_18 + BufferedUpdatesStream.applyQueryDeletes(var17_14.queriesIterable(), var21_17));
                    this.applyDocValuesUpdates(Arrays.asList(var17_14.numericDVUpdates), var21_17, var23_19);
                    this.applyDocValuesUpdates(Arrays.asList(var17_14.binaryDVUpdates), var21_17, var23_19);
                    if (var23_19.any()) {
                        var21_17.rld.writeFieldUpdates(var18_15.info.dir, var23_19);
                    }
                    var8_6 += (long)var22_18;
                    --var16_13;
                    --var15_12;
                    continue;
                }
                if (var14_11 != null) {
                    if (var7_5 == null) {
                        var7_5 = this.openSegmentStates(var1_1, var2_2);
                    }
                    var21_17 = var7_5[var15_12];
                    if (!BufferedUpdatesStream.$assertionsDisabled && !var1_1.infoIsLive(var18_15)) {
                        throw new AssertionError();
                    }
                    var22_18 = 0;
                    var22_18 = (int)((long)var22_18 + BufferedUpdatesStream.applyQueryDeletes(var14_11.queriesIterable(), var21_17));
                    var23_19 = new DocValuesFieldUpdates.Container();
                    this.applyDocValuesUpdates(var14_11.numericDVUpdates, var21_17, var23_19);
                    this.applyDocValuesUpdates(var14_11.binaryDVUpdates, var21_17, var23_19);
                    if (var23_19.any()) {
                        var21_17.rld.writeFieldUpdates(var18_15.info.dir, var23_19);
                    }
                    var8_6 += (long)var22_18;
                }
                --var15_12;
            }
            if (var14_11 != null && var14_11.totalTermCount != 0L) {
                if (var7_5 == null) {
                    var7_5 = this.openSegmentStates(var1_1, var2_2);
                }
                var10_7 += this.applyTermDeletes(var14_11, var7_5);
            }
            if (!BufferedUpdatesStream.$assertionsDisabled && !this.checkDeleteStats()) {
                throw new AssertionError();
            }
            var12_8 = true;
            ** if (var7_5 == null) goto lbl-1000
        }
        catch (Throwable var24_20) {
            if (var7_5 != null) {
                var13_9 = this.closeSegmentStates(var1_1, var7_5, var12_8, var5_4);
            }
            throw var24_20;
        }
lbl-1000:
        // 1 sources

        {
            var13_9 = this.closeSegmentStates(var1_1, var7_5, var12_8, var5_4);
        }
lbl-1000:
        // 2 sources

        {
        }
        if (var13_9 == null) {
            var13_9 = new ApplyDeletesResult(false, var5_4, null);
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", String.format(Locale.ROOT, "applyDeletes took %d msec for %d segments, %d newly deleted docs (query deletes), %d visited terms, allDeleted=%s", new Object[]{System.currentTimeMillis() - var3_3, var2_2.size(), var8_6, var10_7, var13_9.allDeleted}));
        }
        return var13_9;
    }

    private List<SegmentCommitInfo> sortByDelGen(List<SegmentCommitInfo> list) {
        list = new ArrayList<SegmentCommitInfo>(list);
        Collections.sort(list, sortSegInfoByDelGen);
        return list;
    }

    synchronized long getNextGen() {
        return this.nextGen++;
    }

    public synchronized void prune(SegmentInfos segmentInfos) {
        assert (this.checkDeleteStats());
        long l2 = Long.MAX_VALUE;
        for (SegmentCommitInfo segmentCommitInfo : segmentInfos) {
            l2 = Math.min(segmentCommitInfo.getBufferedDeletesGen(), l2);
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", "prune sis=" + segmentInfos + " minGen=" + l2 + " packetCount=" + this.updates.size());
        }
        int n2 = this.updates.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.updates.get(i2).delGen() < l2) continue;
            this.prune(i2);
            assert (this.checkDeleteStats());
            return;
        }
        this.prune(n2);
        assert (!this.any());
        assert (this.checkDeleteStats());
    }

    private synchronized void prune(int n2) {
        if (n2 > 0) {
            if (this.infoStream.isEnabled("BD")) {
                this.infoStream.message("BD", "pruneDeletes: prune " + n2 + " packets; " + (this.updates.size() - n2) + " packets remain");
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                FrozenBufferedUpdates frozenBufferedUpdates = this.updates.get(i2);
                this.numTerms.addAndGet(-frozenBufferedUpdates.numTermDeletes);
                assert (this.numTerms.get() >= 0);
                this.bytesUsed.addAndGet(-frozenBufferedUpdates.bytesUsed);
                assert (this.bytesUsed.get() >= 0L);
            }
            this.updates.subList(0, n2).clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentState[] openSegmentStates(IndexWriter.ReaderPool readerPool, List<SegmentCommitInfo> list) throws IOException {
        int n2;
        int n3 = list.size();
        SegmentState[] segmentStateArray = new SegmentState[n3];
        boolean bl = false;
        try {
            for (n2 = 0; n2 < n3; ++n2) {
                segmentStateArray[n2] = new SegmentState(readerPool, list.get(n2));
            }
            bl = true;
        }
        finally {
            if (!bl) {
                for (n2 = 0; n2 < n3; ++n2) {
                    if (segmentStateArray[n2] == null) continue;
                    try {
                        segmentStateArray[n2].finish(readerPool);
                        continue;
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        return segmentStateArray;
    }

    private ApplyDeletesResult closeSegmentStates(IndexWriter.ReaderPool readerPool, SegmentState[] segmentStateArray, boolean bl, long l2) throws IOException {
        int n2 = segmentStateArray.length;
        Throwable throwable = null;
        ArrayList<SegmentCommitInfo> arrayList = null;
        long l3 = 0L;
        for (int i2 = 0; i2 < n2; ++i2) {
            SegmentState segmentState = segmentStateArray[i2];
            if (bl) {
                l3 += (long)(segmentState.rld.getPendingDeleteCount() - segmentState.startDelCount);
                segmentState.reader.getSegmentInfo().setBufferedDeletesGen(l2);
                int n3 = segmentState.rld.info.getDelCount() + segmentState.rld.getPendingDeleteCount();
                assert (n3 <= segmentState.rld.info.info.maxDoc());
                if (n3 == segmentState.rld.info.info.maxDoc()) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<SegmentCommitInfo>();
                    }
                    arrayList.add(segmentState.reader.getSegmentInfo());
                }
            }
            try {
                segmentStateArray[i2].finish(readerPool);
                continue;
            }
            catch (Throwable throwable2) {
                if (throwable == null) continue;
                throwable = throwable2;
            }
        }
        if (bl) {
            IOUtils.reThrow(throwable);
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", "applyDeletes: " + l3 + " new deleted documents");
        }
        return new ApplyDeletesResult(l3 > 0L, l2, arrayList);
    }

    private synchronized long applyTermDeletes(CoalescedUpdates coalescedUpdates, SegmentState[] segmentStateArray) throws IOException {
        BytesRef bytesRef;
        long l2 = System.nanoTime();
        int n2 = segmentStateArray.length;
        long l3 = 0L;
        long l4 = 0L;
        e e2 = coalescedUpdates.termIterator();
        String string = null;
        a a2 = null;
        block0: while ((bytesRef = e2.next()) != null) {
            Object object;
            long l5;
            if (e2.field() != string) {
                string = e2.field();
                a2 = new a(n2);
                l5 = 0L;
                for (int i2 = 0; i2 < n2; ++i2) {
                    SegmentState segmentState = segmentStateArray[i2];
                    object = segmentState.reader.fields().terms(string);
                    if (object == null) continue;
                    l5 += ((Terms)object).size();
                    segmentState.termsEnum = ((Terms)object).iterator();
                    segmentState.term = segmentState.termsEnum.next();
                    if (segmentState.term == null) continue;
                    a2.add(segmentState);
                }
                assert (this.checkDeleteTerm(null));
            }
            assert (this.checkDeleteTerm(bytesRef));
            ++l3;
            l5 = e2.delGen();
            while (a2.size() != 0) {
                SegmentState segmentState = (SegmentState)a2.top();
                ++l4;
                int n3 = bytesRef.compareTo(segmentState.term);
                if (n3 < 0) continue block0;
                if (n3 != 0 && (object = segmentState.termsEnum.seekCeil(bytesRef)) != TermsEnum.SeekStatus.FOUND) {
                    if (object == TermsEnum.SeekStatus.NOT_FOUND) {
                        segmentState.term = segmentState.termsEnum.term();
                        a2.updateTop();
                        continue;
                    }
                    a2.pop();
                    continue;
                }
                assert (segmentState.delGen != l5);
                if (segmentState.delGen < l5) {
                    int n4;
                    object = segmentState.rld.getLiveDocs();
                    segmentState.postingsEnum = segmentState.termsEnum.postings(segmentState.postingsEnum, 0);
                    assert (segmentState.postingsEnum != null);
                    while ((n4 = segmentState.postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                        if (object != null && !object.get(n4)) continue;
                        if (!segmentState.any) {
                            segmentState.rld.initWritableLiveDocs();
                            segmentState.any = true;
                        }
                        segmentState.rld.delete(n4);
                    }
                }
                segmentState.term = segmentState.termsEnum.next();
                if (segmentState.term == null) {
                    a2.pop();
                    continue;
                }
                a2.updateTop();
            }
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", String.format(Locale.ROOT, "applyTermDeletes took %.1f msec for %d segments and %d packets; %d del terms visited; %d seg terms visited", (double)(System.nanoTime() - l2) / 1000000.0, n2, coalescedUpdates.terms.size(), l3, l4));
        }
        return l3;
    }

    private synchronized void applyDocValuesUpdates(Iterable<? extends DocValuesUpdate> iterable, SegmentState segmentState, DocValuesFieldUpdates.Container container) throws IOException {
        Fields fields = segmentState.reader.fields();
        String string = null;
        TermsEnum termsEnum = null;
        PostingsEnum postingsEnum = null;
        for (DocValuesUpdate docValuesUpdate : iterable) {
            int n2;
            Object object;
            Term term = docValuesUpdate.term;
            int n3 = docValuesUpdate.docIDUpto;
            if (!term.field().equals(string)) {
                string = term.field();
                object = fields.terms(string);
                termsEnum = object != null ? ((Terms)object).iterator() : null;
            }
            if (termsEnum == null || !termsEnum.seekExact(term.bytes())) continue;
            object = segmentState.rld.getLiveDocs();
            postingsEnum = termsEnum.postings(postingsEnum, 0);
            DocValuesFieldUpdates docValuesFieldUpdates = container.getUpdates(docValuesUpdate.field, docValuesUpdate.type);
            if (docValuesFieldUpdates == null) {
                docValuesFieldUpdates = container.newUpdates(docValuesUpdate.field, docValuesUpdate.type, segmentState.reader.maxDoc());
            }
            while ((n2 = postingsEnum.nextDoc()) != Integer.MAX_VALUE && n2 < n3) {
                if (object != null && !object.get(n2)) continue;
                docValuesFieldUpdates.add(n2, docValuesUpdate.value);
            }
        }
    }

    private static long applyQueryDeletes(Iterable<QueryAndLimit> iterable, SegmentState segmentState) throws IOException {
        long l2 = 0L;
        LeafReaderContext leafReaderContext = segmentState.reader.getContext();
        for (QueryAndLimit queryAndLimit : iterable) {
            int n2;
            Query query = queryAndLimit.query;
            int n3 = queryAndLimit.limit;
            IndexSearcher indexSearcher = new IndexSearcher(leafReaderContext.reader());
            indexSearcher.setQueryCache(null);
            Weight weight = indexSearcher.createNormalizedWeight(query, false);
            Scorer scorer = weight.scorer(leafReaderContext);
            if (scorer == null) continue;
            Bits bits = leafReaderContext.reader().getLiveDocs();
            while ((n2 = scorer.nextDoc()) < n3) {
                if (bits != null && !bits.get(n2)) continue;
                if (!segmentState.any) {
                    segmentState.rld.initWritableLiveDocs();
                    segmentState.any = true;
                }
                if (!segmentState.rld.delete(n2)) continue;
                ++l2;
            }
        }
        return l2;
    }

    private boolean checkDeleteTerm(BytesRef bytesRef) {
        if (bytesRef != null) assert (this.lastDeleteTerm == null || bytesRef.compareTo(this.lastDeleteTerm) >= 0) : "lastTerm=" + this.lastDeleteTerm + " vs term=" + bytesRef;
        this.lastDeleteTerm = bytesRef == null ? null : BytesRef.deepCopyOf(bytesRef);
        return true;
    }

    private boolean checkDeleteStats() {
        int n2 = 0;
        long l2 = 0L;
        for (FrozenBufferedUpdates frozenBufferedUpdates : this.updates) {
            n2 += frozenBufferedUpdates.numTermDeletes;
            l2 += (long)frozenBufferedUpdates.bytesUsed;
        }
        assert (n2 == this.numTerms.get()) : "numTerms2=" + n2 + " vs " + this.numTerms.get();
        assert (l2 == this.bytesUsed.get()) : "bytesUsed2=" + l2 + " vs " + this.bytesUsed;
        return true;
    }

    public static class QueryAndLimit {
        public final Query query;
        public final int limit;

        public QueryAndLimit(Query query, int n2) {
            this.query = query;
            this.limit = n2;
        }
    }

    static class a
    extends PriorityQueue<SegmentState> {
        public a(int n2) {
            super(n2);
        }

        protected boolean a(SegmentState segmentState, SegmentState segmentState2) {
            return segmentState.term.compareTo(segmentState2.term) < 0;
        }

        @Override
        protected /* synthetic */ boolean lessThan(Object object, Object object2) {
            return this.a((SegmentState)object, (SegmentState)object2);
        }
    }

    static class SegmentState {
        final long delGen;
        final ReadersAndUpdates rld;
        final SegmentReader reader;
        final int startDelCount;
        TermsEnum termsEnum;
        PostingsEnum postingsEnum;
        BytesRef term;
        boolean any;

        public SegmentState(IndexWriter.ReaderPool readerPool, SegmentCommitInfo segmentCommitInfo) throws IOException {
            this.rld = readerPool.get(segmentCommitInfo, true);
            this.startDelCount = this.rld.getPendingDeleteCount();
            this.reader = this.rld.getReader(IOContext.READ);
            this.delGen = segmentCommitInfo.getBufferedDeletesGen();
        }

        public void finish(IndexWriter.ReaderPool readerPool) throws IOException {
            try {
                this.rld.release(this.reader);
            }
            finally {
                readerPool.release(this.rld);
            }
        }
    }

    public static class ApplyDeletesResult {
        public final boolean anyDeletes;
        public final long gen;
        public final List<SegmentCommitInfo> allDeleted;

        ApplyDeletesResult(boolean bl, long l2, List<SegmentCommitInfo> list) {
            this.anyDeletes = bl;
            this.gen = l2;
            this.allDeleted = list;
        }
    }
}

