/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.BufferedUpdates;
import org.apache.lucene.index.BufferedUpdatesStream;
import org.apache.lucene.index.DocValuesUpdate;
import org.apache.lucene.index.FrozenBufferedUpdates;
import org.apache.lucene.index.MergedPrefixCodedTermsIterator;
import org.apache.lucene.index.PrefixCodedTerms;
import org.apache.lucene.index.e;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;

class CoalescedUpdates {
    final Map<Query, Integer> queries = new HashMap<Query, Integer>();
    final List<PrefixCodedTerms> terms = new ArrayList<PrefixCodedTerms>();
    final List<DocValuesUpdate.a> numericDVUpdates = new ArrayList<DocValuesUpdate.a>();
    final List<DocValuesUpdate.BinaryDocValuesUpdate> binaryDVUpdates = new ArrayList<DocValuesUpdate.BinaryDocValuesUpdate>();
    long totalTermCount;

    CoalescedUpdates() {
    }

    public String toString() {
        return "CoalescedUpdates(termSets=" + this.terms.size() + ",totalTermCount=" + this.totalTermCount + ",queries=" + this.queries.size() + ",numericDVUpdates=" + this.numericDVUpdates.size() + ",binaryDVUpdates=" + this.binaryDVUpdates.size() + ")";
    }

    void update(FrozenBufferedUpdates frozenBufferedUpdates) {
        DocValuesUpdate docValuesUpdate;
        this.totalTermCount += frozenBufferedUpdates.terms.size();
        this.terms.add(frozenBufferedUpdates.terms);
        for (int i2 = 0; i2 < frozenBufferedUpdates.queries.length; ++i2) {
            Query query = frozenBufferedUpdates.queries[i2];
            this.queries.put(query, BufferedUpdates.MAX_INT);
        }
        for (DocValuesUpdate.a docValuesUpdate2 : frozenBufferedUpdates.numericDVUpdates) {
            docValuesUpdate = new DocValuesUpdate.a(docValuesUpdate2.term, docValuesUpdate2.field, (Long)docValuesUpdate2.value);
            docValuesUpdate.docIDUpto = Integer.MAX_VALUE;
            this.numericDVUpdates.add((DocValuesUpdate.a)docValuesUpdate);
        }
        for (DocValuesUpdate docValuesUpdate2 : frozenBufferedUpdates.binaryDVUpdates) {
            docValuesUpdate = new DocValuesUpdate.BinaryDocValuesUpdate(((DocValuesUpdate.BinaryDocValuesUpdate)docValuesUpdate2).term, ((DocValuesUpdate.BinaryDocValuesUpdate)docValuesUpdate2).field, (BytesRef)((DocValuesUpdate.BinaryDocValuesUpdate)docValuesUpdate2).value);
            ((DocValuesUpdate.BinaryDocValuesUpdate)docValuesUpdate).docIDUpto = Integer.MAX_VALUE;
            this.binaryDVUpdates.add((DocValuesUpdate.BinaryDocValuesUpdate)docValuesUpdate);
        }
    }

    public e termIterator() {
        if (this.terms.size() == 1) {
            return this.terms.get(0).iterator();
        }
        return new MergedPrefixCodedTermsIterator(this.terms);
    }

    public Iterable<BufferedUpdatesStream.QueryAndLimit> queriesIterable() {
        return new Iterable<BufferedUpdatesStream.QueryAndLimit>(){

            @Override
            public Iterator<BufferedUpdatesStream.QueryAndLimit> iterator() {
                return new Iterator<BufferedUpdatesStream.QueryAndLimit>(){
                    private final Iterator<Map.Entry<Query, Integer>> iter;
                    {
                        this.iter = CoalescedUpdates.this.queries.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public BufferedUpdatesStream.QueryAndLimit next() {
                        Map.Entry<Query, Integer> entry = this.iter.next();
                        return new BufferedUpdatesStream.QueryAndLimit(entry.getKey(), entry.getValue());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

