/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.store.a;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.k;

public class ConcurrentMergeScheduler
extends MergeScheduler {
    protected final List<MergeThread> mergeThreads = new ArrayList<MergeThread>();
    private int maxThreadCount = -1;
    private int maxMergeCount = -1;
    protected int mergeThreadCount;
    protected double targetMBPerSec = 20.0;
    private boolean doAutoIOThrottle = true;
    private double forceMergeMBPerSec = Double.POSITIVE_INFINITY;
    private boolean suppressExceptions;

    public synchronized void setDefaultMaxMergesAndThreads(boolean bl) {
        if (bl) {
            this.maxThreadCount = 1;
            this.maxMergeCount = 6;
        } else {
            int n2 = Runtime.getRuntime().availableProcessors();
            try {
                String string = System.getProperty("lucene.cms.override_core_count");
                if (string != null) {
                    n2 = Integer.parseInt(string);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.maxThreadCount = Math.max(1, Math.min(4, n2 / 2));
            this.maxMergeCount = this.maxThreadCount + 5;
        }
    }

    synchronized void removeMergeThread() {
        Thread thread = Thread.currentThread();
        for (int i2 = 0; i2 < this.mergeThreads.size(); ++i2) {
            if (this.mergeThreads.get(i2) != thread) continue;
            this.mergeThreads.remove(i2);
            return;
        }
        assert (false) : "merge thread " + thread + " was not found";
    }

    protected synchronized void updateMergeThreads() {
        StringBuilder stringBuilder;
        ArrayList<MergeThread> arrayList = new ArrayList<MergeThread>();
        int n2 = 0;
        while (n2 < this.mergeThreads.size()) {
            MergeThread mergeThread = this.mergeThreads.get(n2);
            if (!mergeThread.isAlive()) {
                this.mergeThreads.remove(n2);
                continue;
            }
            arrayList.add(mergeThread);
            ++n2;
        }
        CollectionUtil.b(arrayList);
        int n3 = arrayList.size();
        int n4 = 0;
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            MergeThread mergeThread = (MergeThread)arrayList.get(n2);
            if (!((double)mergeThread.merge.estimatedMergeBytes > 5.24288E7)) continue;
            n4 = 1 + n2;
            break;
        }
        long l2 = System.nanoTime();
        if (this.verbose()) {
            stringBuilder = new StringBuilder();
            stringBuilder.append(String.format(Locale.ROOT, "updateMergeThreads ioThrottle=%s targetMBPerSec=%.1f MB/sec", this.doAutoIOThrottle, this.targetMBPerSec));
        } else {
            stringBuilder = null;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            boolean bl;
            MergeThread mergeThread = (MergeThread)arrayList.get(n2);
            MergePolicy.OneMerge oneMerge = mergeThread.merge;
            boolean bl2 = bl = n2 < n4 - this.maxThreadCount;
            double d2 = bl ? 0.0 : (oneMerge.maxNumSegments != -1 ? this.forceMergeMBPerSec : (!this.doAutoIOThrottle ? Double.POSITIVE_INFINITY : ((double)oneMerge.estimatedMergeBytes < 5.24288E7 ? Double.POSITIVE_INFINITY : this.targetMBPerSec)));
            double d3 = oneMerge.rateLimiter.getMBPerSec();
            if (this.verbose()) {
                long l3 = oneMerge.mergeStartNS;
                if (l3 == -1L) {
                    l3 = l2;
                }
                stringBuilder.append('\n');
                stringBuilder.append(String.format(Locale.ROOT, "merge thread %s estSize=%.1f MB (written=%.1f MB) runTime=%.1fs (stopped=%.1fs, paused=%.1fs) rate=%s\n", mergeThread.getName(), ConcurrentMergeScheduler.bytesToMB(oneMerge.estimatedMergeBytes), ConcurrentMergeScheduler.bytesToMB(oneMerge.rateLimiter.totalBytesWritten), ConcurrentMergeScheduler.nsToSec(l2 - l3), ConcurrentMergeScheduler.nsToSec(oneMerge.rateLimiter.getTotalStoppedNS()), ConcurrentMergeScheduler.nsToSec(oneMerge.rateLimiter.getTotalPausedNS()), ConcurrentMergeScheduler.rateToString(oneMerge.rateLimiter.getMBPerSec())));
                if (d2 != d3) {
                    if (d2 == 0.0) {
                        stringBuilder.append("  now stop");
                    } else if (d3 == 0.0) {
                        if (d2 == Double.POSITIVE_INFINITY) {
                            stringBuilder.append("  now resume");
                        } else {
                            stringBuilder.append(String.format(Locale.ROOT, "  now resume to %.1f MB/sec", d2));
                        }
                    } else {
                        stringBuilder.append(String.format(Locale.ROOT, "  now change from %.1f MB/sec to %.1f MB/sec", d3, d2));
                    }
                } else if (d3 == 0.0) {
                    stringBuilder.append("  leave stopped");
                } else {
                    stringBuilder.append(String.format(Locale.ROOT, "  leave running at %.1f MB/sec", d3));
                }
            }
            oneMerge.rateLimiter.setMBPerSec(d2);
        }
        if (this.verbose()) {
            this.message(stringBuilder.toString());
        }
    }

    private synchronized void initDynamicDefaults(IndexWriter indexWriter) throws IOException {
        if (this.maxThreadCount == -1) {
            boolean bl = IOUtils.spins(indexWriter.getDirectory());
            try {
                String string = System.getProperty("lucene.cms.override_spins");
                if (string != null) {
                    bl = Boolean.parseBoolean(string);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.setDefaultMaxMergesAndThreads(bl);
            if (this.verbose()) {
                this.message("initDynamicDefaults spins=" + bl + " maxThreadCount=" + this.maxThreadCount + " maxMergeCount=" + this.maxMergeCount);
            }
        }
    }

    private static String rateToString(double d2) {
        if (d2 == 0.0) {
            return "stopped";
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return "unlimited";
        }
        return String.format(Locale.ROOT, "%.1f MB/sec", d2);
    }

    @Override
    public void close() {
        this.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        block12: {
            boolean bl = false;
            block8: while (true) {
                while (true) {
                    Thread thread = null;
                    ConcurrentMergeScheduler concurrentMergeScheduler = this;
                    synchronized (concurrentMergeScheduler) {
                        for (MergeThread mergeThread : this.mergeThreads) {
                            if (!mergeThread.isAlive() || mergeThread == Thread.currentThread()) continue;
                            thread = mergeThread;
                            break;
                        }
                    }
                    if (thread == null) break block12;
                    try {
                        thread.join();
                        continue block8;
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (bl) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public synchronized int mergeThreadCount() {
        Thread thread = Thread.currentThread();
        int n2 = 0;
        for (MergeThread mergeThread : this.mergeThreads) {
            if (thread == mergeThread || !mergeThread.isAlive() || mergeThread.merge.rateLimiter.getAbort()) continue;
            ++n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void merge(IndexWriter indexWriter, MergeTrigger mergeTrigger, boolean bl) throws IOException {
        assert (!Thread.holdsLock(indexWriter));
        this.initDynamicDefaults(indexWriter);
        if (mergeTrigger == MergeTrigger.CLOSING) {
            this.targetMBPerSec = 10240.0;
            this.updateMergeThreads();
        }
        if (this.verbose()) {
            this.message("now merge");
            this.message("  index: " + indexWriter.segString());
        }
        while (this.maybeStall(indexWriter)) {
            MergePolicy.OneMerge oneMerge = indexWriter.getNextMerge();
            if (oneMerge == null) {
                if (this.verbose()) {
                    this.message("  no more merges pending; now return");
                }
                return;
            }
            this.updateIOThrottle(oneMerge);
            boolean bl2 = false;
            try {
                if (this.verbose()) {
                    this.message("  consider merge " + indexWriter.segString(oneMerge.segments));
                }
                MergeThread mergeThread = this.getMergeThread(indexWriter, oneMerge);
                this.mergeThreads.add(mergeThread);
                if (this.verbose()) {
                    this.message("    launch new thread [" + mergeThread.getName() + "]");
                }
                mergeThread.start();
                this.updateMergeThreads();
                bl2 = true;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            finally {
                if (bl2) continue;
                try {
                    indexWriter.mergeFinish(oneMerge);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    protected synchronized boolean maybeStall(IndexWriter indexWriter) {
        long l2 = 0L;
        while (indexWriter.hasPendingMerges() && this.mergeThreadCount() >= this.maxMergeCount) {
            if (this.mergeThreads.contains(Thread.currentThread())) {
                return false;
            }
            if (this.verbose() && l2 == 0L) {
                this.message("    too many merges; stalling...");
            }
            l2 = System.currentTimeMillis();
            this.doStall();
        }
        if (this.verbose() && l2 != 0L) {
            this.message("  stalled for " + (System.currentTimeMillis() - l2) + " msec");
        }
        return true;
    }

    protected synchronized void doStall() {
        try {
            this.wait(250L);
        }
        catch (InterruptedException interruptedException) {
            throw new k(interruptedException);
        }
    }

    protected void doMerge(IndexWriter indexWriter, MergePolicy.OneMerge oneMerge) throws IOException {
        indexWriter.merge(oneMerge);
    }

    protected synchronized MergeThread getMergeThread(IndexWriter indexWriter, MergePolicy.OneMerge oneMerge) throws IOException {
        MergeThread mergeThread = new MergeThread(indexWriter, oneMerge);
        mergeThread.setDaemon(true);
        mergeThread.setName("Lucene Merge Thread #" + this.mergeThreadCount++);
        return mergeThread;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName() + ": ");
        stringBuilder.append("maxThreadCount=").append(this.maxThreadCount).append(", ");
        stringBuilder.append("maxMergeCount=").append(this.maxMergeCount).append(", ");
        stringBuilder.append("ioThrottle=").append(this.doAutoIOThrottle);
        return stringBuilder.toString();
    }

    private boolean isBacklog(long l2, MergePolicy.OneMerge oneMerge) {
        double d2 = ConcurrentMergeScheduler.bytesToMB(oneMerge.estimatedMergeBytes);
        for (MergeThread mergeThread : this.mergeThreads) {
            double d3;
            double d4;
            long l3 = mergeThread.merge.mergeStartNS;
            if (!mergeThread.isAlive() || mergeThread.merge == oneMerge || l3 == -1L || !((double)mergeThread.merge.estimatedMergeBytes >= 5.24288E7) || !(ConcurrentMergeScheduler.nsToSec(l2 - l3) > 3.0) || !((d4 = (d3 = ConcurrentMergeScheduler.bytesToMB(mergeThread.merge.estimatedMergeBytes)) / d2) > 0.3) || !(d4 < 3.0)) continue;
            return true;
        }
        return false;
    }

    private synchronized void updateIOThrottle(MergePolicy.OneMerge oneMerge) throws IOException {
        if (!this.doAutoIOThrottle) {
            return;
        }
        double d2 = ConcurrentMergeScheduler.bytesToMB(oneMerge.estimatedMergeBytes);
        if (d2 < 50.0) {
            return;
        }
        long l2 = System.nanoTime();
        boolean bl = this.isBacklog(l2, oneMerge);
        boolean bl2 = false;
        if (!bl) {
            if (this.mergeThreads.size() > this.maxThreadCount) {
                bl2 = true;
            } else {
                for (MergeThread mergeThread : this.mergeThreads) {
                    if (!this.isBacklog(l2, mergeThread.merge)) continue;
                    bl2 = true;
                    break;
                }
            }
        }
        double d3 = this.targetMBPerSec;
        if (bl) {
            this.targetMBPerSec *= 1.2;
            if (this.targetMBPerSec > 10240.0) {
                this.targetMBPerSec = 10240.0;
            }
            if (this.verbose()) {
                if (d3 == this.targetMBPerSec) {
                    this.message(String.format(Locale.ROOT, "io throttle: new merge backlog; leave IO rate at ceiling %.1f MB/sec", this.targetMBPerSec));
                } else {
                    this.message(String.format(Locale.ROOT, "io throttle: new merge backlog; increase IO rate to %.1f MB/sec", this.targetMBPerSec));
                }
            }
        } else if (bl2) {
            if (this.verbose()) {
                this.message(String.format(Locale.ROOT, "io throttle: current merge backlog; leave IO rate at %.1f MB/sec", this.targetMBPerSec));
            }
        } else {
            this.targetMBPerSec /= 1.1;
            if (this.targetMBPerSec < 5.0) {
                this.targetMBPerSec = 5.0;
            }
            if (this.verbose()) {
                if (d3 == this.targetMBPerSec) {
                    this.message(String.format(Locale.ROOT, "io throttle: no merge backlog; leave IO rate at floor %.1f MB/sec", this.targetMBPerSec));
                } else {
                    this.message(String.format(Locale.ROOT, "io throttle: no merge backlog; decrease IO rate to %.1f MB/sec", this.targetMBPerSec));
                }
            }
        }
        double d4 = oneMerge.maxNumSegments != -1 ? this.forceMergeMBPerSec : this.targetMBPerSec;
        oneMerge.rateLimiter.setMBPerSec(d4);
        this.targetMBPerSecChanged();
    }

    protected void targetMBPerSecChanged() {
    }

    private static double nsToSec(long l2) {
        return (double)l2 / 1.0E9;
    }

    private static double bytesToMB(long l2) {
        return (double)l2 / 1024.0 / 1024.0;
    }

    protected class MergeThread
    extends Thread
    implements Comparable<MergeThread> {
        final IndexWriter writer;
        final MergePolicy.OneMerge merge;

        public MergeThread(IndexWriter indexWriter, MergePolicy.OneMerge oneMerge) {
            this.writer = indexWriter;
            this.merge = oneMerge;
        }

        @Override
        public int compareTo(MergeThread mergeThread) {
            return Long.compare(mergeThread.merge.estimatedMergeBytes, this.merge.estimatedMergeBytes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (ConcurrentMergeScheduler.this.verbose()) {
                    ConcurrentMergeScheduler.this.message("  merge thread: start");
                }
                ConcurrentMergeScheduler.this.doMerge(this.writer, this.merge);
                if (ConcurrentMergeScheduler.this.verbose()) {
                    ConcurrentMergeScheduler.this.message("  merge thread: done");
                }
                try {
                    ConcurrentMergeScheduler.this.merge(this.writer, MergeTrigger.MERGE_FINISHED, true);
                }
                catch (a a2) {
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            catch (Throwable throwable) {
                if (throwable instanceof MergePolicy.a || !ConcurrentMergeScheduler.this.suppressExceptions) {
                    // empty if block
                }
                throwable.printStackTrace();
            }
            finally {
                ConcurrentMergeScheduler concurrentMergeScheduler = ConcurrentMergeScheduler.this;
                synchronized (concurrentMergeScheduler) {
                    try {
                        ConcurrentMergeScheduler.this.removeMergeThread();
                        ConcurrentMergeScheduler.this.updateMergeThreads();
                        ConcurrentMergeScheduler.this.notifyAll();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
        }
    }
}

