/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.Map;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.portmobile.util.Objects;

public final class FieldInfo {
    public final String name;
    public final int number;
    private DocValuesType docValuesType = DocValuesType.NONE;
    private boolean storeTermVector;
    private boolean omitNorms;
    private IndexOptions indexOptions = IndexOptions.NONE;
    private boolean storePayloads;
    private final Map<String, String> attributes;
    private long dvGen;

    public FieldInfo(String string, int n2, boolean bl, boolean bl2, boolean bl3, IndexOptions indexOptions, DocValuesType docValuesType, long l2, Map<String, String> map) {
        this.name = Objects.requireNonNull(string);
        this.number = n2;
        this.docValuesType = Objects.requireNonNull(docValuesType, "DocValuesType cannot be null (field: \"" + string + "\")");
        this.indexOptions = Objects.requireNonNull(indexOptions, "IndexOptions cannot be null (field: \"" + string + "\")");
        if (indexOptions != IndexOptions.NONE) {
            this.storeTermVector = bl;
            this.storePayloads = bl3;
            this.omitNorms = bl2;
        } else {
            this.storeTermVector = false;
            this.storePayloads = false;
            this.omitNorms = false;
        }
        this.dvGen = l2;
        this.attributes = Objects.requireNonNull(map);
        assert (this.checkConsistency());
    }

    public boolean checkConsistency() {
        if (this.indexOptions != IndexOptions.NONE) {
            if (this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0 && this.storePayloads) {
                throw new IllegalStateException("indexed field '" + this.name + "' cannot have payloads without positions");
            }
        } else {
            if (this.storeTermVector) {
                throw new IllegalStateException("non-indexed field '" + this.name + "' cannot store term vectors");
            }
            if (this.storePayloads) {
                throw new IllegalStateException("non-indexed field '" + this.name + "' cannot store payloads");
            }
            if (this.omitNorms) {
                throw new IllegalStateException("non-indexed field '" + this.name + "' cannot omit norms");
            }
        }
        if (this.dvGen != -1L && this.docValuesType == DocValuesType.NONE) {
            throw new IllegalStateException("field '" + this.name + "' cannot have a docvalues update generation without having docvalues");
        }
        return true;
    }

    void update(boolean bl, boolean bl2, boolean bl3, IndexOptions indexOptions) {
        if (indexOptions == null) {
            throw new NullPointerException("IndexOptions cannot be null (field: \"" + this.name + "\")");
        }
        if (this.indexOptions != indexOptions) {
            if (this.indexOptions == IndexOptions.NONE) {
                this.indexOptions = indexOptions;
            } else if (indexOptions != IndexOptions.NONE) {
                IndexOptions indexOptions2 = this.indexOptions = this.indexOptions.compareTo(indexOptions) < 0 ? this.indexOptions : indexOptions;
            }
        }
        if (this.indexOptions != IndexOptions.NONE) {
            this.storeTermVector |= bl;
            this.storePayloads |= bl3;
            if (indexOptions != IndexOptions.NONE && this.omitNorms != bl2) {
                this.omitNorms = true;
            }
        }
        if (this.indexOptions == IndexOptions.NONE || this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
            this.storePayloads = false;
        }
        assert (this.checkConsistency());
    }

    void setDocValuesType(DocValuesType docValuesType) {
        if (docValuesType == null) {
            throw new NullPointerException("DocValuesType cannot be null (field: \"" + this.name + "\")");
        }
        if (this.docValuesType != DocValuesType.NONE && docValuesType != DocValuesType.NONE && this.docValuesType != docValuesType) {
            throw new IllegalArgumentException("cannot change DocValues type from " + (Object)((Object)this.docValuesType) + " to " + (Object)((Object)docValuesType) + " for field \"" + this.name + "\"");
        }
        this.docValuesType = docValuesType;
        assert (this.checkConsistency());
    }

    public IndexOptions getIndexOptions() {
        return this.indexOptions;
    }

    public void setIndexOptions(IndexOptions indexOptions) {
        if (this.indexOptions != indexOptions) {
            if (this.indexOptions == IndexOptions.NONE) {
                this.indexOptions = indexOptions;
            } else if (indexOptions != IndexOptions.NONE) {
                IndexOptions indexOptions2 = this.indexOptions = this.indexOptions.compareTo(indexOptions) < 0 ? this.indexOptions : indexOptions;
            }
        }
        if (this.indexOptions == IndexOptions.NONE || this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
            this.storePayloads = false;
        }
    }

    public DocValuesType getDocValuesType() {
        return this.docValuesType;
    }

    void setDocValuesGen(long l2) {
        this.dvGen = l2;
        assert (this.checkConsistency());
    }

    public long getDocValuesGen() {
        return this.dvGen;
    }

    void setStoreTermVectors() {
        this.storeTermVector = true;
        assert (this.checkConsistency());
    }

    void setStorePayloads() {
        if (this.indexOptions != IndexOptions.NONE && this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0) {
            this.storePayloads = true;
        }
        assert (this.checkConsistency());
    }

    public boolean omitsNorms() {
        return this.omitNorms;
    }

    public void setOmitsNorms() {
        if (this.indexOptions == IndexOptions.NONE) {
            throw new IllegalStateException("cannot omit norms: this field is not indexed");
        }
        this.omitNorms = true;
    }

    public boolean hasNorms() {
        return this.indexOptions != IndexOptions.NONE && !this.omitNorms;
    }

    public boolean hasPayloads() {
        return this.storePayloads;
    }

    public boolean hasVectors() {
        return this.storeTermVector;
    }

    public String getAttribute(String string) {
        return this.attributes.get(string);
    }

    public String putAttribute(String string, String string2) {
        return this.attributes.put(string, string2);
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }
}

