/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.util.AttributeSource;

public final class FieldInvertState {
    String name;
    int position;
    int length;
    int numOverlap;
    int offset;
    int maxTermFrequency;
    int uniqueTermCount;
    float boost;
    int lastStartOffset = 0;
    int lastPosition = 0;
    AttributeSource attributeSource;
    OffsetAttribute offsetAttribute;
    PositionIncrementAttribute posIncrAttribute;
    PayloadAttribute payloadAttribute;
    TermToBytesRefAttribute termAttribute;

    public FieldInvertState(String string) {
        this.name = string;
    }

    void reset() {
        this.position = -1;
        this.length = 0;
        this.numOverlap = 0;
        this.offset = 0;
        this.maxTermFrequency = 0;
        this.uniqueTermCount = 0;
        this.boost = 1.0f;
        this.lastStartOffset = 0;
        this.lastPosition = 0;
    }

    void setAttributeSource(AttributeSource attributeSource) {
        if (this.attributeSource != attributeSource) {
            this.attributeSource = attributeSource;
            this.termAttribute = attributeSource.getAttribute(TermToBytesRefAttribute.class);
            this.posIncrAttribute = attributeSource.addAttribute(PositionIncrementAttribute.class);
            this.offsetAttribute = attributeSource.addAttribute(OffsetAttribute.class);
            this.payloadAttribute = attributeSource.getAttribute(PayloadAttribute.class);
        }
    }

    public int getLength() {
        return this.length;
    }

    public int getNumOverlap() {
        return this.numOverlap;
    }

    public float getBoost() {
        return this.boost;
    }
}

