/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.codecs.d;
import org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FreqProxFields;
import org.apache.lucene.index.FreqProxTermsWriterPerField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.TermsHash;
import org.apache.lucene.index.TermsHashPerField;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.IOUtils;

final class FreqProxTermsWriter
extends TermsHash {
    public FreqProxTermsWriter(DocumentsWriterPerThread documentsWriterPerThread, TermsHash termsHash) {
        super(documentsWriterPerThread, true, termsHash);
    }

    private void applyDeletes(SegmentWriteState segmentWriteState, Fields fields) throws IOException {
        if (segmentWriteState.segUpdates != null && segmentWriteState.segUpdates.terms.size() > 0) {
            Map<Term, Integer> map = segmentWriteState.segUpdates.terms;
            ArrayList<Term> arrayList = new ArrayList<Term>(map.keySet());
            Collections.sort(arrayList);
            String string = null;
            TermsEnum termsEnum = null;
            PostingsEnum postingsEnum = null;
            for (Term term : arrayList) {
                int n2;
                if (!term.field().equals(string)) {
                    string = term.field();
                    Terms terms = fields.terms(string);
                    termsEnum = terms != null ? terms.iterator() : null;
                }
                if (termsEnum == null || !termsEnum.seekExact(term.bytes())) continue;
                postingsEnum = termsEnum.postings(postingsEnum, 0);
                int n3 = map.get(term);
                assert (n3 < Integer.MAX_VALUE);
                while ((n2 = postingsEnum.nextDoc()) < n3) {
                    if (segmentWriteState.liveDocs == null) {
                        segmentWriteState.liveDocs = segmentWriteState.segmentInfo.getCodec().liveDocsFormat().newLiveDocs(segmentWriteState.segmentInfo.maxDoc());
                    }
                    if (!segmentWriteState.liveDocs.get(n2)) continue;
                    ++segmentWriteState.delCountOnFlush;
                    segmentWriteState.liveDocs.clear(n2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(Map<String, TermsHashPerField> map, SegmentWriteState segmentWriteState) throws IOException {
        block7: {
            d d2;
            block6: {
                super.flush(map, segmentWriteState);
                ArrayList<FreqProxTermsWriterPerField> arrayList = new ArrayList<FreqProxTermsWriterPerField>();
                for (TermsHashPerField object2 : map.values()) {
                    FreqProxTermsWriterPerField bl = (FreqProxTermsWriterPerField)object2;
                    if (bl.bytesHash.size() <= 0) continue;
                    bl.sortPostings();
                    assert (bl.fieldInfo.getIndexOptions() != IndexOptions.NONE);
                    arrayList.add(bl);
                }
                CollectionUtil.a(arrayList);
                FreqProxFields freqProxFields = new FreqProxFields(arrayList);
                this.applyDeletes(segmentWriteState, freqProxFields);
                d2 = segmentWriteState.segmentInfo.getCodec().postingsFormat().fieldsConsumer(segmentWriteState);
                boolean bl = false;
                try {
                    d2.write(freqProxFields);
                    bl = true;
                    if (!bl) break block6;
                }
                catch (Throwable throwable) {
                    if (bl) {
                        IOUtils.close(d2);
                    } else {
                        IOUtils.closeWhileHandlingException(d2);
                    }
                    throw throwable;
                }
                IOUtils.close(d2);
                break block7;
            }
            IOUtils.closeWhileHandlingException(d2);
        }
    }

    @Override
    public TermsHashPerField addField(FieldInvertState fieldInvertState, FieldInfo fieldInfo) {
        return new FreqProxTermsWriterPerField(fieldInvertState, this, fieldInfo, this.nextTermsHash.addField(fieldInvertState, fieldInfo));
    }
}

