/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.MappingMultiPostingsEnum;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.MultiPostingsEnum;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.MultiTermsEnum;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;

public class MappedMultiFields
extends FilterLeafReader.FilterFields {
    final MergeState mergeState;

    public MappedMultiFields(MergeState mergeState, MultiFields multiFields) {
        super(multiFields);
        this.mergeState = mergeState;
    }

    @Override
    public Terms terms(String string) throws IOException {
        MultiTerms multiTerms = (MultiTerms)this.in.terms(string);
        if (multiTerms == null) {
            return null;
        }
        return new MappedMultiTerms(string, this.mergeState, multiTerms);
    }

    private static class MappedMultiTermsEnum
    extends FilterLeafReader.FilterTermsEnum {
        final MergeState mergeState;
        final String field;

        public MappedMultiTermsEnum(String string, MergeState mergeState, MultiTermsEnum multiTermsEnum) {
            super(multiTermsEnum);
            this.field = string;
            this.mergeState = mergeState;
        }

        @Override
        public int docFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long totalTermFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public PostingsEnum postings(PostingsEnum postingsEnum, int n2) throws IOException {
            PostingsEnum postingsEnum2;
            PostingsEnum postingsEnum3;
            if (postingsEnum instanceof MappingMultiPostingsEnum) {
                postingsEnum3 = (MappingMultiPostingsEnum)postingsEnum;
                postingsEnum2 = ((MappingMultiPostingsEnum)postingsEnum3).field.equals(this.field) ? postingsEnum3 : new MappingMultiPostingsEnum(this.field, this.mergeState);
            } else {
                postingsEnum2 = new MappingMultiPostingsEnum(this.field, this.mergeState);
            }
            postingsEnum3 = (MultiPostingsEnum)this.in.postings(postingsEnum2.multiDocsAndPositionsEnum, n2);
            postingsEnum2.reset((MultiPostingsEnum)postingsEnum3);
            return postingsEnum2;
        }
    }

    private static class MappedMultiTerms
    extends FilterLeafReader.FilterTerms {
        final MergeState mergeState;
        final String field;

        public MappedMultiTerms(String string, MergeState mergeState, MultiTerms multiTerms) {
            super(multiTerms);
            this.field = string;
            this.mergeState = mergeState;
        }

        @Override
        public TermsEnum iterator() throws IOException {
            return new MappedMultiTermsEnum(this.field, this.mergeState, (MultiTermsEnum)this.in.iterator());
        }

        @Override
        public long size() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getSumTotalTermFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getSumDocFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getDocCount() throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

