/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergeRateLimiter;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.store.MergeInfo;
import org.apache.lucene.store.c;
import org.apache.lucene.util.FixedBitSet;

public abstract class MergePolicy {
    protected double noCFSRatio = 1.0;
    protected long maxCFSSegmentSize = Long.MAX_VALUE;

    public MergePolicy() {
        this(1.0, Long.MAX_VALUE);
    }

    protected MergePolicy(double d2, long l2) {
        this.noCFSRatio = d2;
        this.maxCFSSegmentSize = l2;
    }

    public abstract MergeSpecification findMerges(MergeTrigger var1, SegmentInfos var2, IndexWriter var3) throws IOException;

    public abstract MergeSpecification findForcedMerges(SegmentInfos var1, int var2, Map<SegmentCommitInfo, Boolean> var3, IndexWriter var4) throws IOException;

    public boolean useCompoundFile(SegmentInfos segmentInfos, SegmentCommitInfo segmentCommitInfo, IndexWriter indexWriter) throws IOException {
        if (this.getNoCFSRatio() == 0.0) {
            return false;
        }
        long l2 = this.size(segmentCommitInfo, indexWriter);
        if (l2 > this.maxCFSSegmentSize) {
            return false;
        }
        if (this.getNoCFSRatio() >= 1.0) {
            return true;
        }
        long l3 = 0L;
        for (SegmentCommitInfo segmentCommitInfo2 : segmentInfos) {
            l3 += this.size(segmentCommitInfo2, indexWriter);
        }
        return (double)l2 <= this.getNoCFSRatio() * (double)l3;
    }

    protected long size(SegmentCommitInfo segmentCommitInfo, IndexWriter indexWriter) throws IOException {
        double d2;
        long l2 = segmentCommitInfo.sizeInBytes();
        int n2 = indexWriter.numDeletedDocs(segmentCommitInfo);
        double d3 = d2 = segmentCommitInfo.info.maxDoc() <= 0 ? 0.0 : (double)((float)n2 / (float)segmentCommitInfo.info.maxDoc());
        assert (d2 <= 1.0);
        return segmentCommitInfo.info.maxDoc() <= 0 ? l2 : (long)((double)l2 * (1.0 - d2));
    }

    protected final boolean isMerged(SegmentInfos segmentInfos, SegmentCommitInfo segmentCommitInfo, IndexWriter indexWriter) throws IOException {
        assert (indexWriter != null);
        boolean bl = indexWriter.numDeletedDocs(segmentCommitInfo) > 0;
        return !bl && segmentCommitInfo.info.dir == indexWriter.getDirectory() && this.useCompoundFile(segmentInfos, segmentCommitInfo, indexWriter) == segmentCommitInfo.info.getUseCompoundFile();
    }

    public final double getNoCFSRatio() {
        return this.noCFSRatio;
    }

    public final double getMaxCFSSegmentSizeMB() {
        return (double)(this.maxCFSSegmentSize / 1024L) / 1024.0;
    }

    public static class a
    extends IOException {
        public a() {
            super("merge is aborted");
        }

        public a(String string) {
            super(string);
        }
    }

    public static class MergeException
    extends RuntimeException {
        private c dir;

        public MergeException(String string, c c2) {
            super(string);
            this.dir = c2;
        }
    }

    public static class MergeSpecification {
        public final List<OneMerge> merges = new ArrayList<OneMerge>();

        public void add(OneMerge oneMerge) {
            this.merges.add(oneMerge);
        }
    }

    public static class OneMerge {
        SegmentCommitInfo info;
        boolean registerDone;
        long mergeGen;
        boolean isExternal;
        int maxNumSegments = -1;
        public volatile long estimatedMergeBytes;
        volatile long totalMergeBytes;
        List<SegmentReader> readers;
        public final List<SegmentCommitInfo> segments;
        public final MergeRateLimiter rateLimiter;
        volatile long mergeStartNS = -1L;
        public final int totalMaxDoc;
        Throwable error;

        public OneMerge(List<SegmentCommitInfo> list) {
            if (0 == list.size()) {
                throw new RuntimeException("segments must include at least one segment");
            }
            this.segments = new ArrayList<SegmentCommitInfo>(list);
            int n2 = 0;
            for (SegmentCommitInfo segmentCommitInfo : list) {
                n2 += segmentCommitInfo.info.maxDoc();
            }
            this.totalMaxDoc = n2;
            this.rateLimiter = new MergeRateLimiter(this);
        }

        public void mergeFinished() throws IOException {
        }

        public List<CodecReader> getMergeReaders() throws IOException {
            if (this.readers == null) {
                throw new IllegalStateException("IndexWriter has not initialized readers from the segment infos yet");
            }
            ArrayList<SegmentReader> arrayList = new ArrayList<SegmentReader>(this.readers.size());
            for (SegmentReader segmentReader : this.readers) {
                if (segmentReader.numDocs() <= 0) continue;
                arrayList.add(segmentReader);
            }
            return Collections.unmodifiableList(arrayList);
        }

        public void setMergeInfo(SegmentCommitInfo segmentCommitInfo) {
            this.info = segmentCommitInfo;
        }

        public DocMap getDocMap(MergeState mergeState) {
            return new DocMap(){

                @Override
                public int map(int n2) {
                    return n2;
                }
            };
        }

        synchronized void setException(Throwable throwable) {
            this.error = throwable;
        }

        synchronized Throwable getException() {
            return this.error;
        }

        public String segString() {
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = this.segments.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (i2 > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(this.segments.get(i2).toString());
            }
            if (this.info != null) {
                stringBuilder.append(" into ").append(this.info.info.name);
            }
            if (this.maxNumSegments != -1) {
                stringBuilder.append(" [maxNumSegments=" + this.maxNumSegments + "]");
            }
            if (this.rateLimiter.getAbort()) {
                stringBuilder.append(" [ABORTED]");
            }
            return stringBuilder.toString();
        }

        public MergeInfo getStoreMergeInfo() {
            return new MergeInfo(this.totalMaxDoc, this.estimatedMergeBytes, this.isExternal, this.maxNumSegments);
        }
    }

    public static abstract class DocMap {
        protected DocMap() {
        }

        public abstract int map(int var1);

        boolean isConsistent(int n2) {
            FixedBitSet fixedBitSet = new FixedBitSet(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = this.map(i2);
                if (n3 < 0 || n3 >= n2) {
                    assert (false) : "out of range: " + n3 + " not in [0-" + n2 + "[";
                    return false;
                }
                if (!fixedBitSet.get(n3)) continue;
                assert (false) : n3 + " is already taken (" + i2 + ")";
                return false;
            }
            return true;
        }
    }
}

