/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.store.i;
import org.apache.lucene.util.k;

public class MergeRateLimiter
extends i {
    volatile long totalBytesWritten;
    double mbPerSec;
    private long lastNS;
    private long minPauseCheckBytes;
    private boolean abort;
    long totalPausedNS;
    long totalStoppedNS;
    final MergePolicy.OneMerge merge;

    public MergeRateLimiter(MergePolicy.OneMerge oneMerge) {
        this.merge = oneMerge;
        this.setMBPerSec(Double.POSITIVE_INFINITY);
    }

    public synchronized void setMBPerSec(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("mbPerSec must be positive; got: " + d2);
        }
        this.mbPerSec = d2;
        this.minPauseCheckBytes = Math.min(0x100000L, (long)(0.025 * d2 * 1024.0 * 1024.0));
        assert (this.minPauseCheckBytes >= 0L);
        this.notify();
    }

    public synchronized double getMBPerSec() {
        return this.mbPerSec;
    }

    @Override
    public long pause(long l2) throws MergePolicy.a {
        long l3;
        this.totalBytesWritten += l2;
        long l4 = l3 = System.nanoTime();
        long l5 = 0L;
        while (true) {
            PauseResult pauseResult;
            if ((pauseResult = this.maybePause(l2, l4)) == PauseResult.NO) break;
            l4 = System.nanoTime();
            long l6 = l4 - l3;
            l3 = l4;
            if (pauseResult == PauseResult.STOPPED) {
                this.totalStoppedNS += l6;
            } else {
                assert (pauseResult == PauseResult.PAUSED);
                this.totalPausedNS += l6;
            }
            l5 += l6;
        }
        this.lastNS = l4;
        return l5;
    }

    public synchronized long getTotalStoppedNS() {
        return this.totalStoppedNS;
    }

    public synchronized long getTotalPausedNS() {
        return this.totalPausedNS;
    }

    private synchronized PauseResult maybePause(long l2, long l3) throws MergePolicy.a {
        this.checkAbort();
        double d2 = (double)l2 / 1024.0 / 1024.0 / this.mbPerSec;
        long l4 = this.lastNS + (long)(1.0E9 * d2);
        long l5 = l4 - l3;
        if (l5 <= 2000000L) {
            return PauseResult.NO;
        }
        if (l5 > 250000000L) {
            l5 = 250000000L;
        }
        int n2 = (int)(l5 / 1000000L);
        int n3 = (int)(l5 % 1000000L);
        double d3 = this.mbPerSec;
        try {
            this.wait(n2, n3);
        }
        catch (InterruptedException interruptedException) {
            throw new k(interruptedException);
        }
        if (d3 == 0.0) {
            return PauseResult.STOPPED;
        }
        return PauseResult.PAUSED;
    }

    public synchronized void checkAbort() throws MergePolicy.a {
        if (this.abort) {
            throw new MergePolicy.a("merge is aborted: " + this.merge.segString());
        }
    }

    public synchronized void setAbort() {
        this.abort = true;
        this.notify();
    }

    public synchronized boolean getAbort() {
        return this.abort;
    }

    @Override
    public long getMinPauseCheckBytes() {
        return this.minPauseCheckBytes;
    }

    private static enum PauseResult {
        NO,
        STOPPED,
        PAUSED;

    }
}

