/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.index.MultiTermsEnum;
import org.apache.lucene.index.ReaderSlice;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.a;
import org.apache.lucene.util.b;
import org.apache.lucene.util.e;
import org.apache.lucene.util.packed.PackedInts;
import org.apache.lucene.util.packed.PackedLongValues;

public class MultiDocValues {
    private MultiDocValues() {
    }

    public static class OrdinalMap
    implements a {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(OrdinalMap.class);
        final Object owner;
        final PackedLongValues globalOrdDeltas;
        final PackedLongValues firstSegments;
        final LongValues[] segmentToGlobalOrds;
        final SegmentMap segmentMap;
        final long ramBytesUsed;

        public static OrdinalMap build(Object object, TermsEnum[] termsEnumArray, long[] lArray, float f2) throws IOException {
            if (termsEnumArray.length != lArray.length) {
                throw new IllegalArgumentException("subs and weights must have the same length");
            }
            SegmentMap segmentMap = new SegmentMap(lArray);
            return new OrdinalMap(object, termsEnumArray, segmentMap, f2);
        }

        OrdinalMap(Object object, TermsEnum[] termsEnumArray, SegmentMap segmentMap, float f2) throws IOException {
            int n2;
            this.owner = object;
            this.segmentMap = segmentMap;
            PackedLongValues.Builder builder = PackedLongValues.monotonicBuilder(0.0f);
            PackedLongValues.Builder builder2 = PackedLongValues.packedBuilder(0.0f);
            PackedLongValues.Builder[] builderArray = new PackedLongValues.Builder[termsEnumArray.length];
            for (int i2 = 0; i2 < builderArray.length; ++i2) {
                builderArray[i2] = PackedLongValues.monotonicBuilder(f2);
            }
            long[] lArray = new long[termsEnumArray.length];
            long[] lArray2 = new long[termsEnumArray.length];
            ReaderSlice[] readerSliceArray = new ReaderSlice[termsEnumArray.length];
            MultiTermsEnum.TermsEnumIndex[] termsEnumIndexArray = new MultiTermsEnum.TermsEnumIndex[readerSliceArray.length];
            for (int i3 = 0; i3 < readerSliceArray.length; ++i3) {
                readerSliceArray[i3] = new ReaderSlice(0, 0, i3);
                termsEnumIndexArray[i3] = new MultiTermsEnum.TermsEnumIndex(termsEnumArray[segmentMap.newToOld(i3)], i3);
            }
            MultiTermsEnum multiTermsEnum = new MultiTermsEnum(readerSliceArray);
            multiTermsEnum.reset(termsEnumIndexArray);
            long l2 = 0L;
            while (multiTermsEnum.next() != null) {
                MultiTermsEnum.TermsEnumWithSlice[] termsEnumWithSliceArray = multiTermsEnum.getMatchArray();
                int n3 = Integer.MAX_VALUE;
                long l3 = Long.MAX_VALUE;
                for (n2 = 0; n2 < multiTermsEnum.getMatchCount(); ++n2) {
                    int n4 = termsEnumWithSliceArray[n2].index;
                    long l4 = termsEnumWithSliceArray[n2].terms.ord();
                    long l5 = l2 - l4;
                    if (n4 < n3) {
                        n3 = n4;
                        l3 = l5;
                    }
                    while (lArray2[n4] <= l4) {
                        int n5 = n4;
                        lArray[n5] = lArray[n5] | l5;
                        builderArray[n4].add(l5);
                        int n6 = n4;
                        lArray2[n6] = lArray2[n6] + 1L;
                    }
                }
                assert (n3 < lArray2.length);
                builder2.add(n3);
                builder.add(l3);
                ++l2;
            }
            this.firstSegments = builder2.build();
            this.globalOrdDeltas = builder.build();
            this.segmentToGlobalOrds = new LongValues[termsEnumArray.length];
            long l6 = BASE_RAM_BYTES_USED + this.globalOrdDeltas.ramBytesUsed() + this.firstSegments.ramBytesUsed() + RamUsageEstimator.shallowSizeOf(this.segmentToGlobalOrds) + segmentMap.ramBytesUsed();
            for (int i4 = 0; i4 < builderArray.length; ++i4) {
                final PackedLongValues packedLongValues = builderArray[i4].build();
                if (lArray[i4] == 0L) {
                    this.segmentToGlobalOrds[i4] = LongValues.IDENTITY;
                    continue;
                }
                n2 = lArray[i4] < 0L ? 64 : PackedInts.bitsRequired(lArray[i4]);
                long l7 = packedLongValues.ramBytesUsed() * 8L;
                long l8 = (long)n2 * packedLongValues.size();
                if (packedLongValues.size() <= Integer.MAX_VALUE && (float)l8 <= (float)l7 * (1.0f + f2)) {
                    int n7 = (int)packedLongValues.size();
                    final PackedInts.Mutable mutable = PackedInts.getMutable(n7, n2, f2);
                    PackedLongValues.Iterator iterator = packedLongValues.iterator();
                    for (int i5 = 0; i5 < n7; ++i5) {
                        mutable.set(i5, iterator.next());
                    }
                    assert (!iterator.hasNext());
                    this.segmentToGlobalOrds[i4] = new LongValues(){

                        @Override
                        public long get(long l2) {
                            return l2 + mutable.get((int)l2);
                        }
                    };
                    l6 += mutable.ramBytesUsed();
                } else {
                    this.segmentToGlobalOrds[i4] = new LongValues(){

                        @Override
                        public long get(long l2) {
                            return l2 + packedLongValues.get(l2);
                        }
                    };
                    l6 += packedLongValues.ramBytesUsed();
                }
                l6 += RamUsageEstimator.shallowSizeOf(this.segmentToGlobalOrds[i4]);
            }
            this.ramBytesUsed = l6;
        }

        public LongValues getGlobalOrds(int n2) {
            return this.segmentToGlobalOrds[this.segmentMap.oldToNew(n2)];
        }

        public long getFirstSegmentOrd(long l2) {
            return l2 - this.globalOrdDeltas.get(l2);
        }

        public int getFirstSegmentNumber(long l2) {
            return this.segmentMap.newToOld((int)this.firstSegments.get(l2));
        }

        public long getValueCount() {
            return this.globalOrdDeltas.size();
        }

        @Override
        public long ramBytesUsed() {
            return this.ramBytesUsed;
        }

        @Override
        public Collection<a> getChildResources() {
            ArrayList<a> arrayList = new ArrayList<a>();
            arrayList.add(b.a("global ord deltas", this.globalOrdDeltas));
            arrayList.add(b.a("first segments", this.firstSegments));
            arrayList.add(b.a("segment map", this.segmentMap));
            return arrayList;
        }

        private static class SegmentMap
        implements a {
            private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SegmentMap.class);
            private final int[] newToOld;
            private final int[] oldToNew;

            private static int[] map(final long[] lArray) {
                final int[] nArray = new int[lArray.length];
                for (int i2 = 0; i2 < lArray.length; ++i2) {
                    nArray[i2] = i2;
                }
                new e(){

                    @Override
                    protected void swap(int n2, int n3) {
                        int n4 = nArray[n2];
                        nArray[n2] = nArray[n3];
                        nArray[n3] = n4;
                    }

                    @Override
                    protected int compare(int n2, int n3) {
                        return Long.compare(lArray[nArray[n3]], lArray[nArray[n2]]);
                    }
                }.sort(0, lArray.length);
                return nArray;
            }

            private static int[] inverse(int[] nArray) {
                int[] nArray2 = new int[nArray.length];
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    nArray2[nArray[i2]] = i2;
                }
                return nArray2;
            }

            SegmentMap(long[] lArray) {
                this.newToOld = SegmentMap.map(lArray);
                this.oldToNew = SegmentMap.inverse(this.newToOld);
                assert (Arrays.equals(this.newToOld, SegmentMap.inverse(this.oldToNew)));
            }

            int newToOld(int n2) {
                return this.newToOld[n2];
            }

            int oldToNew(int n2) {
                return this.oldToNew[n2];
            }

            @Override
            public long ramBytesUsed() {
                return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.newToOld) + RamUsageEstimator.sizeOf(this.oldToNew);
            }

            @Override
            public Collection<a> getChildResources() {
                return Collections.emptyList();
            }
        }
    }
}

