/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.ReaderSlice;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.MergedIterator;

public final class MultiFields
extends Fields {
    private final Fields[] subs;
    private final ReaderSlice[] subSlices;
    private final Map<String, Terms> terms = new ConcurrentHashMap<String, Terms>();

    public static Fields getFields(IndexReader indexReader) throws IOException {
        List<LeafReaderContext> list = indexReader.leaves();
        switch (list.size()) {
            case 1: {
                return list.get(0).reader().fields();
            }
        }
        ArrayList<Fields> arrayList = new ArrayList<Fields>();
        ArrayList<ReaderSlice> arrayList2 = new ArrayList<ReaderSlice>();
        for (LeafReaderContext leafReaderContext : list) {
            LeafReader leafReader = leafReaderContext.reader();
            Fields fields = leafReader.fields();
            arrayList.add(fields);
            arrayList2.add(new ReaderSlice(leafReaderContext.docBase, leafReader.maxDoc(), arrayList.size() - 1));
        }
        if (arrayList.size() == 1) {
            return (Fields)arrayList.get(0);
        }
        return new MultiFields(arrayList.toArray(Fields.EMPTY_ARRAY), arrayList2.toArray(ReaderSlice.EMPTY_ARRAY));
    }

    public static Terms getTerms(IndexReader indexReader, String string) throws IOException {
        return MultiFields.getFields(indexReader).terms(string);
    }

    public MultiFields(Fields[] fieldsArray, ReaderSlice[] readerSliceArray) {
        this.subs = fieldsArray;
        this.subSlices = readerSliceArray;
    }

    @Override
    public Iterator<String> iterator() {
        Iterator[] iteratorArray = new Iterator[this.subs.length];
        for (int i2 = 0; i2 < this.subs.length; ++i2) {
            iteratorArray[i2] = this.subs[i2].iterator();
        }
        return new MergedIterator<String>(iteratorArray);
    }

    @Override
    public Terms terms(String string) throws IOException {
        Terms terms = this.terms.get(string);
        if (terms != null) {
            return terms;
        }
        ArrayList<Terms> arrayList = new ArrayList<Terms>();
        ArrayList<ReaderSlice> arrayList2 = new ArrayList<ReaderSlice>();
        for (int i2 = 0; i2 < this.subs.length; ++i2) {
            Terms terms2 = this.subs[i2].terms(string);
            if (terms2 == null) continue;
            arrayList.add(terms2);
            arrayList2.add(this.subSlices[i2]);
        }
        if (arrayList.size() == 0) {
            terms = null;
        } else {
            terms = new MultiTerms(arrayList.toArray(Terms.EMPTY_ARRAY), arrayList2.toArray(ReaderSlice.EMPTY_ARRAY));
            this.terms.put(string, terms);
        }
        return terms;
    }

    @Override
    public int size() {
        return -1;
    }
}

