/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.DocValuesFieldUpdates;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.util.e;
import org.apache.lucene.util.packed.PackedInts;
import org.apache.lucene.util.packed.PagedGrowableWriter;
import org.apache.lucene.util.packed.PagedMutable;

class NumericDocValuesFieldUpdates
extends DocValuesFieldUpdates {
    private final int bitsPerValue;
    private PagedMutable docs;
    private PagedGrowableWriter values;
    private int size;

    public NumericDocValuesFieldUpdates(String string, int n2) {
        super(string, DocValuesType.NUMERIC);
        this.bitsPerValue = PackedInts.bitsRequired(n2 - 1);
        this.docs = new PagedMutable(1L, 1024, this.bitsPerValue, 0.0f);
        this.values = new PagedGrowableWriter(1L, 1024, 1, 0.5f);
        this.size = 0;
    }

    @Override
    public void add(int n2, Object object) {
        if (this.size == Integer.MAX_VALUE) {
            throw new IllegalStateException("cannot support more than Integer.MAX_VALUE doc/value entries");
        }
        Long l2 = (Long)object;
        if (this.docs.size() == (long)this.size) {
            this.docs = (PagedMutable)this.docs.grow(this.size + 1);
            this.values = (PagedGrowableWriter)this.values.grow(this.size + 1);
        }
        this.docs.set(this.size, n2);
        this.values.set(this.size, l2);
        ++this.size;
    }

    @Override
    public Iterator iterator() {
        final PagedMutable pagedMutable = this.docs;
        final PagedGrowableWriter pagedGrowableWriter = this.values;
        new e(){

            @Override
            protected void swap(int n2, int n3) {
                long l2 = pagedMutable.get(n3);
                pagedMutable.set(n3, pagedMutable.get(n2));
                pagedMutable.set(n2, l2);
                long l3 = pagedGrowableWriter.get(n3);
                pagedGrowableWriter.set(n3, pagedGrowableWriter.get(n2));
                pagedGrowableWriter.set(n2, l3);
            }

            @Override
            protected int compare(int n2, int n3) {
                int n4;
                int n5 = (int)pagedMutable.get(n2);
                return n5 < (n4 = (int)pagedMutable.get(n3)) ? -1 : (n5 == n4 ? 0 : 1);
            }
        }.sort(0, this.size);
        return new Iterator(this.size, pagedGrowableWriter, pagedMutable);
    }

    @Override
    public void merge(DocValuesFieldUpdates docValuesFieldUpdates) {
        assert (docValuesFieldUpdates instanceof NumericDocValuesFieldUpdates);
        NumericDocValuesFieldUpdates numericDocValuesFieldUpdates = (NumericDocValuesFieldUpdates)docValuesFieldUpdates;
        if (this.size + numericDocValuesFieldUpdates.size > Integer.MAX_VALUE) {
            throw new IllegalStateException("cannot support more than Integer.MAX_VALUE doc/value entries; size=" + this.size + " other.size=" + numericDocValuesFieldUpdates.size);
        }
        this.docs = (PagedMutable)this.docs.grow(this.size + numericDocValuesFieldUpdates.size);
        this.values = (PagedGrowableWriter)this.values.grow(this.size + numericDocValuesFieldUpdates.size);
        for (int i2 = 0; i2 < numericDocValuesFieldUpdates.size; ++i2) {
            int n2 = (int)numericDocValuesFieldUpdates.docs.get(i2);
            this.docs.set(this.size, n2);
            this.values.set(this.size, numericDocValuesFieldUpdates.values.get(i2));
            ++this.size;
        }
    }

    public boolean any() {
        return this.size > 0;
    }

    public long ramBytesPerDoc() {
        long l2 = (long)Math.ceil((double)this.bitsPerValue / 8.0);
        int n2 = NumericDocValuesFieldUpdates.estimateCapacity(this.size);
        return l2 += (long)Math.ceil((double)this.values.ramBytesUsed() / (double)n2);
    }

    static final class Iterator
    extends DocValuesFieldUpdates.a {
        private final int size;
        private final PagedGrowableWriter values;
        private final PagedMutable docs;
        private long idx = 0L;
        private int doc = -1;
        private Long value = null;

        Iterator(int n2, PagedGrowableWriter pagedGrowableWriter, PagedMutable pagedMutable) {
            this.size = n2;
            this.values = pagedGrowableWriter;
            this.docs = pagedMutable;
        }

        @Override
        Long value() {
            return this.value;
        }

        @Override
        int nextDoc() {
            if (this.idx >= (long)this.size) {
                this.value = null;
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = (int)this.docs.get(this.idx);
            ++this.idx;
            while (this.idx < (long)this.size && this.docs.get(this.idx) == (long)this.doc) {
                ++this.idx;
            }
            this.value = this.values.get(this.idx - 1L);
            return this.doc;
        }

        @Override
        int doc() {
            return this.doc;
        }

        @Override
        void reset() {
            this.doc = -1;
            this.value = null;
            this.idx = 0L;
        }
    }
}

