/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.SegmentInfo;

public class SegmentCommitInfo {
    public final SegmentInfo info;
    private int delCount;
    private long delGen;
    private long nextWriteDelGen;
    private long fieldInfosGen;
    private long nextWriteFieldInfosGen;
    private long docValuesGen;
    private long nextWriteDocValuesGen;
    private final Map<Integer, Set<String>> dvUpdatesFiles = new HashMap<Integer, Set<String>>();
    private final Set<String> fieldInfosFiles = new HashSet<String>();
    @Deprecated
    private final Map<Long, Set<String>> genUpdatesFiles = new HashMap<Long, Set<String>>();
    private volatile long sizeInBytes = -1L;
    private long bufferedDeletesGen;

    public SegmentCommitInfo(SegmentInfo segmentInfo, int n2, long l2, long l3, long l4) {
        this.info = segmentInfo;
        this.delCount = n2;
        this.delGen = l2;
        this.nextWriteDelGen = l2 == -1L ? 1L : l2 + 1L;
        this.fieldInfosGen = l3;
        this.nextWriteFieldInfosGen = l3 == -1L ? 1L : l3 + 1L;
        this.docValuesGen = l4;
        this.nextWriteDocValuesGen = l4 == -1L ? 1L : l4 + 1L;
    }

    @Deprecated
    public void setGenUpdatesFiles(Map<Long, Set<String>> map) {
        this.genUpdatesFiles.clear();
        for (Map.Entry<Long, Set<String>> entry : map.entrySet()) {
            HashSet<String> hashSet = new HashSet<String>();
            for (String string : entry.getValue()) {
                hashSet.add(this.info.namedForThisSegment(string));
            }
            this.genUpdatesFiles.put(entry.getKey(), hashSet);
        }
    }

    public Map<Integer, Set<String>> getDocValuesUpdatesFiles() {
        return Collections.unmodifiableMap(this.dvUpdatesFiles);
    }

    public void setDocValuesUpdatesFiles(Map<Integer, Set<String>> map) {
        this.dvUpdatesFiles.clear();
        for (Map.Entry<Integer, Set<String>> entry : map.entrySet()) {
            HashSet<String> hashSet = new HashSet<String>();
            for (String string : entry.getValue()) {
                hashSet.add(this.info.namedForThisSegment(string));
            }
            this.dvUpdatesFiles.put(entry.getKey(), hashSet);
        }
    }

    public Set<String> getFieldInfosFiles() {
        return Collections.unmodifiableSet(this.fieldInfosFiles);
    }

    public void setFieldInfosFiles(Set<String> set) {
        this.fieldInfosFiles.clear();
        for (String string : set) {
            this.fieldInfosFiles.add(this.info.namedForThisSegment(string));
        }
    }

    void advanceDelGen() {
        this.delGen = this.nextWriteDelGen;
        this.nextWriteDelGen = this.delGen + 1L;
        this.sizeInBytes = -1L;
    }

    void advanceNextWriteDelGen() {
        ++this.nextWriteDelGen;
    }

    long getNextWriteDelGen() {
        return this.nextWriteDelGen;
    }

    void setNextWriteDelGen(long l2) {
        this.nextWriteDelGen = l2;
    }

    void advanceFieldInfosGen() {
        this.fieldInfosGen = this.nextWriteFieldInfosGen;
        this.nextWriteFieldInfosGen = this.fieldInfosGen + 1L;
        this.sizeInBytes = -1L;
    }

    void advanceNextWriteFieldInfosGen() {
        ++this.nextWriteFieldInfosGen;
    }

    long getNextWriteFieldInfosGen() {
        return this.nextWriteFieldInfosGen;
    }

    void setNextWriteFieldInfosGen(long l2) {
        this.nextWriteFieldInfosGen = l2;
    }

    void advanceDocValuesGen() {
        this.docValuesGen = this.nextWriteDocValuesGen;
        this.nextWriteDocValuesGen = this.docValuesGen + 1L;
        this.sizeInBytes = -1L;
    }

    void advanceNextWriteDocValuesGen() {
        ++this.nextWriteDocValuesGen;
    }

    long getNextWriteDocValuesGen() {
        return this.nextWriteDocValuesGen;
    }

    void setNextWriteDocValuesGen(long l2) {
        this.nextWriteDocValuesGen = l2;
    }

    public long sizeInBytes() throws IOException {
        if (this.sizeInBytes == -1L) {
            long l2 = 0L;
            for (String string : this.files()) {
                l2 += this.info.dir.fileLength(string);
            }
            this.sizeInBytes = l2;
        }
        return this.sizeInBytes;
    }

    public Collection<String> files() throws IOException {
        HashSet<String> hashSet = new HashSet<String>(this.info.files());
        this.info.getCodec().liveDocsFormat().files(this, hashSet);
        for (Set<String> set : this.genUpdatesFiles.values()) {
            hashSet.addAll(set);
        }
        for (Set<String> set : this.dvUpdatesFiles.values()) {
            hashSet.addAll(set);
        }
        hashSet.addAll(this.fieldInfosFiles);
        return hashSet;
    }

    long getBufferedDeletesGen() {
        return this.bufferedDeletesGen;
    }

    void setBufferedDeletesGen(long l2) {
        this.bufferedDeletesGen = l2;
        this.sizeInBytes = -1L;
    }

    public boolean hasDeletions() {
        return this.delGen != -1L;
    }

    public boolean hasFieldUpdates() {
        return this.fieldInfosGen != -1L;
    }

    public long getNextFieldInfosGen() {
        return this.nextWriteFieldInfosGen;
    }

    public long getFieldInfosGen() {
        return this.fieldInfosGen;
    }

    public long getNextDocValuesGen() {
        return this.nextWriteDocValuesGen;
    }

    public long getDocValuesGen() {
        return this.docValuesGen;
    }

    public long getNextDelGen() {
        return this.nextWriteDelGen;
    }

    public long getDelGen() {
        return this.delGen;
    }

    public int getDelCount() {
        return this.delCount;
    }

    void setDelCount(int n2) {
        if (n2 < 0 || n2 > this.info.maxDoc()) {
            throw new IllegalArgumentException("invalid delCount=" + n2 + " (maxDoc=" + this.info.maxDoc() + ")");
        }
        this.delCount = n2;
    }

    public String toString(int n2) {
        String string = this.info.toString(this.delCount + n2);
        if (this.delGen != -1L) {
            string = string + ":delGen=" + this.delGen;
        }
        if (this.fieldInfosGen != -1L) {
            string = string + ":fieldInfosGen=" + this.fieldInfosGen;
        }
        if (this.docValuesGen != -1L) {
            string = string + ":dvGen=" + this.docValuesGen;
        }
        return string;
    }

    public String toString() {
        return this.toString(0);
    }

    public SegmentCommitInfo clone() {
        SegmentCommitInfo segmentCommitInfo = new SegmentCommitInfo(this.info, this.delCount, this.delGen, this.fieldInfosGen, this.docValuesGen);
        segmentCommitInfo.nextWriteDelGen = this.nextWriteDelGen;
        segmentCommitInfo.nextWriteFieldInfosGen = this.nextWriteFieldInfosGen;
        segmentCommitInfo.nextWriteDocValuesGen = this.nextWriteDocValuesGen;
        for (Map.Entry<Long, Set<String>> entry : this.genUpdatesFiles.entrySet()) {
            segmentCommitInfo.genUpdatesFiles.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        for (Map.Entry<Number, Set<String>> entry : this.dvUpdatesFiles.entrySet()) {
            segmentCommitInfo.dvUpdatesFiles.put((Integer)entry.getKey(), new HashSet(entry.getValue()));
        }
        segmentCommitInfo.fieldInfosFiles.addAll(this.fieldInfosFiles);
        return segmentCommitInfo;
    }
}

