/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.e;
import org.apache.lucene.codecs.i;
import org.apache.lucene.codecs.n;
import org.apache.lucene.codecs.p;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.a;
import org.apache.lucene.store.c;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.IOUtils;

final class SegmentCoreReaders {
    private final AtomicInteger ref = new AtomicInteger(1);
    final e fields;
    final i normsProducer;
    final n fieldsReaderOrig;
    final p termVectorsReaderOrig;
    final c cfsReader;
    final FieldInfos coreFieldInfos;
    final CloseableThreadLocal<n> fieldsReaderLocal = new FieldsReaderLocal();
    final CloseableThreadLocal<p> termVectorsLocal = new TermVectorsLocal();
    private final Set<LeafReader.a> coreClosedListeners = Collections.synchronizedSet(new LinkedHashSet());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SegmentCoreReaders(SegmentReader segmentReader, c c2, SegmentCommitInfo segmentCommitInfo, IOContext iOContext) throws IOException {
        Codec codec = segmentCommitInfo.info.getCodec();
        boolean bl = false;
        try {
            c c3;
            if (segmentCommitInfo.info.getUseCompoundFile()) {
                c3 = this.cfsReader = codec.compoundFormat().getCompoundReader(c2, segmentCommitInfo.info, iOContext);
            } else {
                this.cfsReader = null;
                c3 = c2;
            }
            this.coreFieldInfos = codec.fieldInfosFormat().read(c3, segmentCommitInfo.info, "", iOContext);
            SegmentReadState segmentReadState = new SegmentReadState(c3, segmentCommitInfo.info, this.coreFieldInfos, iOContext);
            PostingsFormat postingsFormat = codec.postingsFormat();
            this.fields = postingsFormat.fieldsProducer(segmentReadState);
            assert (this.fields != null);
            if (this.coreFieldInfos.hasNorms()) {
                this.normsProducer = codec.normsFormat().normsProducer(segmentReadState);
                assert (this.normsProducer != null);
            } else {
                this.normsProducer = null;
            }
            this.fieldsReaderOrig = segmentCommitInfo.info.getCodec().storedFieldsFormat().fieldsReader(c3, segmentCommitInfo.info, this.coreFieldInfos, iOContext);
            this.termVectorsReaderOrig = this.coreFieldInfos.hasVectors() ? segmentCommitInfo.info.getCodec().termVectorsFormat().vectorsReader(c3, segmentCommitInfo.info, this.coreFieldInfos, iOContext) : null;
            bl = true;
        }
        finally {
            if (!bl) {
                this.decRef();
            }
        }
    }

    void incRef() {
        int n2;
        while ((n2 = this.ref.get()) > 0) {
            if (!this.ref.compareAndSet(n2, n2 + 1)) continue;
            return;
        }
        throw new a("SegmentCoreReaders is already closed");
    }

    void decRef() throws IOException {
        if (this.ref.decrementAndGet() == 0) {
            Throwable throwable = null;
            try {
                IOUtils.close(this.termVectorsLocal, this.fieldsReaderLocal, this.fields, this.termVectorsReaderOrig, this.fieldsReaderOrig, this.cfsReader, this.normsProducer);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
            finally {
                this.notifyCoreClosedListeners(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCoreClosedListeners(Throwable throwable) {
        Set<LeafReader.a> set = this.coreClosedListeners;
        synchronized (set) {
            for (LeafReader.a a2 : this.coreClosedListeners) {
                try {
                    a2.a(this);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        continue;
                    }
                    throwable.addSuppressed(throwable2);
                }
            }
            IOUtils.reThrowUnchecked(throwable);
        }
    }

    class TermVectorsLocal
    extends CloseableThreadLocal<p> {
        TermVectorsLocal() {
        }

        @Override
        protected p initialValue() {
            return SegmentCoreReaders.this.termVectorsReaderOrig == null ? null : SegmentCoreReaders.this.termVectorsReaderOrig.clone();
        }
    }

    class FieldsReaderLocal
    extends CloseableThreadLocal<n> {
        FieldsReaderLocal() {
        }

        @Override
        protected n initialValue() {
            return SegmentCoreReaders.this.fieldsReaderOrig.clone();
        }
    }
}

