/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.b;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.c;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RefCount;

final class SegmentDocValues {
    private final Map<Long, RefCount<b>> genDVProducers = new HashMap<Long, RefCount<b>>();

    SegmentDocValues() {
    }

    private RefCount<b> newDocValuesProducer(SegmentCommitInfo segmentCommitInfo, c c2, final Long l2, FieldInfos fieldInfos) throws IOException {
        c c3 = c2;
        String string = "";
        if (l2 != -1L) {
            c3 = segmentCommitInfo.info.dir;
            string = Long.toString(l2, 36);
        }
        SegmentReadState segmentReadState = new SegmentReadState(c3, segmentCommitInfo.info, fieldInfos, IOContext.READ, string);
        DocValuesFormat docValuesFormat = segmentCommitInfo.info.getCodec().docValuesFormat();
        return new RefCount<b>(docValuesFormat.fieldsProducer(segmentReadState)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void release() throws IOException {
                ((b)this.object).close();
                SegmentDocValues segmentDocValues = SegmentDocValues.this;
                synchronized (segmentDocValues) {
                    SegmentDocValues.this.genDVProducers.remove(l2);
                }
            }
        };
    }

    synchronized b getDocValuesProducer(long l2, SegmentCommitInfo segmentCommitInfo, c c2, FieldInfos fieldInfos) throws IOException {
        RefCount<b> refCount = this.genDVProducers.get(l2);
        if (refCount == null) {
            refCount = this.newDocValuesProducer(segmentCommitInfo, c2, l2, fieldInfos);
            assert (refCount != null);
            this.genDVProducers.put(l2, refCount);
        } else {
            refCount.incRef();
        }
        return refCount.get();
    }

    synchronized void decRef(List<Long> list) throws IOException {
        Throwable throwable = null;
        for (Long l2 : list) {
            RefCount<b> refCount = this.genDVProducers.get(l2);
            assert (refCount != null) : "gen=" + l2;
            try {
                refCount.decRef();
            }
            catch (Throwable throwable2) {
                if (throwable == null) continue;
                throwable = throwable2;
            }
        }
        if (throwable != null) {
            IOUtils.reThrow(throwable);
        }
    }
}

