/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.g;
import org.apache.lucene.index.i;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.b;
import org.apache.lucene.store.c;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.Version;

public final class SegmentInfos
implements Cloneable,
Iterable<SegmentCommitInfo> {
    public int counter;
    public long version;
    private long generation;
    private long lastGeneration;
    public Map<String, String> userData = Collections.emptyMap();
    private List<SegmentCommitInfo> segments = new ArrayList<SegmentCommitInfo>();
    private static PrintStream infoStream = null;
    private byte[] id;
    private Version luceneVersion;
    private Version minSegmentLuceneVersion;
    private static final List<String> unsupportedCodecs = Arrays.asList("Lucene3x");
    boolean pendingCommit;

    public SegmentCommitInfo info(int n2) {
        return this.segments.get(n2);
    }

    public static long getLastCommitGeneration(String[] stringArray) {
        long l2 = -1L;
        for (String string : stringArray) {
            long l3;
            if (!string.startsWith("segments") || string.equals("segments.gen") || (l3 = SegmentInfos.generationFromSegmentsFileName(string)) <= l2) continue;
            l2 = l3;
        }
        return l2;
    }

    public static String getLastCommitSegmentsFileName(String[] stringArray) {
        return IndexFileNames.fileNameFromGeneration("segments", "", SegmentInfos.getLastCommitGeneration(stringArray));
    }

    public String getSegmentsFileName() {
        return IndexFileNames.fileNameFromGeneration("segments", "", this.lastGeneration);
    }

    public static long generationFromSegmentsFileName(String string) {
        if (string.equals("segments")) {
            return 0L;
        }
        if (string.startsWith("segments")) {
            return Long.parseLong(string.substring(1 + "segments".length()), 36);
        }
        throw new IllegalArgumentException("fileName \"" + string + "\" is not a segments file");
    }

    private long getNextPendingGeneration() {
        if (this.generation == -1L) {
            return 1L;
        }
        return this.generation + 1L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final SegmentInfos readCommit(c c2, String string) throws IOException {
        long l2 = SegmentInfos.generationFromSegmentsFileName(string);
        try (b b2 = c2.openChecksumInput(string, IOContext.READ);){
            int n2 = b2.readInt();
            if (n2 != 1071082519) {
                throw new IndexFormatTooOldException(b2, n2, 1071082519, 1071082519);
            }
            int n3 = CodecUtil.checkHeaderNoMagic(b2, "segments", 0, 6);
            byte[] byArray = null;
            if (n3 >= 4) {
                byArray = new byte[16];
                b2.readBytes(byArray, 0, byArray.length);
                CodecUtil.checkIndexHeaderSuffix(b2, Long.toString(l2, 36));
            }
            SegmentInfos segmentInfos = new SegmentInfos();
            segmentInfos.id = byArray;
            segmentInfos.generation = l2;
            segmentInfos.lastGeneration = l2;
            if (n3 >= 6) {
                segmentInfos.luceneVersion = Version.fromBits(b2.readVInt(), b2.readVInt(), b2.readVInt());
            }
            segmentInfos.version = b2.readLong();
            segmentInfos.counter = b2.readInt();
            int n4 = b2.readInt();
            if (n4 < 0) {
                throw new CorruptIndexException("invalid segment count: " + n4, b2);
            }
            if (n3 >= 6 && n4 > 0) {
                segmentInfos.minSegmentLuceneVersion = Version.fromBits(b2.readVInt(), b2.readVInt(), b2.readVInt());
                if (!segmentInfos.minSegmentLuceneVersion.onOrAfter(Version.LUCENE_4_0_0_ALPHA)) {
                    throw new IndexFormatTooOldException(b2, "this index contains a too-old segment (version: " + segmentInfos.minSegmentLuceneVersion + ")");
                }
            }
            long l3 = 0L;
            for (int i2 = 0; i2 < n4; ++i2) {
                Map map;
                byte[] byArray2;
                String string2 = b2.readString();
                if (n3 >= 4) {
                    byte by = b2.readByte();
                    if (by == 1) {
                        byArray2 = new byte[16];
                        b2.readBytes(byArray2, 0, byArray2.length);
                    } else {
                        if (by != 0) throw new CorruptIndexException("invalid hasID byte, got: " + by, b2);
                        byArray2 = null;
                    }
                } else {
                    byArray2 = null;
                }
                Codec codec = SegmentInfos.readCodec(b2, n3 < 6);
                SegmentInfo segmentInfo = codec.segmentInfoFormat().read(c2, string2, byArray2, IOContext.READ);
                segmentInfo.setCodec(codec);
                l3 += (long)segmentInfo.maxDoc();
                long l4 = b2.readLong();
                int n5 = b2.readInt();
                if (n5 < 0 || n5 > segmentInfo.maxDoc()) {
                    throw new CorruptIndexException("invalid deletion count: " + n5 + " vs maxDoc=" + segmentInfo.maxDoc(), b2);
                }
                long l5 = -1L;
                if (n3 >= 1) {
                    l5 = b2.readLong();
                }
                long l6 = -1L;
                l6 = n3 >= 3 ? b2.readLong() : l5;
                SegmentCommitInfo segmentCommitInfo = new SegmentCommitInfo(segmentInfo, n5, l4, l5, l6);
                if (n3 >= 1) {
                    if (n3 < 3) {
                        Map<Long, Set<String>> map2;
                        int n6 = b2.readInt();
                        if (n6 == 0) {
                            map2 = Collections.emptyMap();
                        } else {
                            map2 = new HashMap(n6);
                            for (int i3 = 0; i3 < n6; ++i3) {
                                map2.put(b2.readLong(), b2.readStringSet());
                            }
                        }
                        segmentCommitInfo.setGenUpdatesFiles(map2);
                    } else {
                        if (n3 >= 5) {
                            segmentCommitInfo.setFieldInfosFiles(b2.readSetOfStrings());
                        } else {
                            segmentCommitInfo.setFieldInfosFiles(Collections.unmodifiableSet(b2.readStringSet()));
                        }
                        int n7 = b2.readInt();
                        if (n7 == 0) {
                            map = Collections.emptyMap();
                        } else {
                            HashMap<Integer, Set<String>> hashMap = new HashMap<Integer, Set<String>>(n7);
                            for (int i4 = 0; i4 < n7; ++i4) {
                                if (n3 >= 5) {
                                    hashMap.put(b2.readInt(), b2.readSetOfStrings());
                                    continue;
                                }
                                hashMap.put(b2.readInt(), Collections.unmodifiableSet(b2.readStringSet()));
                            }
                            map = Collections.unmodifiableMap(hashMap);
                        }
                        segmentCommitInfo.setDocValuesUpdatesFiles(map);
                    }
                }
                segmentInfos.add(segmentCommitInfo);
                map = segmentInfo.getVersion();
                if (n3 < 6) {
                    if (segmentInfos.minSegmentLuceneVersion != null && ((Version)((Object)map)).onOrAfter(segmentInfos.minSegmentLuceneVersion)) continue;
                    segmentInfos.minSegmentLuceneVersion = map;
                    continue;
                }
                if (((Version)((Object)map)).onOrAfter(segmentInfos.minSegmentLuceneVersion)) continue;
                throw new CorruptIndexException("segments file recorded minSegmentLuceneVersion=" + segmentInfos.minSegmentLuceneVersion + " but segment=" + segmentInfo + " has older version=" + map, b2);
            }
            segmentInfos.userData = n3 >= 5 ? b2.readMapOfStrings() : Collections.unmodifiableMap(b2.readStringStringMap());
            if (n3 >= 2) {
                CodecUtil.checkFooter(b2);
            } else {
                long l7;
                long l8 = b2.getChecksum();
                if (l8 != (l7 = b2.readLong())) {
                    throw new CorruptIndexException("checksum failed (hardware problem?) : expected=" + Long.toHexString(l7) + " actual=" + Long.toHexString(l8), b2);
                }
                CodecUtil.checkEOF(b2);
            }
            if (l3 > (long)IndexWriter.getActualMaxDocs()) {
                throw new CorruptIndexException("Too many documents: an index cannot exceed " + IndexWriter.getActualMaxDocs() + " but readers have total maxDoc=" + l3, b2);
            }
            SegmentInfos segmentInfos2 = segmentInfos;
            return segmentInfos2;
        }
    }

    private static Codec readCodec(DataInput dataInput, boolean bl) throws IOException {
        String string = dataInput.readString();
        try {
            return Codec.forName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (unsupportedCodecs.contains(string)) {
                assert (bl);
                IndexFormatTooOldException indexFormatTooOldException = new IndexFormatTooOldException(dataInput, "Codec '" + string + "' is too old");
                indexFormatTooOldException.initCause(illegalArgumentException);
                throw indexFormatTooOldException;
            }
            if (string.startsWith("Lucene")) {
                throw new IllegalArgumentException("Could not load codec '" + string + "'.  Did you forget to add lucene-backward-codecs.jar?", illegalArgumentException);
            }
            throw illegalArgumentException;
        }
    }

    public static final SegmentInfos readLatestCommit(c c2) throws IOException {
        return (SegmentInfos)new FindSegmentsFile<SegmentInfos>(c2){

            protected SegmentInfos a(String string) throws IOException {
                return SegmentInfos.readCommit(this.directory, string);
            }

            @Override
            protected /* synthetic */ Object doBody(String string) throws IOException {
                return this.a(string);
            }
        }.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(c c2) throws IOException {
        IndexOutput indexOutput;
        String string;
        block12: {
            long l2 = this.getNextPendingGeneration();
            string = IndexFileNames.fileNameFromGeneration("pending_segments", "", l2);
            this.generation = l2;
            indexOutput = null;
            boolean bl = false;
            try {
                Object object;
                indexOutput = c2.createOutput(string, IOContext.DEFAULT);
                CodecUtil.writeIndexHeader(indexOutput, "segments", 6, StringHelper.randomId(), Long.toString(l2, 36));
                indexOutput.writeVInt(Version.LATEST.major);
                indexOutput.writeVInt(Version.LATEST.minor);
                indexOutput.writeVInt(Version.LATEST.bugfix);
                indexOutput.writeLong(this.version);
                indexOutput.writeInt(this.counter);
                indexOutput.writeInt(this.size());
                if (this.size() > 0) {
                    Object object2 = null;
                    for (Object object3 : this) {
                        object = ((SegmentCommitInfo)object3).info.getVersion();
                        if (object2 != null && ((Version)object).onOrAfter((Version)object2)) continue;
                        object2 = object;
                    }
                    indexOutput.writeVInt(((Version)object2).major);
                    indexOutput.writeVInt(((Version)object2).minor);
                    indexOutput.writeVInt(((Version)object2).bugfix);
                }
                for (Object object4 : this) {
                    Object object3;
                    object3 = ((SegmentCommitInfo)object4).info;
                    indexOutput.writeString(((SegmentInfo)object3).name);
                    object = ((SegmentInfo)object3).getId();
                    if (object == null) {
                        indexOutput.writeByte((byte)0);
                    } else {
                        if (((Object)object).length != 16) {
                            throw new IllegalStateException("cannot write segment: invalid id segment=" + ((SegmentInfo)object3).name + "id=" + StringHelper.idToString((byte[])object));
                        }
                        indexOutput.writeByte((byte)1);
                        indexOutput.writeBytes((byte[])object, ((Object)object).length);
                    }
                    indexOutput.writeString(((SegmentInfo)object3).getCodec().getName());
                    indexOutput.writeLong(((SegmentCommitInfo)object4).getDelGen());
                    int n2 = ((SegmentCommitInfo)object4).getDelCount();
                    if (n2 < 0 || n2 > ((SegmentInfo)object3).maxDoc()) {
                        throw new IllegalStateException("cannot write segment: invalid maxDoc segment=" + ((SegmentInfo)object3).name + " maxDoc=" + ((SegmentInfo)object3).maxDoc() + " delCount=" + n2);
                    }
                    indexOutput.writeInt(n2);
                    indexOutput.writeLong(((SegmentCommitInfo)object4).getFieldInfosGen());
                    indexOutput.writeLong(((SegmentCommitInfo)object4).getDocValuesGen());
                    indexOutput.writeSetOfStrings(((SegmentCommitInfo)object4).getFieldInfosFiles());
                    Map<Integer, Set<String>> map = ((SegmentCommitInfo)object4).getDocValuesUpdatesFiles();
                    indexOutput.writeInt(map.size());
                    for (Map.Entry<Integer, Set<String>> entry : map.entrySet()) {
                        indexOutput.writeInt(entry.getKey());
                        indexOutput.writeSetOfStrings(entry.getValue());
                    }
                }
                indexOutput.writeMapOfStrings(this.userData);
                CodecUtil.writeFooter(indexOutput);
                indexOutput.close();
                c2.sync(Collections.singleton(string));
                bl = true;
                if (!bl) break block12;
                this.pendingCommit = true;
            }
            catch (Throwable throwable) {
                if (bl) {
                    this.pendingCommit = true;
                } else {
                    IOUtils.closeWhileHandlingException(indexOutput);
                    IOUtils.deleteFilesIgnoringExceptions(c2, string);
                }
                throw throwable;
            }
        }
        IOUtils.closeWhileHandlingException(indexOutput);
        IOUtils.deleteFilesIgnoringExceptions(c2, string);
    }

    public SegmentInfos clone() {
        try {
            SegmentInfos segmentInfos = (SegmentInfos)super.clone();
            segmentInfos.segments = new ArrayList<SegmentCommitInfo>(this.size());
            for (SegmentCommitInfo segmentCommitInfo : this) {
                assert (segmentCommitInfo.info.getCodec() != null);
                segmentInfos.add(segmentCommitInfo.clone());
            }
            segmentInfos.userData = new HashMap<String, String>(this.userData);
            return segmentInfos;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("should not happen", cloneNotSupportedException);
        }
    }

    public long getVersion() {
        return this.version;
    }

    public long getGeneration() {
        return this.generation;
    }

    public long getLastGeneration() {
        return this.lastGeneration;
    }

    private static void message(String string) {
        infoStream.println("SIS [" + Thread.currentThread().getName() + "]: " + string);
    }

    void updateGeneration(SegmentInfos segmentInfos) {
        this.lastGeneration = segmentInfos.lastGeneration;
        this.generation = segmentInfos.generation;
    }

    void updateGenerationVersionAndCounter(SegmentInfos segmentInfos) {
        this.updateGeneration(segmentInfos);
        this.version = segmentInfos.version;
        this.counter = segmentInfos.counter;
    }

    void setNextWriteGeneration(long l2) {
        assert (l2 >= this.generation);
        this.generation = l2;
    }

    final void rollbackCommit(c c2) {
        if (this.pendingCommit) {
            this.pendingCommit = false;
            String string = IndexFileNames.fileNameFromGeneration("pending_segments", "", this.generation);
            IOUtils.deleteFilesIgnoringExceptions(c2, string);
        }
    }

    final void prepareCommit(c c2) throws IOException {
        if (this.pendingCommit) {
            throw new IllegalStateException("prepareCommit was already called");
        }
        this.write(c2);
    }

    public Collection<String> files(boolean bl) throws IOException {
        String string;
        HashSet<String> hashSet = new HashSet<String>();
        if (bl && (string = this.getSegmentsFileName()) != null) {
            hashSet.add(string);
        }
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SegmentCommitInfo segmentCommitInfo = this.info(i2);
            hashSet.addAll(segmentCommitInfo.files());
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String finishCommit(c c2) throws IOException {
        String string;
        if (!this.pendingCommit) {
            throw new IllegalStateException("prepareCommit was not called");
        }
        boolean bl = false;
        try {
            String string2 = IndexFileNames.fileNameFromGeneration("pending_segments", "", this.generation);
            string = IndexFileNames.fileNameFromGeneration("segments", "", this.generation);
            c2.renameFile(string2, string);
            bl = true;
        }
        finally {
            if (!bl) {
                this.rollbackCommit(c2);
            }
        }
        this.pendingCommit = false;
        this.lastGeneration = this.generation;
        return string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getSegmentsFileName()).append(": ");
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(' ');
            }
            SegmentCommitInfo segmentCommitInfo = this.info(i2);
            stringBuilder.append(segmentCommitInfo.toString(0));
        }
        return stringBuilder.toString();
    }

    public Map<String, String> getUserData() {
        return this.userData;
    }

    void replace(SegmentInfos segmentInfos) {
        this.rollbackSegmentInfos(segmentInfos.asList());
        this.lastGeneration = segmentInfos.lastGeneration;
    }

    public int totalMaxDoc() {
        long l2 = 0L;
        for (SegmentCommitInfo segmentCommitInfo : this) {
            l2 += (long)segmentCommitInfo.info.maxDoc();
        }
        assert (l2 <= (long)IndexWriter.getActualMaxDocs());
        return (int)l2;
    }

    public void changed() {
        ++this.version;
    }

    void applyMergeChanges(MergePolicy.OneMerge oneMerge, boolean bl) {
        HashSet<SegmentCommitInfo> hashSet = new HashSet<SegmentCommitInfo>(oneMerge.segments);
        boolean bl2 = false;
        int n2 = 0;
        int n3 = this.segments.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            assert (i2 >= n2);
            SegmentCommitInfo segmentCommitInfo = this.segments.get(i2);
            if (hashSet.contains(segmentCommitInfo)) {
                if (bl2 || bl) continue;
                this.segments.set(i2, oneMerge.info);
                bl2 = true;
                ++n2;
                continue;
            }
            this.segments.set(n2, segmentCommitInfo);
            ++n2;
        }
        this.segments.subList(n2, this.segments.size()).clear();
        if (!bl2 && !bl) {
            this.segments.add(0, oneMerge.info);
        }
    }

    List<SegmentCommitInfo> createBackupSegmentInfos() {
        ArrayList<SegmentCommitInfo> arrayList = new ArrayList<SegmentCommitInfo>(this.size());
        for (SegmentCommitInfo segmentCommitInfo : this) {
            assert (segmentCommitInfo.info.getCodec() != null);
            arrayList.add(segmentCommitInfo.clone());
        }
        return arrayList;
    }

    void rollbackSegmentInfos(List<SegmentCommitInfo> list) {
        this.clear();
        this.addAll(list);
    }

    @Override
    public Iterator<SegmentCommitInfo> iterator() {
        return this.asList().iterator();
    }

    public List<SegmentCommitInfo> asList() {
        return Collections.unmodifiableList(this.segments);
    }

    public int size() {
        return this.segments.size();
    }

    public void add(SegmentCommitInfo segmentCommitInfo) {
        this.segments.add(segmentCommitInfo);
    }

    public void addAll(Iterable<SegmentCommitInfo> iterable) {
        for (SegmentCommitInfo segmentCommitInfo : iterable) {
            this.add(segmentCommitInfo);
        }
    }

    public void clear() {
        this.segments.clear();
    }

    public void remove(SegmentCommitInfo segmentCommitInfo) {
        this.segments.remove(segmentCommitInfo);
    }

    void remove(int n2) {
        this.segments.remove(n2);
    }

    boolean contains(SegmentCommitInfo segmentCommitInfo) {
        return this.segments.contains(segmentCommitInfo);
    }

    int indexOf(SegmentCommitInfo segmentCommitInfo) {
        return this.segments.indexOf(segmentCommitInfo);
    }

    public static abstract class FindSegmentsFile<T> {
        final c directory;

        public FindSegmentsFile(c c2) {
            this.directory = c2;
        }

        public T run() throws IOException {
            return this.run(null);
        }

        public T run(g g2) throws IOException {
            if (g2 != null) {
                if (this.directory != g2.getDirectory()) {
                    throw new IOException("the specified commit does not match the specified Directory");
                }
                return this.doBody(g2.getSegmentsFileName());
            }
            long l2 = -1L;
            long l3 = -1L;
            IOException iOException = null;
            while (true) {
                l2 = l3;
                Object[] objectArray = this.directory.listAll();
                Object[] objectArray2 = this.directory.listAll();
                Arrays.sort(objectArray);
                Arrays.sort(objectArray2);
                if (!Arrays.equals(objectArray, objectArray2)) continue;
                l3 = SegmentInfos.getLastCommitGeneration((String[])objectArray);
                if (infoStream != null) {
                    SegmentInfos.message("directory listing gen=" + l3);
                }
                if (l3 == -1L) {
                    throw new i("no segments* file found in " + this.directory + ": files: " + Arrays.toString(objectArray));
                }
                if (l3 <= l2) break;
                String string = IndexFileNames.fileNameFromGeneration("segments", "", l3);
                try {
                    T t2 = this.doBody(string);
                    if (infoStream != null) {
                        SegmentInfos.message("success on " + string);
                    }
                    return t2;
                }
                catch (IOException iOException2) {
                    if (iOException == null) {
                        iOException = iOException2;
                    }
                    if (infoStream == null) continue;
                    SegmentInfos.message("primary Exception on '" + string + "': " + iOException2 + "'; will retry: gen = " + l3);
                    continue;
                }
                break;
            }
            throw iOException;
        }

        protected abstract T doBody(String var1) throws IOException;
    }
}

