/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collections;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.b;
import org.apache.lucene.codecs.c;
import org.apache.lucene.codecs.e;
import org.apache.lucene.codecs.i;
import org.apache.lucene.codecs.n;
import org.apache.lucene.codecs.p;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentCoreReaders;
import org.apache.lucene.index.SegmentDocValues;
import org.apache.lucene.index.SegmentDocValuesProducer;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Bits;

public final class SegmentReader
extends CodecReader {
    private final SegmentCommitInfo si;
    private final Bits liveDocs;
    private final int numDocs;
    final SegmentCoreReaders core;
    final SegmentDocValues segDocValues;
    final b docValuesProducer;
    final FieldInfos fieldInfos;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SegmentReader(SegmentCommitInfo segmentCommitInfo, IOContext iOContext) throws IOException {
        this.si = segmentCommitInfo;
        this.core = new SegmentCoreReaders(this, segmentCommitInfo.info.dir, segmentCommitInfo, iOContext);
        this.segDocValues = new SegmentDocValues();
        boolean bl = false;
        Codec codec = segmentCommitInfo.info.getCodec();
        try {
            if (segmentCommitInfo.hasDeletions()) {
                this.liveDocs = codec.liveDocsFormat().readLiveDocs(this.directory(), segmentCommitInfo, IOContext.READONCE);
            } else {
                assert (segmentCommitInfo.getDelCount() == 0);
                this.liveDocs = null;
            }
            this.numDocs = segmentCommitInfo.info.maxDoc() - segmentCommitInfo.getDelCount();
            this.fieldInfos = this.initFieldInfos();
            this.docValuesProducer = this.initDocValuesProducer();
            bl = true;
        }
        finally {
            if (!bl) {
                this.doClose();
            }
        }
    }

    SegmentReader(SegmentCommitInfo segmentCommitInfo, SegmentReader segmentReader) throws IOException {
        this(segmentCommitInfo, segmentReader, segmentCommitInfo.info.getCodec().liveDocsFormat().readLiveDocs(segmentCommitInfo.info.dir, segmentCommitInfo, IOContext.READONCE), segmentCommitInfo.info.maxDoc() - segmentCommitInfo.getDelCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SegmentReader(SegmentCommitInfo segmentCommitInfo, SegmentReader segmentReader, Bits bits, int n2) throws IOException {
        if (n2 > segmentCommitInfo.info.maxDoc()) {
            throw new IllegalArgumentException("numDocs=" + n2 + " but maxDoc=" + segmentCommitInfo.info.maxDoc());
        }
        if (bits != null && bits.length() != segmentCommitInfo.info.maxDoc()) {
            throw new IllegalArgumentException("maxDoc=" + segmentCommitInfo.info.maxDoc() + " but liveDocs.size()=" + bits.length());
        }
        this.si = segmentCommitInfo;
        this.liveDocs = bits;
        this.numDocs = n2;
        this.core = segmentReader.core;
        this.core.incRef();
        this.segDocValues = segmentReader.segDocValues;
        boolean bl = false;
        try {
            this.fieldInfos = this.initFieldInfos();
            this.docValuesProducer = this.initDocValuesProducer();
            bl = true;
        }
        finally {
            if (!bl) {
                this.doClose();
            }
        }
    }

    private b initDocValuesProducer() throws IOException {
        org.apache.lucene.store.c c2;
        org.apache.lucene.store.c c3 = c2 = this.core.cfsReader != null ? this.core.cfsReader : this.si.info.dir;
        if (!this.fieldInfos.hasDocValues()) {
            return null;
        }
        if (this.si.hasFieldUpdates()) {
            return new SegmentDocValuesProducer(this.si, c2, this.core.coreFieldInfos, this.fieldInfos, this.segDocValues);
        }
        return this.segDocValues.getDocValuesProducer(-1L, this.si, c2, this.fieldInfos);
    }

    private FieldInfos initFieldInfos() throws IOException {
        if (!this.si.hasFieldUpdates()) {
            return this.core.coreFieldInfos;
        }
        c c2 = this.si.info.getCodec().fieldInfosFormat();
        String string = Long.toString(this.si.getFieldInfosGen(), 36);
        return c2.read(this.si.info.dir, this.si.info, string, IOContext.READONCE);
    }

    @Override
    public Bits getLiveDocs() {
        this.ensureOpen();
        return this.liveDocs;
    }

    @Override
    protected void doClose() throws IOException {
        try {
            this.core.decRef();
        }
        finally {
            try {
                super.doClose();
            }
            finally {
                if (this.docValuesProducer instanceof SegmentDocValuesProducer) {
                    this.segDocValues.decRef(((SegmentDocValuesProducer)this.docValuesProducer).dvGens);
                } else if (this.docValuesProducer != null) {
                    this.segDocValues.decRef(Collections.singletonList(-1L));
                }
            }
        }
    }

    @Override
    public FieldInfos getFieldInfos() {
        this.ensureOpen();
        return this.fieldInfos;
    }

    @Override
    public int numDocs() {
        return this.numDocs;
    }

    @Override
    public int maxDoc() {
        return this.si.info.maxDoc();
    }

    @Override
    public p getTermVectorsReader() {
        this.ensureOpen();
        return this.core.termVectorsLocal.get();
    }

    @Override
    public n getFieldsReader() {
        this.ensureOpen();
        return this.core.fieldsReaderLocal.get();
    }

    @Override
    public i getNormsReader() {
        this.ensureOpen();
        return this.core.normsProducer;
    }

    @Override
    public b getDocValuesReader() {
        this.ensureOpen();
        return this.docValuesProducer;
    }

    @Override
    public e getPostingsReader() {
        this.ensureOpen();
        return this.core.fields;
    }

    public String toString() {
        return this.si.toString(this.si.info.maxDoc() - this.numDocs - this.si.getDelCount());
    }

    public String getSegmentName() {
        return this.si.info.name;
    }

    public SegmentCommitInfo getSegmentInfo() {
        return this.si;
    }

    public org.apache.lucene.store.c directory() {
        return this.si.info.dir;
    }
}

