/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.AutomatonTermsEnum;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CompiledAutomaton;

public abstract class Terms {
    public static final Terms[] EMPTY_ARRAY = new Terms[0];

    protected Terms() {
    }

    public abstract TermsEnum iterator() throws IOException;

    public TermsEnum intersect(CompiledAutomaton compiledAutomaton, final BytesRef bytesRef) throws IOException {
        TermsEnum termsEnum = this.iterator();
        if (compiledAutomaton.type != CompiledAutomaton.AUTOMATON_TYPE.NORMAL) {
            throw new IllegalArgumentException("please use CompiledAutomaton.getTermsEnum instead");
        }
        if (bytesRef == null) {
            return new AutomatonTermsEnum(termsEnum, compiledAutomaton);
        }
        return new AutomatonTermsEnum(termsEnum, compiledAutomaton){

            @Override
            protected BytesRef nextSeekTerm(BytesRef bytesRef2) throws IOException {
                if (bytesRef2 == null) {
                    bytesRef2 = bytesRef;
                }
                return super.nextSeekTerm(bytesRef2);
            }
        };
    }

    public abstract long size() throws IOException;

    public abstract long getSumTotalTermFreq() throws IOException;

    public abstract long getSumDocFreq() throws IOException;

    public abstract int getDocCount() throws IOException;

    public abstract boolean hasFreqs();

    public abstract boolean hasOffsets();

    public abstract boolean hasPositions();

    public abstract boolean hasPayloads();
}

