/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.d;
import org.apache.lucene.index.q;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;

public abstract class TermsEnum
implements BytesRefIterator {
    private AttributeSource atts = null;
    public static final TermsEnum EMPTY = new TermsEnum(){

        @Override
        public SeekStatus seekCeil(BytesRef bytesRef) {
            return SeekStatus.END;
        }

        @Override
        public void seekExact(long l2) {
        }

        @Override
        public BytesRef term() {
            throw new IllegalStateException("this method should never be called");
        }

        @Override
        public int docFreq() {
            throw new IllegalStateException("this method should never be called");
        }

        @Override
        public long totalTermFreq() {
            throw new IllegalStateException("this method should never be called");
        }

        @Override
        public long ord() {
            throw new IllegalStateException("this method should never be called");
        }

        @Override
        public PostingsEnum postings(PostingsEnum postingsEnum, int n2) {
            throw new IllegalStateException("this method should never be called");
        }

        @Override
        public BytesRef next() {
            return null;
        }

        @Override
        public synchronized AttributeSource attributes() {
            return super.attributes();
        }

        @Override
        public q termState() {
            throw new IllegalStateException("this method should never be called");
        }

        @Override
        public void seekExact(BytesRef bytesRef, q q2) {
            throw new IllegalStateException("this method should never be called");
        }
    };

    protected TermsEnum() {
    }

    public AttributeSource attributes() {
        if (this.atts == null) {
            this.atts = new AttributeSource();
        }
        return this.atts;
    }

    public boolean seekExact(BytesRef bytesRef) throws IOException {
        return this.seekCeil(bytesRef) == SeekStatus.FOUND;
    }

    public abstract SeekStatus seekCeil(BytesRef var1) throws IOException;

    public abstract void seekExact(long var1) throws IOException;

    public void seekExact(BytesRef bytesRef, q q2) throws IOException {
        if (!this.seekExact(bytesRef)) {
            throw new IllegalArgumentException("term=" + bytesRef + " does not exist");
        }
    }

    public abstract BytesRef term() throws IOException;

    public abstract long ord() throws IOException;

    public abstract int docFreq() throws IOException;

    public abstract long totalTermFreq() throws IOException;

    public final PostingsEnum postings(PostingsEnum postingsEnum) throws IOException {
        return this.postings(postingsEnum, 8);
    }

    public abstract PostingsEnum postings(PostingsEnum var1, int var2) throws IOException;

    public q termState() throws IOException {
        return new q(){

            @Override
            public void copyFrom(q q2) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Deprecated
    public final d docs(Bits bits, d d2) throws IOException {
        return this.docs(bits, d2, 1);
    }

    @Deprecated
    public final d docs(Bits bits, d d2, int n2) throws IOException {
        int n3;
        if (n2 == 1) {
            n3 = 8;
        } else if (n2 == 0) {
            n3 = 0;
        } else {
            throw new IllegalArgumentException("Invalid legacy docs flags: " + n2);
        }
        PostingsEnum postingsEnum = DocsAndPositionsEnum.unwrap(d2);
        PostingsEnum postingsEnum2 = this.postings(postingsEnum, n3);
        if (postingsEnum2 == null) {
            throw new AssertionError();
        }
        if (postingsEnum2 == postingsEnum && bits == DocsAndPositionsEnum.unwrapliveDocs(d2)) {
            return d2;
        }
        return DocsAndPositionsEnum.wrap(postingsEnum2, bits);
    }

    @Deprecated
    public final DocsAndPositionsEnum docsAndPositions(Bits bits, DocsAndPositionsEnum docsAndPositionsEnum) throws IOException {
        return this.docsAndPositions(bits, docsAndPositionsEnum, 3);
    }

    @Deprecated
    public final DocsAndPositionsEnum docsAndPositions(Bits bits, DocsAndPositionsEnum docsAndPositionsEnum, int n2) throws IOException {
        int n3;
        if (n2 == 3) {
            n3 = 120;
        } else if (n2 == 1) {
            n3 = 56;
        } else if (n2 == 2) {
            n3 = 88;
        } else if (n2 == 0) {
            n3 = 24;
        } else {
            throw new IllegalArgumentException("Invalid legacy docsAndPositions flags: " + n2);
        }
        PostingsEnum postingsEnum = DocsAndPositionsEnum.unwrap(docsAndPositionsEnum);
        PostingsEnum postingsEnum2 = this.postings(postingsEnum, n3 | 0x4000);
        if (postingsEnum2 == null) {
            return null;
        }
        if (postingsEnum2 == postingsEnum && bits == DocsAndPositionsEnum.unwrapliveDocs(docsAndPositionsEnum)) {
            return docsAndPositionsEnum;
        }
        return DocsAndPositionsEnum.wrap(postingsEnum2, bits);
    }

    public static enum SeekStatus {
        END,
        FOUND,
        NOT_FOUND;

    }
}

