/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;

public class TieredMergePolicy
extends MergePolicy {
    private int maxMergeAtOnce = 10;
    private long maxMergedSegmentBytes = 0x140000000L;
    private int maxMergeAtOnceExplicit = 30;
    private long floorSegmentBytes = 0x200000L;
    private double segsPerTier = 10.0;
    private double forceMergeDeletesPctAllowed = 10.0;
    private double reclaimDeletesWeight = 2.0;

    public TieredMergePolicy() {
        super(0.1, Long.MAX_VALUE);
    }

    @Override
    public MergePolicy.MergeSpecification findMerges(MergeTrigger mergeTrigger, SegmentInfos segmentInfos, IndexWriter indexWriter) throws IOException {
        MergePolicy.MergeSpecification mergeSpecification;
        block21: {
            double d2;
            long l2;
            int n2;
            if (this.verbose(indexWriter)) {
                this.message("findMerges: " + segmentInfos.size() + " segments", indexWriter);
            }
            if (segmentInfos.size() == 0) {
                return null;
            }
            Collection<SegmentCommitInfo> collection = indexWriter.getMergingSegments();
            HashSet<SegmentCommitInfo> hashSet = new HashSet<SegmentCommitInfo>();
            ArrayList<SegmentCommitInfo> arrayList = new ArrayList<SegmentCommitInfo>(segmentInfos.asList());
            Collections.sort(arrayList, new SegmentByteSizeDescending(indexWriter));
            long l3 = 0L;
            long l4 = Long.MAX_VALUE;
            for (SegmentCommitInfo segmentCommitInfo : arrayList) {
                long l5 = this.size(segmentCommitInfo, indexWriter);
                if (this.verbose(indexWriter)) {
                    String string;
                    String string2 = string = collection.contains(segmentCommitInfo) ? " [merging]" : "";
                    if ((double)l5 >= (double)this.maxMergedSegmentBytes / 2.0) {
                        string = string + " [skip: too large]";
                    } else if (l5 < this.floorSegmentBytes) {
                        string = string + " [floored]";
                    }
                    this.message("  seg=" + indexWriter.segString(segmentCommitInfo) + " size=" + String.format(Locale.ROOT, "%.3f", (double)(l5 / 1024L) / 1024.0) + " MB" + string, indexWriter);
                }
                l4 = Math.min(l5, l4);
                l3 += l5;
            }
            for (n2 = 0; n2 < arrayList.size() && !((double)(l2 = this.size((SegmentCommitInfo)arrayList.get(n2), indexWriter)) < (double)this.maxMergedSegmentBytes / 2.0); ++n2) {
                l3 -= l2;
            }
            long l6 = l4 = this.floorSize(l4);
            long l7 = l3;
            double d3 = 0.0;
            while (!((d2 = (double)l7 / (double)l6) < this.segsPerTier)) {
                d3 += this.segsPerTier;
                l7 = (long)((double)l7 - this.segsPerTier * (double)l6);
                l6 *= (long)this.maxMergeAtOnce;
            }
            int n3 = (int)(d3 += Math.ceil(d2));
            mergeSpecification = null;
            while (true) {
                Object object;
                int n4;
                long l8 = 0L;
                ArrayList<SegmentCommitInfo> arrayList2 = new ArrayList<SegmentCommitInfo>();
                for (n4 = n2; n4 < arrayList.size(); ++n4) {
                    object = (SegmentCommitInfo)arrayList.get(n4);
                    if (collection.contains(object)) {
                        l8 += this.size((SegmentCommitInfo)object, indexWriter);
                        continue;
                    }
                    if (hashSet.contains(object)) continue;
                    arrayList2.add((SegmentCommitInfo)object);
                }
                int n5 = n4 = l8 >= this.maxMergedSegmentBytes ? 1 : 0;
                if (this.verbose(indexWriter)) {
                    this.message("  allowedSegmentCount=" + n3 + " vs count=" + arrayList.size() + " (eligible count=" + arrayList2.size() + ") tooBigCount=" + n2, indexWriter);
                }
                if (arrayList2.size() == 0) {
                    return mergeSpecification;
                }
                if (arrayList2.size() <= n3) break block21;
                object = null;
                ArrayList<SegmentCommitInfo> arrayList3 = null;
                boolean bl = false;
                long l9 = 0L;
                for (int i2 = 0; i2 <= arrayList2.size() - this.maxMergeAtOnce; ++i2) {
                    long l10 = 0L;
                    ArrayList<SegmentCommitInfo> arrayList4 = new ArrayList<SegmentCommitInfo>();
                    boolean bl2 = false;
                    for (int i3 = i2; i3 < arrayList2.size() && arrayList4.size() < this.maxMergeAtOnce; ++i3) {
                        SegmentCommitInfo segmentCommitInfo = (SegmentCommitInfo)arrayList2.get(i3);
                        long l11 = this.size(segmentCommitInfo, indexWriter);
                        if (l10 + l11 > this.maxMergedSegmentBytes) {
                            bl2 = true;
                            continue;
                        }
                        arrayList4.add(segmentCommitInfo);
                        l10 += l11;
                    }
                    assert (arrayList4.size() > 0);
                    a a2 = this.score(arrayList4, bl2, l8, indexWriter);
                    if (this.verbose(indexWriter)) {
                        this.message("  maybe=" + indexWriter.segString(arrayList4) + " score=" + a2.getScore() + " " + a2.getExplanation() + " tooLarge=" + bl2 + " size=" + String.format(Locale.ROOT, "%.3f MB", (double)l10 / 1024.0 / 1024.0), indexWriter);
                    }
                    if (object != null && !(a2.getScore() < ((a)object).getScore()) || bl2 && n4 != 0) continue;
                    arrayList3 = arrayList4;
                    object = a2;
                    bl = bl2;
                    l9 = l10;
                }
                if (arrayList3 == null) break;
                if (mergeSpecification == null) {
                    mergeSpecification = new MergePolicy.MergeSpecification();
                }
                MergePolicy.OneMerge oneMerge = new MergePolicy.OneMerge(arrayList3);
                mergeSpecification.add(oneMerge);
                for (SegmentCommitInfo segmentCommitInfo : oneMerge.segments) {
                    hashSet.add(segmentCommitInfo);
                }
                if (!this.verbose(indexWriter)) continue;
                this.message("  add merge=" + indexWriter.segString(oneMerge.segments) + " size=" + String.format(Locale.ROOT, "%.3f MB", (double)l9 / 1024.0 / 1024.0) + " score=" + String.format(Locale.ROOT, "%.3f", ((a)object).getScore()) + " " + ((a)object).getExplanation() + (bl ? " [max merge]" : ""), indexWriter);
            }
            return mergeSpecification;
        }
        return mergeSpecification;
    }

    protected a score(List<SegmentCommitInfo> list, boolean bl, long l2, IndexWriter indexWriter) throws IOException {
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        for (SegmentCommitInfo segmentCommitInfo : list) {
            long l6 = this.size(segmentCommitInfo, indexWriter);
            l4 += l6;
            l5 += this.floorSize(l6);
            l3 += segmentCommitInfo.sizeInBytes();
        }
        final double d2 = bl ? 1.0 / (double)this.maxMergeAtOnce : (double)this.floorSize(this.size(list.get(0), indexWriter)) / (double)l5;
        double d3 = d2;
        d3 *= Math.pow(l4, 0.05);
        final double d4 = (double)l4 / (double)l3;
        final double d5 = d3 *= Math.pow(d4, this.reclaimDeletesWeight);
        return new a(){

            @Override
            public double getScore() {
                return d5;
            }

            @Override
            public String getExplanation() {
                return "skew=" + String.format(Locale.ROOT, "%.3f", d2) + " nonDelRatio=" + String.format(Locale.ROOT, "%.3f", d4);
            }
        };
    }

    @Override
    public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos segmentInfos, int n2, Map<SegmentCommitInfo, Boolean> map, IndexWriter indexWriter) throws IOException {
        int n3;
        Object object;
        Object object22;
        if (this.verbose(indexWriter)) {
            this.message("findForcedMerges maxSegmentCount=" + n2 + " infos=" + indexWriter.segString(segmentInfos) + " segmentsToMerge=" + map, indexWriter);
        }
        ArrayList<SegmentCommitInfo> arrayList = new ArrayList<SegmentCommitInfo>();
        boolean bl = false;
        Collection<SegmentCommitInfo> collection = indexWriter.getMergingSegments();
        boolean bl2 = false;
        for (Object object22 : segmentInfos) {
            object = map.get(object22);
            if (object == null) continue;
            bl2 = (Boolean)object;
            if (!collection.contains(object22)) {
                arrayList.add((SegmentCommitInfo)object22);
                continue;
            }
            bl = true;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        if (n2 > 1 && arrayList.size() <= n2 || n2 == 1 && arrayList.size() == 1 && (!bl2 || this.isMerged(segmentInfos, (SegmentCommitInfo)arrayList.get(0), indexWriter))) {
            if (this.verbose(indexWriter)) {
                this.message("already merged", indexWriter);
            }
            return null;
        }
        Collections.sort(arrayList, new SegmentByteSizeDescending(indexWriter));
        if (this.verbose(indexWriter)) {
            this.message("eligible=" + arrayList, indexWriter);
            this.message("forceMergeRunning=" + bl, indexWriter);
        }
        object22 = null;
        for (n3 = arrayList.size(); n3 >= this.maxMergeAtOnceExplicit + n2 - 1; n3 -= this.maxMergeAtOnceExplicit) {
            if (object22 == null) {
                object22 = new MergePolicy.MergeSpecification();
            }
            object = new MergePolicy.OneMerge(arrayList.subList(n3 - this.maxMergeAtOnceExplicit, n3));
            if (this.verbose(indexWriter)) {
                this.message("add merge=" + indexWriter.segString(((MergePolicy.OneMerge)object).segments), indexWriter);
            }
            ((MergePolicy.MergeSpecification)object22).add((MergePolicy.OneMerge)object);
        }
        if (object22 == null && !bl) {
            int n4 = n3 - n2 + 1;
            MergePolicy.OneMerge oneMerge = new MergePolicy.OneMerge(arrayList.subList(n3 - n4, n3));
            if (this.verbose(indexWriter)) {
                this.message("add final merge=" + oneMerge.segString(), indexWriter);
            }
            object22 = new MergePolicy.MergeSpecification();
            ((MergePolicy.MergeSpecification)object22).add(oneMerge);
        }
        return object22;
    }

    private long floorSize(long l2) {
        return Math.max(this.floorSegmentBytes, l2);
    }

    private boolean verbose(IndexWriter indexWriter) {
        return indexWriter != null && indexWriter.infoStream.isEnabled("TMP");
    }

    private void message(String string, IndexWriter indexWriter) {
        indexWriter.infoStream.message("TMP", string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[" + this.getClass().getSimpleName() + ": ");
        stringBuilder.append("maxMergeAtOnce=").append(this.maxMergeAtOnce).append(", ");
        stringBuilder.append("maxMergeAtOnceExplicit=").append(this.maxMergeAtOnceExplicit).append(", ");
        stringBuilder.append("maxMergedSegmentMB=").append((double)(this.maxMergedSegmentBytes / 1024L) / 1024.0).append(", ");
        stringBuilder.append("floorSegmentMB=").append((double)(this.floorSegmentBytes / 1024L) / 1024.0).append(", ");
        stringBuilder.append("forceMergeDeletesPctAllowed=").append(this.forceMergeDeletesPctAllowed).append(", ");
        stringBuilder.append("segmentsPerTier=").append(this.segsPerTier).append(", ");
        stringBuilder.append("maxCFSSegmentSizeMB=").append(this.getMaxCFSSegmentSizeMB()).append(", ");
        stringBuilder.append("noCFSRatio=").append(this.noCFSRatio);
        return stringBuilder.toString();
    }

    protected static abstract class a {
        protected a() {
        }

        abstract double getScore();

        abstract String getExplanation();
    }

    private class SegmentByteSizeDescending
    implements Comparator<SegmentCommitInfo> {
        private final IndexWriter writer;

        SegmentByteSizeDescending(IndexWriter indexWriter) {
            this.writer = indexWriter;
        }

        @Override
        public int compare(SegmentCommitInfo segmentCommitInfo, SegmentCommitInfo segmentCommitInfo2) {
            try {
                long l2 = TieredMergePolicy.this.size(segmentCommitInfo, this.writer);
                long l3 = TieredMergePolicy.this.size(segmentCommitInfo2, this.writer);
                if (l2 > l3) {
                    return -1;
                }
                if (l3 > l2) {
                    return 1;
                }
                return segmentCommitInfo.info.name.compareTo(segmentCommitInfo2.info.name);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }
}

