/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.portmobile.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.lucene.portmobile.file.DirectoryStream;
import org.apache.lucene.portmobile.file.FileVisitor;
import org.apache.lucene.portmobile.file.NoSuchFileException;
import org.apache.lucene.portmobile.file.Path;
import org.apache.lucene.portmobile.file.StandardCopyOption;
import org.apache.lucene.portmobile.file.StandardOpenOption;
import org.apache.lucene.portmobile.file.attribute.BasicFileAttributes;
import org.apache.lucene.portmobile.util.FileChannelUtils;

public class Files {
    public static Path createDirectories(Path path) throws IOException {
        if (Files.exists(path)) {
            if (Files.isDirectory(path)) {
                return path;
            }
            throw new IOException("Path is not a directory: " + path);
        }
        Files.createDirectories(path.getParent());
        if (path.toFile().mkdir()) {
            return path;
        }
        throw new IOException("Failed creating directory: " + path);
    }

    public static FileChannel newByteChannel(Path path, StandardOpenOption standardOpenOption) throws IOException {
        return FileChannelUtils.open(path, standardOpenOption);
    }

    public static Path createFile(Path path) throws IOException {
        if (!path.toFile().createNewFile()) {
            throw new IOException("File cannot be created: " + path);
        }
        return path;
    }

    public static long size(Path path) throws IOException {
        return path.toFile().length();
    }

    public static boolean exists(Path path) {
        return path.file.exists();
    }

    public static boolean notExists(Path path) {
        return !Files.exists(path);
    }

    public static boolean isDirectory(Path path) {
        return path.file.isDirectory();
    }

    public static boolean isWritable(Path path) {
        return path.file.canWrite();
    }

    public static FileOutputStream newOutputStream(Path path) throws IOException {
        return new FileOutputStream(path.toFile());
    }

    public static FileInputStream newInputStream(Path path) throws IOException {
        return new FileInputStream(path.toFile());
    }

    public static BufferedReader newBufferedReader(Path path, Charset charset) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path.toFile()), charset));
    }

    public static DirectoryStream<Path> newDirectoryStream(Path path) throws IOException {
        File[] fileArray;
        if (!Files.isDirectory(path)) {
            throw new IOException("Not a directory: " + path);
        }
        ArrayList<Path> arrayList = new ArrayList<Path>();
        for (File file : fileArray = path.toFile().listFiles()) {
            arrayList.add(new Path(file));
        }
        return new DirectoryStream.SimpleDirectoryStream<Path>(arrayList);
    }

    public static boolean deleteIfExists(Path path) throws IOException {
        if (Files.exists(path)) {
            if (!path.toFile().delete()) {
                throw new IOException("Could not delete path: " + path);
            }
            return true;
        }
        return false;
    }

    public static Path createTempFile(Path path, String string, String string2) throws IOException {
        return new Path(File.createTempFile(string, string2, path.toFile()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path copy(Path path, Path path2, StandardCopyOption ... standardCopyOptionArray) throws IOException {
        if (Files.isDirectory(path)) {
            throw new UnsupportedOperationException("Directory copy not supported in this implementation");
        }
        FileChannel fileChannel = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        try {
            fileChannel = Files.newInputStream(path).getChannel();
            abstractInterruptibleChannel = Files.newOutputStream(path2).getChannel();
            long l2 = fileChannel.size();
            for (long i2 = 0L; i2 < l2; i2 += ((FileChannel)abstractInterruptibleChannel).transferFrom(fileChannel, i2, l2 - i2)) {
            }
        }
        finally {
            fileChannel.close();
            abstractInterruptibleChannel.close();
        }
        return path2;
    }

    public static void delete(Path path) throws IOException {
        path.toFile().delete();
    }

    public static Path move(Path path, Path path2, StandardCopyOption ... standardCopyOptionArray) throws IOException {
        if (path.toFile().renameTo(path2.toFile())) {
            return path2;
        }
        throw new IOException("Move from " + path + " to " + path2 + " failed");
    }

    public static Path walkFileTree(Path path, FileVisitor<? super Path> fileVisitor) throws IOException {
        if (Files.isDirectory(path)) {
            fileVisitor.preVisitDirectory(path, null);
            for (File file : path.toFile().listFiles()) {
                Files.walkFileTree(new Path(file), fileVisitor);
            }
            fileVisitor.postVisitDirectory(path, null);
        } else {
            fileVisitor.visitFile(path, null);
        }
        return path;
    }

    public static Path createTempDirectory(String string) throws IOException {
        File file = File.createTempFile(string, "");
        file.delete();
        file.mkdir();
        return new Path(file);
    }

    public static Path createTempDirectory(Path path, String string) throws IOException {
        File file = File.createTempFile(string, "", path.toFile());
        file.delete();
        file.mkdir();
        return new Path(file);
    }

    public static BasicFileAttributes readAttributes(Path path, Class<?> clazz) throws NoSuchFileException {
        if (Files.exists(path)) {
            return new BasicFileAttributes(path.toFile());
        }
        throw new NoSuchFileException();
    }
}

