/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.portmobile.util.Objects;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanWeight;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;

public class BooleanQuery
extends Query
implements Iterable<BooleanClause> {
    private static int maxClauseCount = 1024;
    private final boolean mutable;
    private final boolean disableCoord;
    private int minimumNumberShouldMatch;
    private List<BooleanClause> clauses;

    public static int getMaxClauseCount() {
        return maxClauseCount;
    }

    private BooleanQuery(boolean bl, int n2, BooleanClause[] booleanClauseArray) {
        this.disableCoord = bl;
        this.minimumNumberShouldMatch = n2;
        this.clauses = Collections.unmodifiableList(Arrays.asList(booleanClauseArray));
        this.mutable = false;
    }

    public boolean isCoordDisabled() {
        return this.disableCoord;
    }

    public int getMinimumNumberShouldMatch() {
        return this.minimumNumberShouldMatch;
    }

    @Override
    public final Iterator<BooleanClause> iterator() {
        return this.clauses.iterator();
    }

    private BooleanQuery rewriteNoScoring() {
        Builder builder = new Builder();
        builder.setMinimumNumberShouldMatch(this.getMinimumNumberShouldMatch());
        for (BooleanClause booleanClause : this.clauses) {
            if (booleanClause.getOccur() == BooleanClause.Occur.MUST) {
                builder.add(booleanClause.getQuery(), BooleanClause.Occur.FILTER);
                continue;
            }
            builder.add(booleanClause);
        }
        return builder.build();
    }

    @Override
    public Weight createWeight(IndexSearcher indexSearcher, boolean bl) throws IOException {
        BooleanQuery booleanQuery = this;
        if (!bl) {
            booleanQuery = this.rewriteNoScoring();
        }
        return new BooleanWeight(booleanQuery, indexSearcher, bl, this.disableCoord);
    }

    @Override
    public Query rewrite(IndexReader indexReader) throws IOException {
        Object object;
        if (this.minimumNumberShouldMatch == 0 && this.clauses.size() == 1 && !((BooleanClause)(object = this.clauses.get(0))).isProhibited()) {
            Query query = ((BooleanClause)object).getQuery().rewrite(indexReader);
            if (((BooleanClause)object).isScoring()) {
                if (this.getBoost() != 1.0f) {
                    if (query == ((BooleanClause)object).getQuery()) {
                        query = query.clone();
                    }
                    query.setBoost(this.getBoost() * query.getBoost());
                }
            } else {
                query = new ConstantScoreQuery(query);
                query.setBoost(0.0f);
            }
            return query;
        }
        object = new Builder();
        ((Builder)object).setDisableCoord(this.isCoordDisabled());
        ((Builder)object).setMinimumNumberShouldMatch(this.getMinimumNumberShouldMatch());
        boolean bl = false;
        for (BooleanClause booleanClause : this) {
            Query query = booleanClause.getQuery();
            Query query2 = query.rewrite(indexReader);
            if (query2 != query) {
                bl = true;
            }
            ((Builder)object).add(query2, booleanClause.getOccur());
        }
        if (bl) {
            BooleanQuery booleanQuery = ((Builder)object).build();
            booleanQuery.setBoost(this.getBoost());
            return booleanQuery;
        }
        return super.rewrite(indexReader);
    }

    @Override
    public String toString(String string) {
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = bl = (double)this.getBoost() != 1.0 || this.getMinimumNumberShouldMatch() > 0;
        if (bl) {
            stringBuilder.append("(");
        }
        int n2 = 0;
        for (BooleanClause booleanClause : this) {
            stringBuilder.append(booleanClause.getOccur().toString());
            Query query = booleanClause.getQuery();
            if (query instanceof BooleanQuery) {
                stringBuilder.append("(");
                stringBuilder.append(query.toString(string));
                stringBuilder.append(")");
            } else {
                stringBuilder.append(query.toString(string));
            }
            if (n2 != this.clauses.size() - 1) {
                stringBuilder.append(" ");
            }
            ++n2;
        }
        if (bl) {
            stringBuilder.append(")");
        }
        if (this.getMinimumNumberShouldMatch() > 0) {
            stringBuilder.append('~');
            stringBuilder.append(this.getMinimumNumberShouldMatch());
        }
        if (this.getBoost() != 1.0f) {
            stringBuilder.append(ToStringUtils.boost(this.getBoost()));
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        BooleanQuery booleanQuery = (BooleanQuery)object;
        return this.getMinimumNumberShouldMatch() == booleanQuery.getMinimumNumberShouldMatch() && this.disableCoord == booleanQuery.disableCoord && this.clauses.equals(booleanQuery.clauses);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.disableCoord, this.minimumNumberShouldMatch, this.clauses);
    }

    @Override
    public BooleanQuery clone() {
        BooleanQuery booleanQuery = (BooleanQuery)super.clone();
        booleanQuery.clauses = new ArrayList<BooleanClause>(this.clauses);
        return booleanQuery;
    }

    @Deprecated
    public BooleanQuery() {
        this(false);
    }

    @Deprecated
    public BooleanQuery(boolean bl) {
        this.clauses = new ArrayList<BooleanClause>();
        this.disableCoord = bl;
        this.minimumNumberShouldMatch = 0;
        this.mutable = true;
    }

    public static class Builder {
        private boolean disableCoord;
        private int minimumNumberShouldMatch;
        private final List<BooleanClause> clauses = new ArrayList<BooleanClause>();

        public Builder setDisableCoord(boolean bl) {
            this.disableCoord = bl;
            return this;
        }

        public Builder setMinimumNumberShouldMatch(int n2) {
            this.minimumNumberShouldMatch = n2;
            return this;
        }

        public Builder add(BooleanClause booleanClause) {
            this.add(booleanClause.getQuery(), booleanClause.getOccur());
            return this;
        }

        public Builder add(Query query, BooleanClause.Occur occur) {
            if (this.clauses.size() >= maxClauseCount) {
                throw new a();
            }
            this.clauses.add(new BooleanClause(query, occur));
            return this;
        }

        public BooleanQuery build() {
            return new BooleanQuery(this.disableCoord, this.minimumNumberShouldMatch, this.clauses.toArray(new BooleanClause[0]));
        }
    }

    public static class a
    extends RuntimeException {
        public a() {
            super("maxClauseCount is set to " + maxClauseCount);
        }
    }
}

