/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.util.CollectionUtil;

public class ConjunctionDISI
extends DocIdSetIterator {
    final DocIdSetIterator lead;
    final DocIdSetIterator[] others;

    public static ConjunctionDISI intersect(List<? extends DocIdSetIterator> list) {
        if (list.size() < 2) {
            throw new IllegalArgumentException("Cannot make a ConjunctionDISI of less than 2 iterators");
        }
        ArrayList<DocIdSetIterator> arrayList = new ArrayList<DocIdSetIterator>();
        ArrayList<TwoPhaseIterator> arrayList2 = new ArrayList<TwoPhaseIterator>();
        for (DocIdSetIterator docIdSetIterator : list) {
            ConjunctionDISI.addIterator(docIdSetIterator, arrayList, arrayList2);
        }
        if (arrayList2.isEmpty()) {
            return new ConjunctionDISI(arrayList);
        }
        return new TwoPhase(arrayList, arrayList2);
    }

    private static void addIterator(DocIdSetIterator docIdSetIterator, List<DocIdSetIterator> list, List<TwoPhaseIterator> list2) {
        if (docIdSetIterator.getClass() == ConjunctionDISI.class || docIdSetIterator.getClass() == TwoPhase.class) {
            ConjunctionDISI conjunctionDISI = (ConjunctionDISI)docIdSetIterator;
            list.add(conjunctionDISI.lead);
            Collections.addAll(list, conjunctionDISI.others);
            if (conjunctionDISI.getClass() == TwoPhase.class) {
                TwoPhase twoPhase = (TwoPhase)conjunctionDISI;
                Collections.addAll(list2, twoPhase.twoPhaseView.twoPhaseIterators);
            }
        } else {
            TwoPhaseIterator twoPhaseIterator = TwoPhaseIterator.asTwoPhaseIterator(docIdSetIterator);
            if (twoPhaseIterator != null) {
                list.add(twoPhaseIterator.approximation());
                list2.add(twoPhaseIterator);
            } else {
                list.add(docIdSetIterator);
            }
        }
    }

    ConjunctionDISI(List<? extends DocIdSetIterator> list) {
        assert (list.size() >= 2);
        CollectionUtil.b(list, new Comparator<DocIdSetIterator>(){

            @Override
            public int compare(DocIdSetIterator docIdSetIterator, DocIdSetIterator docIdSetIterator2) {
                return Long.compare(docIdSetIterator.cost(), docIdSetIterator2.cost());
            }
        });
        this.lead = list.get(0);
        this.others = list.subList(1, list.size()).toArray(new DocIdSetIterator[0]);
    }

    protected boolean matches() throws IOException {
        return true;
    }

    TwoPhaseIterator asTwoPhaseIterator() {
        return null;
    }

    private int doNext(int n2) throws IOException {
        block0: while (n2 != Integer.MAX_VALUE) {
            for (DocIdSetIterator docIdSetIterator : this.others) {
                int n3;
                if (docIdSetIterator.docID() >= n2 || (n3 = docIdSetIterator.advance(n2)) <= n2) continue;
                n2 = this.lead.advance(n3);
                continue block0;
            }
            if (this.matches()) {
                return n2;
            }
            n2 = this.lead.nextDoc();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int advance(int n2) throws IOException {
        return this.doNext(this.lead.advance(n2));
    }

    @Override
    public int docID() {
        return this.lead.docID();
    }

    @Override
    public int nextDoc() throws IOException {
        return this.doNext(this.lead.nextDoc());
    }

    @Override
    public long cost() {
        return this.lead.cost();
    }

    private static class TwoPhase
    extends ConjunctionDISI {
        final TwoPhaseConjunctionDISI twoPhaseView;

        private TwoPhase(List<? extends DocIdSetIterator> list, List<TwoPhaseIterator> list2) {
            super(list);
            this.twoPhaseView = new TwoPhaseConjunctionDISI(list, list2);
        }

        @Override
        public TwoPhaseConjunctionDISI asTwoPhaseIterator() {
            return this.twoPhaseView;
        }

        @Override
        protected boolean matches() throws IOException {
            return this.twoPhaseView.matches();
        }
    }

    private static class TwoPhaseConjunctionDISI
    extends TwoPhaseIterator {
        private final TwoPhaseIterator[] twoPhaseIterators;

        private TwoPhaseConjunctionDISI(List<? extends DocIdSetIterator> list, List<TwoPhaseIterator> list2) {
            super(new ConjunctionDISI(list));
            assert (list2.size() > 0);
            this.twoPhaseIterators = list2.toArray(new TwoPhaseIterator[list2.size()]);
        }

        @Override
        public boolean matches() throws IOException {
            for (TwoPhaseIterator twoPhaseIterator : this.twoPhaseIterators) {
                if (twoPhaseIterator.matches()) continue;
                return false;
            }
            return true;
        }
    }
}

