/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

public final class ConstantScoreScorer
extends Scorer {
    private final float score;
    private final TwoPhaseIterator twoPhaseIterator;
    private final DocIdSetIterator disi;

    public ConstantScoreScorer(Weight weight, float f2, DocIdSetIterator docIdSetIterator) {
        super(weight);
        this.score = f2;
        this.twoPhaseIterator = null;
        this.disi = docIdSetIterator;
    }

    public ConstantScoreScorer(Weight weight, float f2, TwoPhaseIterator twoPhaseIterator) {
        super(weight);
        this.score = f2;
        this.twoPhaseIterator = twoPhaseIterator;
        this.disi = TwoPhaseIterator.asDocIdSetIterator(twoPhaseIterator);
    }

    @Override
    public TwoPhaseIterator asTwoPhaseIterator() {
        return this.twoPhaseIterator;
    }

    @Override
    public float score() throws IOException {
        return this.score;
    }

    @Override
    public int freq() throws IOException {
        return 1;
    }

    @Override
    public int docID() {
        return this.disi.docID();
    }

    @Override
    public int nextDoc() throws IOException {
        return this.disi.nextDoc();
    }

    @Override
    public int advance(int n2) throws IOException {
        return this.disi.advance(n2);
    }

    @Override
    public long cost() {
        return this.disi.cost();
    }
}

