/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.DisiPriorityQueue;
import org.apache.lucene.search.DisiWrapper;
import org.apache.lucene.search.DocIdSetIterator;

public class DisjunctionDISIApproximation<Iter extends DocIdSetIterator>
extends DocIdSetIterator {
    final DisiPriorityQueue<Iter> subIterators;
    final long cost;

    public DisjunctionDISIApproximation(DisiPriorityQueue<Iter> disiPriorityQueue) {
        this.subIterators = disiPriorityQueue;
        long l2 = 0L;
        for (DisiWrapper<Iter> disiWrapper : disiPriorityQueue) {
            l2 += disiWrapper.cost;
        }
        this.cost = l2;
    }

    @Override
    public long cost() {
        return this.cost;
    }

    @Override
    public int docID() {
        return this.subIterators.top().doc;
    }

    @Override
    public int nextDoc() throws IOException {
        DisiWrapper<Iter> disiWrapper = this.subIterators.top();
        int n2 = disiWrapper.doc;
        do {
            disiWrapper.doc = disiWrapper.approximation.nextDoc();
            disiWrapper = this.subIterators.updateTop();
        } while (disiWrapper.doc == n2);
        return disiWrapper.doc;
    }

    @Override
    public int advance(int n2) throws IOException {
        DisiWrapper<Iter> disiWrapper = this.subIterators.top();
        do {
            disiWrapper.doc = disiWrapper.approximation.advance(n2);
            disiWrapper = this.subIterators.updateTop();
        } while (disiWrapper.doc < n2);
        return disiWrapper.doc;
    }
}

