/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.q;
import org.apache.lucene.search.BoostAttribute;
import org.apache.lucene.search.MaxNonCompetitiveBoostAttribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.automaton.LevenshteinAutomata;
import org.apache.lucene.util.automaton.a;
import org.apache.lucene.util.c;
import org.apache.lucene.util.d;

public class FuzzyTermsEnum
extends TermsEnum {
    private TermsEnum actualEnum;
    private BoostAttribute actualBoostAtt;
    private final BoostAttribute boostAtt;
    private final MaxNonCompetitiveBoostAttribute maxBoostAtt;
    private final LevenshteinAutomataAttribute dfaAtt;
    private float bottom;
    private BytesRef bottomTerm;
    private final Comparator<BytesRef> termComparator;
    protected final float minSimilarity;
    protected final float scale_factor;
    protected final int termLength;
    protected int maxEdits;
    protected final Terms terms;
    private final Term term;
    protected final int[] termText;
    protected final int realPrefixLength;
    private final boolean transpositions;
    private BytesRef queuedBottom;

    protected TermsEnum getAutomatonEnum(int n2, BytesRef bytesRef) throws IOException {
        List<CompiledAutomaton> list = this.initAutomata(n2);
        if (n2 < list.size()) {
            CompiledAutomaton compiledAutomaton = list.get(n2);
            return new AutomatonFuzzyTermsEnum(this.terms.intersect(compiledAutomaton, bytesRef == null ? null : compiledAutomaton.floor(bytesRef, new BytesRefBuilder())), list.subList(0, n2 + 1).toArray(new CompiledAutomaton[n2 + 1]));
        }
        return null;
    }

    private List<CompiledAutomaton> initAutomata(int n2) {
        List<CompiledAutomaton> list = this.dfaAtt.automata();
        if (list.size() <= n2 && n2 <= 2) {
            LevenshteinAutomata levenshteinAutomata = new LevenshteinAutomata(UnicodeUtil.newString(this.termText, this.realPrefixLength, this.termText.length - this.realPrefixLength), this.transpositions);
            String string = UnicodeUtil.newString(this.termText, 0, this.realPrefixLength);
            for (int i2 = list.size(); i2 <= n2; ++i2) {
                Automaton automaton = levenshteinAutomata.toAutomaton(i2, string);
                list.add(new CompiledAutomaton(automaton, true, false));
            }
        }
        return list;
    }

    protected void setEnum(TermsEnum termsEnum) {
        this.actualEnum = termsEnum;
        this.actualBoostAtt = termsEnum.attributes().addAttribute(BoostAttribute.class);
    }

    private void bottomChanged(BytesRef bytesRef, boolean bl) throws IOException {
        boolean bl2;
        int n2 = this.maxEdits;
        boolean bl3 = bl2 = this.bottomTerm == null || bytesRef != null && this.termComparator.compare(bytesRef, this.bottomTerm) >= 0;
        while (this.maxEdits > 0 && (bl2 ? this.bottom >= this.calculateMaxBoost(this.maxEdits) : this.bottom > this.calculateMaxBoost(this.maxEdits))) {
            --this.maxEdits;
        }
        if (n2 != this.maxEdits || bl) {
            this.maxEditDistanceChanged(bytesRef, this.maxEdits, bl);
        }
    }

    protected void maxEditDistanceChanged(BytesRef bytesRef, int n2, boolean bl) throws IOException {
        TermsEnum termsEnum = this.getAutomatonEnum(n2, bytesRef);
        if (termsEnum == null) {
            assert (n2 > 2);
            throw new IllegalArgumentException("maxEdits cannot be > LevenshteinAutomata.MAXIMUM_SUPPORTED_DISTANCE");
        }
        this.setEnum(termsEnum);
    }

    private float calculateMaxBoost(int n2) {
        float f2 = 1.0f - (float)n2 / (float)this.termLength;
        return (f2 - this.minSimilarity) * this.scale_factor;
    }

    @Override
    public BytesRef next() throws IOException {
        if (this.queuedBottom != null) {
            this.bottomChanged(this.queuedBottom, false);
            this.queuedBottom = null;
        }
        BytesRef bytesRef = this.actualEnum.next();
        this.boostAtt.setBoost(this.actualBoostAtt.getBoost());
        float f2 = this.maxBoostAtt.getMaxNonCompetitiveBoost();
        BytesRef bytesRef2 = this.maxBoostAtt.getCompetitiveTerm();
        if (bytesRef != null && (f2 != this.bottom || bytesRef2 != this.bottomTerm)) {
            this.bottom = f2;
            this.bottomTerm = bytesRef2;
            this.queuedBottom = BytesRef.deepCopyOf(bytesRef);
        }
        return bytesRef;
    }

    @Override
    public int docFreq() throws IOException {
        return this.actualEnum.docFreq();
    }

    @Override
    public long totalTermFreq() throws IOException {
        return this.actualEnum.totalTermFreq();
    }

    @Override
    public PostingsEnum postings(PostingsEnum postingsEnum, int n2) throws IOException {
        return this.actualEnum.postings(postingsEnum, n2);
    }

    @Override
    public void seekExact(BytesRef bytesRef, q q2) throws IOException {
        this.actualEnum.seekExact(bytesRef, q2);
    }

    @Override
    public q termState() throws IOException {
        return this.actualEnum.termState();
    }

    @Override
    public long ord() throws IOException {
        return this.actualEnum.ord();
    }

    @Override
    public boolean seekExact(BytesRef bytesRef) throws IOException {
        return this.actualEnum.seekExact(bytesRef);
    }

    @Override
    public TermsEnum.SeekStatus seekCeil(BytesRef bytesRef) throws IOException {
        return this.actualEnum.seekCeil(bytesRef);
    }

    @Override
    public void seekExact(long l2) throws IOException {
        this.actualEnum.seekExact(l2);
    }

    @Override
    public BytesRef term() throws IOException {
        return this.actualEnum.term();
    }

    public static final class LevenshteinAutomataAttributeImpl
    extends AttributeImpl
    implements LevenshteinAutomataAttribute {
        private final List<CompiledAutomaton> automata = new ArrayList<CompiledAutomaton>();

        @Override
        public List<CompiledAutomaton> automata() {
            return this.automata;
        }

        @Override
        public void clear() {
            this.automata.clear();
        }

        public int hashCode() {
            return this.automata.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof LevenshteinAutomataAttributeImpl)) {
                return false;
            }
            return this.automata.equals(((LevenshteinAutomataAttributeImpl)object).automata);
        }

        @Override
        public void copyTo(AttributeImpl attributeImpl) {
            List<CompiledAutomaton> list = ((LevenshteinAutomataAttribute)((Object)attributeImpl)).automata();
            list.clear();
            list.addAll(this.automata);
        }

        @Override
        public void reflectWith(d d2) {
            d2.reflect(LevenshteinAutomataAttribute.class, "automata", this.automata);
        }
    }

    public static interface LevenshteinAutomataAttribute
    extends c {
        public List<CompiledAutomaton> automata();
    }

    private class AutomatonFuzzyTermsEnum
    extends FilteredTermsEnum {
        private final a[] matchers;
        private final BytesRef termRef;
        private final BoostAttribute boostAtt;

        public AutomatonFuzzyTermsEnum(TermsEnum termsEnum, CompiledAutomaton[] compiledAutomatonArray) {
            super(termsEnum, false);
            this.boostAtt = this.attributes().addAttribute(BoostAttribute.class);
            this.matchers = new a[compiledAutomatonArray.length];
            for (int i2 = 0; i2 < compiledAutomatonArray.length; ++i2) {
                this.matchers[i2] = compiledAutomatonArray[i2].runAutomaton;
            }
            this.termRef = new BytesRef(FuzzyTermsEnum.this.term.text());
        }

        @Override
        protected FilteredTermsEnum.AcceptStatus accept(BytesRef bytesRef) {
            int n2;
            for (n2 = this.matchers.length - 1; n2 > 0 && this.matches(bytesRef, n2 - 1); --n2) {
            }
            if (n2 == 0) {
                this.boostAtt.setBoost(1.0f);
                return FilteredTermsEnum.AcceptStatus.YES;
            }
            int n3 = UnicodeUtil.codePointCount(bytesRef);
            float f2 = 1.0f - (float)n2 / (float)Math.min(n3, FuzzyTermsEnum.this.termLength);
            if (f2 > FuzzyTermsEnum.this.minSimilarity) {
                this.boostAtt.setBoost((f2 - FuzzyTermsEnum.this.minSimilarity) * FuzzyTermsEnum.this.scale_factor);
                return FilteredTermsEnum.AcceptStatus.YES;
            }
            return FilteredTermsEnum.AcceptStatus.NO;
        }

        final boolean matches(BytesRef bytesRef, int n2) {
            return n2 == 0 ? bytesRef.equals(this.termRef) : this.matchers[n2].a(bytesRef.bytes, bytesRef.offset, bytesRef.length);
        }
    }
}

