/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreCachingWrappingScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.b;
import org.apache.lucene.search.f;

public class MultiCollector
implements b {
    private final boolean cacheScores;
    private final b[] collectors;

    public static b wrap(b ... bArray) {
        return MultiCollector.wrap(Arrays.asList(bArray));
    }

    public static b wrap(Iterable<? extends b> iterable) {
        Object object;
        int n2 = 0;
        for (b object2 : iterable) {
            if (object2 == null) continue;
            ++n2;
        }
        if (n2 == 0) {
            throw new IllegalArgumentException("At least 1 collector must not be null");
        }
        if (n2 == 1) {
            object = null;
            for (b b2 : iterable) {
                if (b2 == null) continue;
                object = b2;
                break;
            }
            return object;
        }
        object = new b[n2];
        n2 = 0;
        for (b b3 : iterable) {
            if (b3 == null) continue;
            object[n2++] = b3;
        }
        return new MultiCollector((b)object);
    }

    private MultiCollector(b ... bArray) {
        this.collectors = bArray;
        int n2 = 0;
        for (b b2 : bArray) {
            if (!b2.needsScores()) continue;
            ++n2;
        }
        this.cacheScores = n2 >= 2;
    }

    @Override
    public boolean needsScores() {
        for (b b2 : this.collectors) {
            if (!b2.needsScores()) continue;
            return true;
        }
        return false;
    }

    @Override
    public f getLeafCollector(LeafReaderContext leafReaderContext) throws IOException {
        f[] fArray = new f[this.collectors.length];
        for (int i2 = 0; i2 < this.collectors.length; ++i2) {
            fArray[i2] = this.collectors[i2].getLeafCollector(leafReaderContext);
        }
        return new MultiLeafCollector(fArray, this.cacheScores);
    }

    private static class MultiLeafCollector
    implements f {
        private final boolean cacheScores;
        private final f[] collectors;

        private MultiLeafCollector(f[] fArray, boolean bl) {
            this.collectors = fArray;
            this.cacheScores = bl;
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            if (this.cacheScores) {
                scorer = new ScoreCachingWrappingScorer(scorer);
            }
            for (f f2 : this.collectors) {
                f2.setScorer(scorer);
            }
        }

        @Override
        public void collect(int n2) throws IOException {
            for (f f2 : this.collectors) {
                f2.collect(n2);
            }
        }
    }
}

