/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.portmobile.util.Objects;
import org.apache.lucene.search.MultiTermQueryConstantScoreWrapper;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoringRewrite;
import org.apache.lucene.util.AttributeSource;

public abstract class MultiTermQuery
extends Query {
    protected final String field;
    protected a rewriteMethod = CONSTANT_SCORE_REWRITE;
    public static final a CONSTANT_SCORE_REWRITE;
    @Deprecated
    public static final a CONSTANT_SCORE_FILTER_REWRITE;
    public static final a SCORING_BOOLEAN_REWRITE;
    @Deprecated
    public static final a SCORING_BOOLEAN_QUERY_REWRITE;
    public static final a CONSTANT_SCORE_BOOLEAN_REWRITE;
    @Deprecated
    public static final a CONSTANT_SCORE_BOOLEAN_QUERY_REWRITE;

    public MultiTermQuery(String string) {
        this.field = Objects.requireNonNull(string, "field must not be null");
    }

    public final String getField() {
        return this.field;
    }

    protected abstract TermsEnum getTermsEnum(Terms var1, AttributeSource var2) throws IOException;

    protected final TermsEnum getTermsEnum(Terms terms) throws IOException {
        return this.getTermsEnum(terms, new AttributeSource());
    }

    @Override
    public final Query rewrite(IndexReader indexReader) throws IOException {
        return this.rewriteMethod.rewrite(indexReader, this);
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + Float.floatToIntBits(this.getBoost());
        n3 = 31 * n3 + this.rewriteMethod.hashCode();
        if (this.field != null) {
            n3 = 31 * n3 + this.field.hashCode();
        }
        return n3;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MultiTermQuery multiTermQuery = (MultiTermQuery)object;
        if (!super.equals(object)) {
            return false;
        }
        if (!this.rewriteMethod.equals(multiTermQuery.rewriteMethod)) {
            return false;
        }
        return multiTermQuery.field == null ? this.field == null : multiTermQuery.field.equals(this.field);
    }

    static {
        CONSTANT_SCORE_FILTER_REWRITE = CONSTANT_SCORE_REWRITE = new a(){

            @Override
            public Query rewrite(IndexReader indexReader, MultiTermQuery multiTermQuery) {
                MultiTermQueryConstantScoreWrapper<MultiTermQuery> multiTermQueryConstantScoreWrapper = new MultiTermQueryConstantScoreWrapper<MultiTermQuery>(multiTermQuery);
                multiTermQueryConstantScoreWrapper.setBoost(multiTermQuery.getBoost());
                return multiTermQueryConstantScoreWrapper;
            }
        };
        SCORING_BOOLEAN_REWRITE = ScoringRewrite.SCORING_BOOLEAN_REWRITE;
        SCORING_BOOLEAN_QUERY_REWRITE = SCORING_BOOLEAN_REWRITE;
        CONSTANT_SCORE_BOOLEAN_QUERY_REWRITE = CONSTANT_SCORE_BOOLEAN_REWRITE = ScoringRewrite.CONSTANT_SCORE_BOOLEAN_REWRITE;
    }

    public static abstract class a {
        public abstract Query rewrite(IndexReader var1, MultiTermQuery var2) throws IOException;

        protected TermsEnum getTermsEnum(MultiTermQuery multiTermQuery, Terms terms, AttributeSource attributeSource) throws IOException {
            return multiTermQuery.getTermsEnum(terms, attributeSource);
        }
    }
}

