/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.q;
import org.apache.lucene.portmobile.util.Objects;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.DocIdSetBuilder;

final class MultiTermQueryConstantScoreWrapper<Q extends MultiTermQuery>
extends Query {
    protected final Q query;

    protected MultiTermQueryConstantScoreWrapper(Q q2) {
        this.query = q2;
    }

    @Override
    public String toString(String string) {
        return ((Query)this.query).toString(string);
    }

    @Override
    public final boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        MultiTermQueryConstantScoreWrapper multiTermQueryConstantScoreWrapper = (MultiTermQueryConstantScoreWrapper)object;
        return ((MultiTermQuery)this.query).equals(multiTermQueryConstantScoreWrapper.query) && this.getBoost() == multiTermQueryConstantScoreWrapper.getBoost();
    }

    @Override
    public final int hashCode() {
        return 31 * super.hashCode() + ((MultiTermQuery)this.query).hashCode();
    }

    @Override
    public Weight createWeight(final IndexSearcher indexSearcher, final boolean bl) throws IOException {
        return new ConstantScoreWeight(this){

            private boolean collectTerms(LeafReaderContext leafReaderContext, TermsEnum termsEnum, List<TermAndState> list) throws IOException {
                int n2 = Math.min(16, BooleanQuery.getMaxClauseCount());
                for (int i2 = 0; i2 < n2; ++i2) {
                    BytesRef bytesRef = termsEnum.next();
                    if (bytesRef == null) {
                        return true;
                    }
                    q q2 = termsEnum.termState();
                    if (!q2.isRealTerm()) {
                        return false;
                    }
                    list.add(new TermAndState(BytesRef.deepCopyOf(bytesRef), q2, termsEnum.docFreq(), termsEnum.totalTermFreq()));
                }
                return termsEnum.next() == null;
            }

            private WeightOrDocIdSet rewrite(LeafReaderContext leafReaderContext) throws IOException {
                Terms terms = leafReaderContext.reader().terms(((MultiTermQuery)MultiTermQueryConstantScoreWrapper.this.query).field);
                if (terms == null) {
                    return new WeightOrDocIdSet((DocIdSet)null);
                }
                TermsEnum termsEnum = ((MultiTermQuery)MultiTermQueryConstantScoreWrapper.this.query).getTermsEnum(terms);
                assert (termsEnum != null);
                PostingsEnum postingsEnum = null;
                ArrayList<TermAndState> arrayList = new ArrayList<TermAndState>();
                if (this.collectTerms(leafReaderContext, termsEnum, arrayList)) {
                    BooleanQuery.Builder builder = new BooleanQuery.Builder();
                    for (TermAndState termAndState : arrayList) {
                        TermContext termContext = new TermContext(indexSearcher.getTopReaderContext());
                        termContext.register(termAndState.state, leafReaderContext.ord, termAndState.docFreq, termAndState.totalTermFreq);
                        builder.add(new TermQuery(new Term(((MultiTermQuery)MultiTermQueryConstantScoreWrapper.this.query).field, termAndState.term), termContext), BooleanClause.Occur.SHOULD);
                    }
                    ConstantScoreQuery constantScoreQuery = new ConstantScoreQuery(builder.build());
                    constantScoreQuery.setBoost(this.score());
                    return new WeightOrDocIdSet(indexSearcher.rewrite(constantScoreQuery).createWeight(indexSearcher, bl));
                }
                DocIdSetBuilder docIdSetBuilder = new DocIdSetBuilder(leafReaderContext.reader().maxDoc());
                if (!arrayList.isEmpty()) {
                    TermsEnum termsEnum2 = terms.iterator();
                    for (TermAndState termAndState : arrayList) {
                        termsEnum2.seekExact(termAndState.term, termAndState.state);
                        postingsEnum = termsEnum2.postings(postingsEnum, 0);
                        docIdSetBuilder.add(postingsEnum);
                    }
                }
                do {
                    postingsEnum = termsEnum.postings(postingsEnum, 0);
                    docIdSetBuilder.add(postingsEnum);
                } while (termsEnum.next() != null);
                return new WeightOrDocIdSet(docIdSetBuilder.build());
            }

            private Scorer scorer(DocIdSet docIdSet) throws IOException {
                if (docIdSet == null) {
                    return null;
                }
                DocIdSetIterator docIdSetIterator = docIdSet.iterator();
                if (docIdSetIterator == null) {
                    return null;
                }
                return new ConstantScoreScorer((Weight)this, this.score(), docIdSetIterator);
            }

            @Override
            public BulkScorer bulkScorer(LeafReaderContext leafReaderContext) throws IOException {
                WeightOrDocIdSet weightOrDocIdSet = this.rewrite(leafReaderContext);
                if (weightOrDocIdSet.weight != null) {
                    return weightOrDocIdSet.weight.bulkScorer(leafReaderContext);
                }
                Scorer scorer = this.scorer(weightOrDocIdSet.set);
                if (scorer == null) {
                    return null;
                }
                return new Weight.DefaultBulkScorer(scorer);
            }

            @Override
            public Scorer scorer(LeafReaderContext leafReaderContext) throws IOException {
                WeightOrDocIdSet weightOrDocIdSet = this.rewrite(leafReaderContext);
                if (weightOrDocIdSet.weight != null) {
                    return weightOrDocIdSet.weight.scorer(leafReaderContext);
                }
                return this.scorer(weightOrDocIdSet.set);
            }
        };
    }

    private static class WeightOrDocIdSet {
        final Weight weight;
        final DocIdSet set;

        WeightOrDocIdSet(Weight weight) {
            this.weight = Objects.requireNonNull(weight);
            this.set = null;
        }

        WeightOrDocIdSet(DocIdSet docIdSet) {
            this.set = docIdSet;
            this.weight = null;
        }
    }

    private static class TermAndState {
        final BytesRef term;
        final q state;
        final int docFreq;
        final long totalTermFreq;

        TermAndState(BytesRef bytesRef, q q2, int n2, long l2) {
            this.term = bytesRef;
            this.state = q2;
            this.docFreq = n2;
            this.totalTermFreq = l2;
        }
    }
}

