/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.ToStringUtils;
import org.apache.lucene.util.automaton.Automaton;

public class PrefixQuery
extends AutomatonQuery {
    public PrefixQuery(Term term) {
        super(term, PrefixQuery.toAutomaton(term.bytes()), Integer.MAX_VALUE, true);
        if (term == null) {
            throw new NullPointerException("prefix cannot be null");
        }
    }

    public static Automaton toAutomaton(BytesRef bytesRef) {
        Automaton automaton = new Automaton();
        int n2 = automaton.createState();
        for (int i2 = 0; i2 < bytesRef.length; ++i2) {
            int n3 = automaton.createState();
            automaton.addTransition(n2, n3, bytesRef.bytes[bytesRef.offset + i2] & 0xFF);
            n2 = n3;
        }
        automaton.setAccept(n2, true);
        automaton.addTransition(n2, n2, 0, 255);
        automaton.finishState();
        assert (automaton.isDeterministic());
        return automaton;
    }

    @Override
    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.getField().equals(string)) {
            stringBuilder.append(this.getField());
            stringBuilder.append(":");
        }
        stringBuilder.append(this.term.text());
        stringBuilder.append('*');
        stringBuilder.append(ToStringUtils.boost(this.getBoost()));
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + this.term.hashCode();
        return n3;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        PrefixQuery prefixQuery = (PrefixQuery)object;
        return this.term.equals(prefixQuery.term);
    }
}

