/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Comparator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.d;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.StringHelper;

public class SortField {
    public static final SortField FIELD_SCORE = new SortField(null, Type.SCORE);
    public static final SortField FIELD_DOC = new SortField(null, Type.DOC);
    private String field;
    private Type type;
    boolean reverse = false;
    private d comparatorSource;
    public Object missingValue = null;
    public static final Object STRING_FIRST = new Object(){

        public String toString() {
            return "SortField.STRING_FIRST";
        }
    };
    public static final Object STRING_LAST = new Object(){

        public String toString() {
            return "SortField.STRING_LAST";
        }
    };
    private Comparator<BytesRef> bytesComparator = BytesRef.getUTF8SortedAsUnicodeComparator();

    public SortField(String string, Type type) {
        this.initFieldType(string, type);
    }

    public SortField(String string, Type type, boolean bl) {
        this.initFieldType(string, type);
        this.reverse = bl;
    }

    private void initFieldType(String string, Type type) {
        this.type = type;
        if (string == null) {
            if (type != Type.SCORE && type != Type.DOC) {
                throw new IllegalArgumentException("field can only be null when type is SCORE or DOC");
            }
        } else {
            this.field = string;
        }
    }

    public String getField() {
        return this.field;
    }

    public Type getType() {
        return this.type;
    }

    public boolean getReverse() {
        return this.reverse;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.type) {
            case SCORE: {
                stringBuilder.append("<score>");
                break;
            }
            case DOC: {
                stringBuilder.append("<doc>");
                break;
            }
            case STRING: {
                stringBuilder.append("<string: \"").append(this.field).append("\">");
                break;
            }
            case STRING_VAL: {
                stringBuilder.append("<string_val: \"").append(this.field).append("\">");
                break;
            }
            case INT: {
                stringBuilder.append("<int: \"").append(this.field).append("\">");
                break;
            }
            case LONG: {
                stringBuilder.append("<long: \"").append(this.field).append("\">");
                break;
            }
            case FLOAT: {
                stringBuilder.append("<float: \"").append(this.field).append("\">");
                break;
            }
            case DOUBLE: {
                stringBuilder.append("<double: \"").append(this.field).append("\">");
                break;
            }
            case CUSTOM: {
                stringBuilder.append("<custom:\"").append(this.field).append("\": ").append(this.comparatorSource).append('>');
                break;
            }
            case REWRITEABLE: {
                stringBuilder.append("<rewriteable: \"").append(this.field).append("\">");
                break;
            }
            default: {
                stringBuilder.append("<???: \"").append(this.field).append("\">");
            }
        }
        if (this.reverse) {
            stringBuilder.append('!');
        }
        if (this.missingValue != null) {
            stringBuilder.append(" missingValue=");
            stringBuilder.append(this.missingValue);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SortField)) {
            return false;
        }
        SortField sortField = (SortField)object;
        return StringHelper.equals(sortField.field, this.field) && sortField.type == this.type && sortField.reverse == this.reverse && (sortField.comparatorSource == null ? this.comparatorSource == null : sortField.comparatorSource.equals(this.comparatorSource));
    }

    public int hashCode() {
        int n2 = this.type.hashCode() ^ 879060445 + Boolean.valueOf(this.reverse).hashCode() ^ 0xAF5998BB;
        if (this.field != null) {
            n2 += this.field.hashCode() ^ 0xFF5685DD;
        }
        if (this.comparatorSource != null) {
            n2 += this.comparatorSource.hashCode();
        }
        return n2;
    }

    public FieldComparator<?> getComparator(int n2, int n3) throws IOException {
        switch (this.type) {
            case SCORE: {
                return new FieldComparator.RelevanceComparator(n2);
            }
            case DOC: {
                return new FieldComparator.DocComparator(n2);
            }
            case INT: {
                return new FieldComparator.IntComparator(n2, this.field, (Integer)this.missingValue);
            }
            case FLOAT: {
                return new FieldComparator.FloatComparator(n2, this.field, (Float)this.missingValue);
            }
            case LONG: {
                return new FieldComparator.LongComparator(n2, this.field, (Long)this.missingValue);
            }
            case DOUBLE: {
                return new FieldComparator.DoubleComparator(n2, this.field, (Double)this.missingValue);
            }
            case CUSTOM: {
                assert (this.comparatorSource != null);
                return this.comparatorSource.a(this.field, n2, n3, this.reverse);
            }
            case STRING: {
                return new FieldComparator.TermOrdValComparator(n2, this.field, this.missingValue == STRING_LAST);
            }
            case STRING_VAL: {
                return new FieldComparator.TermValComparator(n2, this.field, this.missingValue == STRING_LAST);
            }
            case REWRITEABLE: {
                throw new IllegalStateException("SortField needs to be rewritten through Sort.rewrite(..) and SortField.rewrite(..)");
            }
        }
        throw new IllegalStateException("Illegal sort type: " + (Object)((Object)this.type));
    }

    public boolean needsScores() {
        return this.type == Type.SCORE;
    }

    public static enum Type {
        SCORE,
        DOC,
        STRING,
        INT,
        FLOAT,
        LONG,
        DOUBLE,
        CUSTOM,
        STRING_VAL,
        BYTES,
        REWRITEABLE;

    }
}

