/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.o;
import org.apache.lucene.index.q;
import org.apache.lucene.portmobile.util.Objects;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermScorer;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.a;
import org.apache.lucene.util.ToStringUtils;

public class TermQuery
extends Query {
    private final Term term;
    private final TermContext perReaderTermState;

    public TermQuery(Term term) {
        this.term = Objects.requireNonNull(term);
        this.perReaderTermState = null;
    }

    public TermQuery(Term term, TermContext termContext) {
        assert (termContext != null);
        this.term = Objects.requireNonNull(term);
        if (!termContext.hasOnlyRealTerms()) {
            throw new IllegalArgumentException("Term queries must be created on real terms");
        }
        this.perReaderTermState = Objects.requireNonNull(termContext);
    }

    @Override
    public Weight createWeight(IndexSearcher indexSearcher, boolean bl) throws IOException {
        IndexReaderContext indexReaderContext = indexSearcher.getTopReaderContext();
        TermContext termContext = this.perReaderTermState == null || this.perReaderTermState.topReaderContext != indexReaderContext ? TermContext.build(indexReaderContext, this.term) : this.perReaderTermState;
        return new TermWeight(indexSearcher, bl, termContext);
    }

    @Override
    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.term.field().equals(string)) {
            stringBuilder.append(this.term.field());
            stringBuilder.append(":");
        }
        stringBuilder.append(this.term.text());
        stringBuilder.append(ToStringUtils.boost(this.getBoost()));
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof TermQuery)) {
            return false;
        }
        TermQuery termQuery = (TermQuery)object;
        return super.equals(object) && this.term.equals(termQuery.term);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.term.hashCode();
    }

    final class TermWeight
    extends Weight {
        private final a similarity;
        private final a.b stats;
        private final TermContext termStates;
        private final boolean needsScores;

        public TermWeight(IndexSearcher indexSearcher, boolean bl, TermContext termContext) throws IOException {
            TermStatistics termStatistics;
            CollectionStatistics collectionStatistics;
            super(TermQuery.this);
            this.needsScores = bl;
            assert (termContext != null) : "TermContext must not be null";
            assert (termContext.hasOnlyRealTerms());
            this.termStates = termContext;
            this.similarity = indexSearcher.getSimilarity(bl);
            if (bl) {
                collectionStatistics = indexSearcher.collectionStatistics(TermQuery.this.term.field());
                termStatistics = indexSearcher.termStatistics(TermQuery.this.term, termContext);
            } else {
                int n2 = indexSearcher.getIndexReader().maxDoc();
                int n3 = termContext.docFreq();
                long l2 = termContext.totalTermFreq();
                collectionStatistics = new CollectionStatistics(TermQuery.this.term.field(), n2, -1L, -1L, -1L);
                termStatistics = new TermStatistics(TermQuery.this.term.bytes(), n3, l2);
            }
            this.stats = this.similarity.computeWeight(TermQuery.this.getBoost(), collectionStatistics, termStatistics);
        }

        public String toString() {
            return "weight(" + TermQuery.this + ")";
        }

        @Override
        public float getValueForNormalization() {
            return this.stats.getValueForNormalization();
        }

        @Override
        public void normalize(float f2, float f3) {
            this.stats.normalize(f2, f3);
        }

        @Override
        public Scorer scorer(LeafReaderContext leafReaderContext) throws IOException {
            assert (this.termStates.topReaderContext == o.a(leafReaderContext)) : "The top-reader used to create Weight (" + this.termStates.topReaderContext + ") is not the same as the current reader's top-reader (" + o.a(leafReaderContext);
            TermsEnum termsEnum = this.getTermsEnum(leafReaderContext);
            if (termsEnum == null) {
                return null;
            }
            PostingsEnum postingsEnum = termsEnum.postings(null, this.needsScores ? 8 : 0);
            assert (postingsEnum != null);
            return new TermScorer(this, postingsEnum, this.similarity.simScorer(this.stats, leafReaderContext));
        }

        private TermsEnum getTermsEnum(LeafReaderContext leafReaderContext) throws IOException {
            q q2 = this.termStates.get(leafReaderContext.ord);
            if (q2 == null) {
                assert (this.termNotInReader(leafReaderContext.reader(), TermQuery.this.term)) : "no termstate found but term exists in reader term=" + TermQuery.access$000(TermQuery.this);
                return null;
            }
            TermsEnum termsEnum = leafReaderContext.reader().terms(TermQuery.this.term.field()).iterator();
            termsEnum.seekExact(TermQuery.this.term.bytes(), q2);
            return termsEnum;
        }

        private boolean termNotInReader(LeafReader leafReader, Term term) throws IOException {
            return leafReader.docFreq(term) == 0;
        }
    }
}

