/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.f;
import org.apache.lucene.util.Bits;

public abstract class Weight {
    protected final Query parentQuery;

    protected Weight(Query query) {
        this.parentQuery = query;
    }

    public final Query getQuery() {
        return this.parentQuery;
    }

    public abstract float getValueForNormalization() throws IOException;

    public abstract void normalize(float var1, float var2);

    public abstract Scorer scorer(LeafReaderContext var1) throws IOException;

    public BulkScorer bulkScorer(LeafReaderContext leafReaderContext) throws IOException {
        Scorer scorer = this.scorer(leafReaderContext);
        if (scorer == null) {
            return null;
        }
        return new DefaultBulkScorer(scorer);
    }

    protected static class DefaultBulkScorer
    extends BulkScorer {
        private final Scorer scorer;

        public DefaultBulkScorer(Scorer scorer) {
            if (scorer == null) {
                throw new NullPointerException();
            }
            this.scorer = scorer;
        }

        @Override
        public long cost() {
            return this.scorer.cost();
        }

        @Override
        public int score(f f2, Bits bits, int n2, int n3) throws IOException {
            f2.setScorer(this.scorer);
            TwoPhaseIterator twoPhaseIterator = this.scorer.asTwoPhaseIterator();
            if (this.scorer.docID() == -1 && n2 == 0 && n3 == Integer.MAX_VALUE) {
                DefaultBulkScorer.scoreAll(f2, this.scorer, twoPhaseIterator, bits);
                return Integer.MAX_VALUE;
            }
            int n4 = this.scorer.docID();
            if (n4 < n2) {
                n4 = twoPhaseIterator == null ? this.scorer.advance(n2) : twoPhaseIterator.approximation().advance(n2);
            }
            return DefaultBulkScorer.scoreRange(f2, this.scorer, twoPhaseIterator, bits, n4, n3);
        }

        static int scoreRange(f f2, Scorer scorer, TwoPhaseIterator twoPhaseIterator, Bits bits, int n2, int n3) throws IOException {
            if (twoPhaseIterator == null) {
                while (n2 < n3) {
                    if (bits == null || bits.get(n2)) {
                        f2.collect(n2);
                    }
                    n2 = scorer.nextDoc();
                }
                return n2;
            }
            DocIdSetIterator docIdSetIterator = twoPhaseIterator.approximation();
            while (n2 < n3) {
                if ((bits == null || bits.get(n2)) && twoPhaseIterator.matches()) {
                    f2.collect(n2);
                }
                n2 = docIdSetIterator.nextDoc();
            }
            return n2;
        }

        static void scoreAll(f f2, Scorer scorer, TwoPhaseIterator twoPhaseIterator, Bits bits) throws IOException {
            if (twoPhaseIterator == null) {
                int n2 = scorer.nextDoc();
                while (n2 != Integer.MAX_VALUE) {
                    if (bits == null || bits.get(n2)) {
                        f2.collect(n2);
                    }
                    n2 = scorer.nextDoc();
                }
            } else {
                DocIdSetIterator docIdSetIterator = twoPhaseIterator.approximation();
                int n3 = docIdSetIterator.nextDoc();
                while (n3 != Integer.MAX_VALUE) {
                    if ((bits == null || bits.get(n3)) && twoPhaseIterator.matches()) {
                        f2.collect(n3);
                    }
                    n3 = docIdSetIterator.nextDoc();
                }
            }
        }
    }
}

