/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping.term;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.grouping.AbstractFirstPassGroupingCollector;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;

public class TermFirstPassGroupingCollector
extends AbstractFirstPassGroupingCollector<BytesRef> {
    private SortedDocValues index;
    private String groupField;

    public TermFirstPassGroupingCollector(String string, Sort sort, int n2) throws IOException {
        super(sort, n2);
        this.groupField = string;
    }

    @Override
    protected BytesRef getDocGroupValue(int n2) {
        int n3 = this.index.getOrd(n2);
        if (n3 == -1) {
            return null;
        }
        return this.index.lookupOrd(n3);
    }

    @Override
    protected BytesRef copyDocGroupValue(BytesRef bytesRef, BytesRef bytesRef2) {
        if (bytesRef == null) {
            return null;
        }
        if (bytesRef2 != null) {
            bytesRef2.bytes = ArrayUtil.grow(bytesRef2.bytes, bytesRef.length);
            bytesRef2.offset = 0;
            bytesRef2.length = bytesRef.length;
            System.arraycopy(bytesRef.bytes, bytesRef.offset, bytesRef2.bytes, 0, bytesRef.length);
            return bytesRef2;
        }
        return BytesRef.deepCopyOf(bytesRef);
    }

    @Override
    protected void doSetNextReader(LeafReaderContext leafReaderContext) throws IOException {
        super.doSetNextReader(leafReaderContext);
        this.index = DocValues.getSorted(leafReaderContext.reader(), this.groupField);
    }

    @Override
    public boolean needsScores() {
        return true;
    }
}

